/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v2.pointer;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.pointer.SinglePointer;
import org.spdx.storage.IModelStore;

public class ByteOffsetPointer
extends SinglePointer {
    public ByteOffsetPointer() throws InvalidSPDXAnalysisException {
    }

    public ByteOffsetPointer(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public ByteOffsetPointer(IModelStore modelStore, String documentUri, String id, IModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public String getType() {
        return "ByteOffsetPointer";
    }

    public int getOffset() throws InvalidSPDXAnalysisException {
        Optional retval = this.getIntegerPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_OFFSET);
        if (!retval.isPresent()) {
            return -1;
        }
        return (Integer)retval.get();
    }

    public void setOffset(Integer offset) throws InvalidSPDXAnalysisException {
        if (this.strict && (Objects.isNull(offset) || offset < 0)) {
            throw new InvalidSPDXAnalysisException("Can not set required offset to null or less than zero");
        }
        this.setPropertyValue(SpdxConstantsCompatV2.PROP_POINTER_OFFSET, offset);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        List<String> retval = super._verify(verifiedIds, specVersion);
        try {
            int offset = this.getOffset();
            if (offset == -1) {
                retval.add("Missing byte offset offset value");
            } else if (offset < 0) {
                retval.add("Offset most not be negative for a byte pointer: " + Integer.toString(offset));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting offset: " + e.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(SinglePointer o) {
        Integer myOffset;
        int compByteOffset;
        if (o == null) {
            return 1;
        }
        int retval = this.compareReferences(o);
        if (retval != 0) {
            return retval;
        }
        if (!(o instanceof ByteOffsetPointer)) {
            return 1;
        }
        try {
            compByteOffset = ((ByteOffsetPointer)o).getOffset();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting compare offset", (Throwable)e);
            compByteOffset = -1;
        }
        try {
            myOffset = this.getOffset();
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting offset", (Throwable)e);
            myOffset = -1;
        }
        return myOffset.compareTo(compByteOffset);
    }

    @Override
    public String toString() {
        try {
            int offset = this.getOffset();
            return "byte offset " + Integer.toString(offset);
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.warn("Error getting offset", (Throwable)e);
            return "Unknown byte offset";
        }
    }
}

