/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.ai;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PresenceType;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.library.model.v3_0_1.software.SpdxPackage;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Specifies an AI package and its associated information. 
 */
public  class AIPackage extends SpdxPackage  {

	Collection<DictionaryEntry> hyperparameters = Collections.emptyList();
	Collection<DictionaryEntry> metrics = Collections.emptyList();
	Collection<DictionaryEntry> metricDecisionThresholds = Collections.emptyList();
	Collection<String> modelDataPreprocessings = Collections.emptyList();
	Collection<String> domains = Collections.emptyList();
	Collection<String> typeOfModels = Collections.emptyList();
	Collection<String> standardCompliances = Collections.emptyList();
	Collection<String> modelExplainabilitys = Collections.emptyList();
	
	/**
	 * Create the AIPackage with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the AIPackage
	 */
	public AIPackage() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the AIPackage
	 * @throws InvalidSPDXAnalysisException when unable to create the AIPackage
	 */
	public AIPackage(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the AIPackage is to be stored
	 * @param objectUri URI or anonymous ID for the AIPackage
	 * @param copyManager Copy manager for the AIPackage - can be null if copying is not required
	 * @param create true if AIPackage is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the AIPackage
	 */
	 @SuppressWarnings("unchecked")
	public AIPackage(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			hyperparameters = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_HYPERPARAMETER, DictionaryEntry.class);
		}
		if (!isExternal()) {
			metrics = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC, DictionaryEntry.class);
		}
		if (!isExternal()) {
			metricDecisionThresholds = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC_DECISION_THRESHOLD, DictionaryEntry.class);
		}
		if (!isExternal()) {
			modelDataPreprocessings = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_DATA_PREPROCESSING, String.class);
		}
		if (!isExternal()) {
			domains = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DOMAIN, String.class);
		}
		if (!isExternal()) {
			typeOfModels = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TYPE_OF_MODEL, String.class);
		}
		if (!isExternal()) {
			standardCompliances = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_COMPLIANCE, String.class);
		}
		if (!isExternal()) {
			modelExplainabilitys = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_EXPLAINABILITY, String.class);
		}
	}

	/**
	 * Create the AIPackage from the builder - used in the builder class
	 * @param builder Builder to create the AIPackage from
	 * @throws InvalidSPDXAnalysisException when unable to create the AIPackage
	 */
	 @SuppressWarnings("unchecked")
	protected AIPackage(AIPackageBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		hyperparameters = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_HYPERPARAMETER, DictionaryEntry.class);
		metrics = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC, DictionaryEntry.class);
		metricDecisionThresholds = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_METRIC_DECISION_THRESHOLD, DictionaryEntry.class);
		modelDataPreprocessings = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_DATA_PREPROCESSING, String.class);
		domains = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_DOMAIN, String.class);
		typeOfModels = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TYPE_OF_MODEL, String.class);
		standardCompliances = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_COMPLIANCE, String.class);
		modelExplainabilitys = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_MODEL_EXPLAINABILITY, String.class);
		getHyperparameters().addAll(builder.hyperparameters);
		getMetrics().addAll(builder.metrics);
		getMetricDecisionThresholds().addAll(builder.metricDecisionThresholds);
		getModelDataPreprocessings().addAll(builder.modelDataPreprocessings);
		getDomains().addAll(builder.domains);
		getTypeOfModels().addAll(builder.typeOfModels);
		getStandardCompliances().addAll(builder.standardCompliances);
		getModelExplainabilitys().addAll(builder.modelExplainabilitys);
		setEnergyConsumption(builder.energyConsumption);
		setAutonomyType(builder.autonomyType);
		setUseSensitivePersonalInformation(builder.useSensitivePersonalInformation);
		setSafetyRiskAssessment(builder.safetyRiskAssessment);
		setInformationAboutTraining(builder.informationAboutTraining);
		setLimitation(builder.limitation);
		setInformationAboutApplication(builder.informationAboutApplication);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "AI.AIPackage";
	}
	
	// Getters and Setters
	public Collection<DictionaryEntry> getHyperparameters() {
		return hyperparameters;
	}
	public Collection<DictionaryEntry> getMetrics() {
		return metrics;
	}
	public Collection<DictionaryEntry> getMetricDecisionThresholds() {
		return metricDecisionThresholds;
	}
	public Collection<String> getModelDataPreprocessings() {
		return modelDataPreprocessings;
	}
	public Collection<String> getDomains() {
		return domains;
	}
	public Collection<String> getTypeOfModels() {
		return typeOfModels;
	}
	public Collection<String> getStandardCompliances() {
		return standardCompliances;
	}
	public Collection<String> getModelExplainabilitys() {
		return modelExplainabilitys;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
		/**
	 * @return the energyConsumption
	 */
	 @SuppressWarnings("unchecked")
	public Optional<EnergyConsumption> getEnergyConsumption() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_ENERGY_CONSUMPTION);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof EnergyConsumption)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for energyConsumption");
			}
			return (Optional<EnergyConsumption>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	
	/**
	 * @param energyConsumption the energyConsumption to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setEnergyConsumption(@Nullable EnergyConsumption energyConsumption) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_ENERGY_CONSUMPTION, energyConsumption);
		return this;
	}
	/**
	 * @param suppliedBy the suppliedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
		super.setSuppliedBy(suppliedBy);
		return this;
	}	
	/**
	 * @return the autonomyType
	 */
	 @SuppressWarnings("unchecked")
	public Optional<PresenceType> getAutonomyType() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_AUTONOMY_TYPE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof PresenceType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for autonomyType");
			}
			return (Optional<PresenceType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param autonomyType the autonomyType to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setAutonomyType(@Nullable PresenceType autonomyType) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_AUTONOMY_TYPE, autonomyType);
		return this;
	}
	/**
	 * @return the useSensitivePersonalInformation
	 */
	 @SuppressWarnings("unchecked")
	public Optional<PresenceType> getUseSensitivePersonalInformation() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_USE_SENSITIVE_PERSONAL_INFORMATION);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof PresenceType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for useSensitivePersonalInformation");
			}
			return (Optional<PresenceType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param useSensitivePersonalInformation the useSensitivePersonalInformation to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setUseSensitivePersonalInformation(@Nullable PresenceType useSensitivePersonalInformation) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_USE_SENSITIVE_PERSONAL_INFORMATION, useSensitivePersonalInformation);
		return this;
	}
	/**
	 * @return the safetyRiskAssessment
	 */
	 @SuppressWarnings("unchecked")
	public Optional<SafetyRiskAssessmentType> getSafetyRiskAssessment() throws InvalidSPDXAnalysisException {
		Optional<Enum<?>> retval = getEnumPropertyValue(SpdxConstantsV3.PROP_SAFETY_RISK_ASSESSMENT);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof SafetyRiskAssessmentType)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for safetyRiskAssessment");
			}
			return (Optional<SafetyRiskAssessmentType>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	/**
	 * @param safetyRiskAssessment the safetyRiskAssessment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setSafetyRiskAssessment(@Nullable SafetyRiskAssessmentType safetyRiskAssessment) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_SAFETY_RISK_ASSESSMENT, safetyRiskAssessment);
		return this;
	}
	/**
	 * @param primaryPurpose the primaryPurpose to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
		super.setPrimaryPurpose(primaryPurpose);
		return this;
	}	
	/**
	 * @param validUntilTime the validUntilTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
		super.setValidUntilTime(validUntilTime);
		return this;
	}	
	/**
	 * @param downloadLocation the downloadLocation to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setDownloadLocation(@Nullable String downloadLocation) throws InvalidSPDXAnalysisException {
		super.setDownloadLocation(downloadLocation);
		return this;
	}	
	/**
	 * @param builtTime the builtTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
		super.setBuiltTime(builtTime);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param packageVersion the packageVersion to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setPackageVersion(@Nullable String packageVersion) throws InvalidSPDXAnalysisException {
		super.setPackageVersion(packageVersion);
		return this;
	}	
	/**
	 * @param releaseTime the releaseTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
		super.setReleaseTime(releaseTime);
		return this;
	}	
	/**
	 * @param copyrightText the copyrightText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
		super.setCopyrightText(copyrightText);
		return this;
	}	
		/**
	 * @return the informationAboutTraining
	 */
	public Optional<String> getInformationAboutTraining() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_TRAINING);
	}
	/**
	 * @param informationAboutTraining the informationAboutTraining to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setInformationAboutTraining(@Nullable String informationAboutTraining) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_TRAINING, informationAboutTraining);
		return this;
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param homePage the homePage to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setHomePage(@Nullable String homePage) throws InvalidSPDXAnalysisException {
		super.setHomePage(homePage);
		return this;
	}	
	/**
	 * @param sourceInfo the sourceInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setSourceInfo(@Nullable String sourceInfo) throws InvalidSPDXAnalysisException {
		super.setSourceInfo(sourceInfo);
		return this;
	}	
		/**
	 * @return the limitation
	 */
	public Optional<String> getLimitation() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_LIMITATION);
	}
	/**
	 * @param limitation the limitation to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setLimitation(@Nullable String limitation) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_LIMITATION, limitation);
		return this;
	}
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	/**
	 * @param packageUrl the packageUrl to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public AIPackage setPackageUrl(@Nullable String packageUrl) throws InvalidSPDXAnalysisException {
		super.setPackageUrl(packageUrl);
		return this;
	}	
		/**
	 * @return the informationAboutApplication
	 */
	public Optional<String> getInformationAboutApplication() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_APPLICATION);
	}
	/**
	 * @param informationAboutApplication the informationAboutApplication to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public AIPackage setInformationAboutApplication(@Nullable String informationAboutApplication) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_INFORMATION_ABOUT_APPLICATION, informationAboutApplication);
		return this;
	}
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		Optional<EnergyConsumption> energyConsumption;
		try {
			energyConsumption = getEnergyConsumption();
			if (energyConsumption.isPresent()) {
				retval.addAll(energyConsumption.get().verify(verifiedIds, specVersionForVerify, profiles));
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting energyConsumption for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<PresenceType> autonomyType = getAutonomyType();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting autonomyType for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<PresenceType> useSensitivePersonalInformation = getUseSensitivePersonalInformation();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting useSensitivePersonalInformation for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<SafetyRiskAssessmentType> safetyRiskAssessment = getSafetyRiskAssessment();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting safetyRiskAssessment for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> informationAboutTraining = getInformationAboutTraining();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting informationAboutTraining for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> limitation = getLimitation();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting limitation for AIPackage: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> informationAboutApplication = getInformationAboutApplication();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting informationAboutApplication for AIPackage: "+e.getMessage());
		}
		for (DictionaryEntry hyperparameter:hyperparameters) {
			retval.addAll(hyperparameter.verify(verifiedIds, specVersionForVerify, profiles));
		}
		for (DictionaryEntry metric:metrics) {
			retval.addAll(metric.verify(verifiedIds, specVersionForVerify, profiles));
		}
		for (DictionaryEntry metricDecisionThreshold:metricDecisionThresholds) {
			retval.addAll(metricDecisionThreshold.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class AIPackageBuilder extends SpdxPackageBuilder {
	
		/**
		 * Create an AIPackageBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public AIPackageBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an AIPackageBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public AIPackageBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a AIPackageBuilder
		 * @param modelStore model store for the built AIPackage
		 * @param objectUri objectUri for the built AIPackage
		 * @param copyManager optional copyManager for the built AIPackage
		 */
		public AIPackageBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<DictionaryEntry> hyperparameters = new ArrayList<>();
		protected Collection<DictionaryEntry> metrics = new ArrayList<>();
		protected Collection<DictionaryEntry> metricDecisionThresholds = new ArrayList<>();
		protected Collection<String> modelDataPreprocessings = new ArrayList<>();
		protected Collection<String> domains = new ArrayList<>();
		protected Collection<String> typeOfModels = new ArrayList<>();
		protected Collection<String> standardCompliances = new ArrayList<>();
		protected Collection<String> modelExplainabilitys = new ArrayList<>();
		protected EnergyConsumption energyConsumption = null;
		protected PresenceType autonomyType = null;
		protected PresenceType useSensitivePersonalInformation = null;
		protected SafetyRiskAssessmentType safetyRiskAssessment = null;
		protected String informationAboutTraining = null;
		protected String limitation = null;
		protected String informationAboutApplication = null;
		
		
		/**
		 * Adds a contentIdentifier to the initial collection
		 * @parameter contentIdentifier contentIdentifier to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
			if (Objects.nonNull(contentIdentifier)) {
				super.contentIdentifiers.add(contentIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial contentIdentifier collection
		 * @parameter contentIdentifierCollection collection to initialize the contentIdentifier
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
			if (Objects.nonNull(contentIdentifierCollection)) {
				super.contentIdentifiers.addAll(contentIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a hyperparameter to the initial collection
		 * @parameter hyperparameter hyperparameter to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addHyperparameter(DictionaryEntry hyperparameter) {
			if (Objects.nonNull(hyperparameter)) {
				hyperparameters.add(hyperparameter);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial hyperparameter collection
		 * @parameter hyperparameterCollection collection to initialize the hyperparameter
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllHyperparameter(Collection<DictionaryEntry> hyperparameterCollection) {
			if (Objects.nonNull(hyperparameterCollection)) {
				hyperparameters.addAll(hyperparameterCollection);
			}
			return this;
		}
		
		/**
		 * Adds a metric to the initial collection
		 * @parameter metric metric to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addMetric(DictionaryEntry metric) {
			if (Objects.nonNull(metric)) {
				metrics.add(metric);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial metric collection
		 * @parameter metricCollection collection to initialize the metric
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllMetric(Collection<DictionaryEntry> metricCollection) {
			if (Objects.nonNull(metricCollection)) {
				metrics.addAll(metricCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a metricDecisionThreshold to the initial collection
		 * @parameter metricDecisionThreshold metricDecisionThreshold to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addMetricDecisionThreshold(DictionaryEntry metricDecisionThreshold) {
			if (Objects.nonNull(metricDecisionThreshold)) {
				metricDecisionThresholds.add(metricDecisionThreshold);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial metricDecisionThreshold collection
		 * @parameter metricDecisionThresholdCollection collection to initialize the metricDecisionThreshold
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllMetricDecisionThreshold(Collection<DictionaryEntry> metricDecisionThresholdCollection) {
			if (Objects.nonNull(metricDecisionThresholdCollection)) {
				metricDecisionThresholds.addAll(metricDecisionThresholdCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a originatedBy to the initial collection
		 * @parameter originatedBy originatedBy to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addOriginatedBy(Agent originatedBy) {
			if (Objects.nonNull(originatedBy)) {
				super.originatedBys.add(originatedBy);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial originatedBy collection
		 * @parameter originatedByCollection collection to initialize the originatedBy
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
			if (Objects.nonNull(originatedByCollection)) {
				super.originatedBys.addAll(originatedByCollection);
			}
			return this;
		}
		
		/**
		 * Adds a supportLevel to the initial collection
		 * @parameter supportLevel supportLevel to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addSupportLevel(SupportType supportLevel) {
			if (Objects.nonNull(supportLevel)) {
				super.supportLevels.add(supportLevel);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial supportLevel collection
		 * @parameter supportLevelCollection collection to initialize the supportLevel
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
			if (Objects.nonNull(supportLevelCollection)) {
				super.supportLevels.addAll(supportLevelCollection);
			}
			return this;
		}
		
		/**
		 * Adds a additionalPurpose to the initial collection
		 * @parameter additionalPurpose additionalPurpose to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
			if (Objects.nonNull(additionalPurpose)) {
				super.additionalPurposes.add(additionalPurpose);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial additionalPurpose collection
		 * @parameter additionalPurposeCollection collection to initialize the additionalPurpose
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
			if (Objects.nonNull(additionalPurposeCollection)) {
				super.additionalPurposes.addAll(additionalPurposeCollection);
			}
			return this;
		}
		
		/**
		 * Adds a modelDataPreprocessing to the initial collection
		 * @parameter modelDataPreprocessing modelDataPreprocessing to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addModelDataPreprocessing(String modelDataPreprocessing) {
			if (Objects.nonNull(modelDataPreprocessing)) {
				modelDataPreprocessings.add(modelDataPreprocessing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial modelDataPreprocessing collection
		 * @parameter modelDataPreprocessingCollection collection to initialize the modelDataPreprocessing
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllModelDataPreprocessing(Collection<String> modelDataPreprocessingCollection) {
			if (Objects.nonNull(modelDataPreprocessingCollection)) {
				modelDataPreprocessings.addAll(modelDataPreprocessingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a domain to the initial collection
		 * @parameter domain domain to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addDomain(String domain) {
			if (Objects.nonNull(domain)) {
				domains.add(domain);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial domain collection
		 * @parameter domainCollection collection to initialize the domain
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllDomain(Collection<String> domainCollection) {
			if (Objects.nonNull(domainCollection)) {
				domains.addAll(domainCollection);
			}
			return this;
		}
		
		/**
		 * Adds a attributionText to the initial collection
		 * @parameter attributionText attributionText to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addAttributionText(String attributionText) {
			if (Objects.nonNull(attributionText)) {
				super.attributionTexts.add(attributionText);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial attributionText collection
		 * @parameter attributionTextCollection collection to initialize the attributionText
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
			if (Objects.nonNull(attributionTextCollection)) {
				super.attributionTexts.addAll(attributionTextCollection);
			}
			return this;
		}
		
		/**
		 * Adds a typeOfModel to the initial collection
		 * @parameter typeOfModel typeOfModel to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addTypeOfModel(String typeOfModel) {
			if (Objects.nonNull(typeOfModel)) {
				typeOfModels.add(typeOfModel);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial typeOfModel collection
		 * @parameter typeOfModelCollection collection to initialize the typeOfModel
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllTypeOfModel(Collection<String> typeOfModelCollection) {
			if (Objects.nonNull(typeOfModelCollection)) {
				typeOfModels.addAll(typeOfModelCollection);
			}
			return this;
		}
		
		/**
		 * Adds a standardName to the initial collection
		 * @parameter standardName standardName to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addStandardName(String standardName) {
			if (Objects.nonNull(standardName)) {
				super.standardNames.add(standardName);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial standardName collection
		 * @parameter standardNameCollection collection to initialize the standardName
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllStandardName(Collection<String> standardNameCollection) {
			if (Objects.nonNull(standardNameCollection)) {
				super.standardNames.addAll(standardNameCollection);
			}
			return this;
		}
		
		/**
		 * Adds a standardCompliance to the initial collection
		 * @parameter standardCompliance standardCompliance to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addStandardCompliance(String standardCompliance) {
			if (Objects.nonNull(standardCompliance)) {
				standardCompliances.add(standardCompliance);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial standardCompliance collection
		 * @parameter standardComplianceCollection collection to initialize the standardCompliance
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllStandardCompliance(Collection<String> standardComplianceCollection) {
			if (Objects.nonNull(standardComplianceCollection)) {
				standardCompliances.addAll(standardComplianceCollection);
			}
			return this;
		}
		
		/**
		 * Adds a modelExplainability to the initial collection
		 * @parameter modelExplainability modelExplainability to add
		 * @return this for chaining
		**/
		public AIPackageBuilder addModelExplainability(String modelExplainability) {
			if (Objects.nonNull(modelExplainability)) {
				modelExplainabilitys.add(modelExplainability);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial modelExplainability collection
		 * @parameter modelExplainabilityCollection collection to initialize the modelExplainability
		 * @return this for chaining
		**/
		public AIPackageBuilder addAllModelExplainability(Collection<String> modelExplainabilityCollection) {
			if (Objects.nonNull(modelExplainabilityCollection)) {
				modelExplainabilitys.addAll(modelExplainabilityCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of energyConsumption
		 * @parameter energyConsumption value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setEnergyConsumption(EnergyConsumption energyConsumption) {
			this.energyConsumption = energyConsumption;
			return this;
		}
		
		/**
		 * Sets the initial value of suppliedBy
		 * @parameter suppliedBy value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setSuppliedBy(Agent suppliedBy) {
			super.suppliedBy = suppliedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of autonomyType
		 * @parameter autonomyType value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setAutonomyType(PresenceType autonomyType) {
			this.autonomyType = autonomyType;
			return this;
		}
		
		/**
		 * Sets the initial value of useSensitivePersonalInformation
		 * @parameter useSensitivePersonalInformation value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setUseSensitivePersonalInformation(PresenceType useSensitivePersonalInformation) {
			this.useSensitivePersonalInformation = useSensitivePersonalInformation;
			return this;
		}
		
		/**
		 * Sets the initial value of safetyRiskAssessment
		 * @parameter safetyRiskAssessment value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setSafetyRiskAssessment(SafetyRiskAssessmentType safetyRiskAssessment) {
			this.safetyRiskAssessment = safetyRiskAssessment;
			return this;
		}
		
		/**
		 * Sets the initial value of primaryPurpose
		 * @parameter primaryPurpose value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
			super.primaryPurpose = primaryPurpose;
			return this;
		}
		
		/**
		 * Sets the initial value of validUntilTime
		 * @parameter validUntilTime value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setValidUntilTime(String validUntilTime) {
			super.validUntilTime = validUntilTime;
			return this;
		}
		
		/**
		 * Sets the initial value of downloadLocation
		 * @parameter downloadLocation value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setDownloadLocation(String downloadLocation) {
			super.downloadLocation = downloadLocation;
			return this;
		}
		
		/**
		 * Sets the initial value of builtTime
		 * @parameter builtTime value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setBuiltTime(String builtTime) {
			super.builtTime = builtTime;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of packageVersion
		 * @parameter packageVersion value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setPackageVersion(String packageVersion) {
			super.packageVersion = packageVersion;
			return this;
		}
		
		/**
		 * Sets the initial value of releaseTime
		 * @parameter releaseTime value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setReleaseTime(String releaseTime) {
			super.releaseTime = releaseTime;
			return this;
		}
		
		/**
		 * Sets the initial value of copyrightText
		 * @parameter copyrightText value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setCopyrightText(String copyrightText) {
			super.copyrightText = copyrightText;
			return this;
		}
		
		/**
		 * Sets the initial value of informationAboutTraining
		 * @parameter informationAboutTraining value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setInformationAboutTraining(String informationAboutTraining) {
			this.informationAboutTraining = informationAboutTraining;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of homePage
		 * @parameter homePage value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setHomePage(String homePage) {
			super.homePage = homePage;
			return this;
		}
		
		/**
		 * Sets the initial value of sourceInfo
		 * @parameter sourceInfo value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setSourceInfo(String sourceInfo) {
			super.sourceInfo = sourceInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of limitation
		 * @parameter limitation value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setLimitation(String limitation) {
			this.limitation = limitation;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of packageUrl
		 * @parameter packageUrl value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setPackageUrl(String packageUrl) {
			super.packageUrl = packageUrl;
			return this;
		}
		
		/**
		 * Sets the initial value of informationAboutApplication
		 * @parameter informationAboutApplication value to set
		 * @return this for chaining
		**/
		public AIPackageBuilder setInformationAboutApplication(String informationAboutApplication) {
			this.informationAboutApplication = informationAboutApplication;
			return this;
		}
	
		/**
		 * @return the AIPackage
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public AIPackage build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new AIPackage(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
