/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.ai;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A class for describing the energy consumption incurred by an AI model in different 
 * stages of its lifecycle. 
 */
public  class EnergyConsumption extends ModelObjectV3  {

	Collection<EnergyConsumptionDescription> trainingEnergyConsumptions = Collections.emptyList();
	Collection<EnergyConsumptionDescription> finetuningEnergyConsumptions = Collections.emptyList();
	Collection<EnergyConsumptionDescription> inferenceEnergyConsumptions = Collections.emptyList();
	
	/**
	 * Create the EnergyConsumption with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumption
	 */
	public EnergyConsumption() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the EnergyConsumption
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumption
	 */
	public EnergyConsumption(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the EnergyConsumption is to be stored
	 * @param objectUri URI or anonymous ID for the EnergyConsumption
	 * @param copyManager Copy manager for the EnergyConsumption - can be null if copying is not required
	 * @param create true if EnergyConsumption is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumption
	 */
	 @SuppressWarnings("unchecked")
	public EnergyConsumption(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			trainingEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TRAINING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		}
		if (!isExternal()) {
			finetuningEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_FINETUNING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		}
		if (!isExternal()) {
			inferenceEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_INFERENCE_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		}
	}

	/**
	 * Create the EnergyConsumption from the builder - used in the builder class
	 * @param builder Builder to create the EnergyConsumption from
	 * @throws InvalidSPDXAnalysisException when unable to create the EnergyConsumption
	 */
	 @SuppressWarnings("unchecked")
	protected EnergyConsumption(EnergyConsumptionBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		trainingEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TRAINING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		finetuningEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_FINETUNING_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		inferenceEnergyConsumptions = (Collection<EnergyConsumptionDescription>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_INFERENCE_ENERGY_CONSUMPTION, EnergyConsumptionDescription.class);
		getTrainingEnergyConsumptions().addAll(builder.trainingEnergyConsumptions);
		getFinetuningEnergyConsumptions().addAll(builder.finetuningEnergyConsumptions);
		getInferenceEnergyConsumptions().addAll(builder.inferenceEnergyConsumptions);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "AI.EnergyConsumption";
	}
	
	// Getters and Setters
	public Collection<EnergyConsumptionDescription> getTrainingEnergyConsumptions() {
		return trainingEnergyConsumptions;
	}
	public Collection<EnergyConsumptionDescription> getFinetuningEnergyConsumptions() {
		return finetuningEnergyConsumptions;
	}
	public Collection<EnergyConsumptionDescription> getInferenceEnergyConsumptions() {
		return inferenceEnergyConsumptions;
	}
	
	
	
	@Override
	public String toString() {
		return "EnergyConsumption: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		for (EnergyConsumptionDescription trainingEnergyConsumption:trainingEnergyConsumptions) {
			retval.addAll(trainingEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
		}
		for (EnergyConsumptionDescription finetuningEnergyConsumption:finetuningEnergyConsumptions) {
			retval.addAll(finetuningEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
		}
		for (EnergyConsumptionDescription inferenceEnergyConsumption:inferenceEnergyConsumptions) {
			retval.addAll(inferenceEnergyConsumption.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class EnergyConsumptionBuilder extends ModelObjectV3Builder {
	
		/**
		 * Create an EnergyConsumptionBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public EnergyConsumptionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an EnergyConsumptionBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public EnergyConsumptionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a EnergyConsumptionBuilder
		 * @param modelStore model store for the built EnergyConsumption
		 * @param objectUri objectUri for the built EnergyConsumption
		 * @param copyManager optional copyManager for the built EnergyConsumption
		 */
		public EnergyConsumptionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<EnergyConsumptionDescription> trainingEnergyConsumptions = new ArrayList<>();
		protected Collection<EnergyConsumptionDescription> finetuningEnergyConsumptions = new ArrayList<>();
		protected Collection<EnergyConsumptionDescription> inferenceEnergyConsumptions = new ArrayList<>();
		
		
		/**
		 * Adds a trainingEnergyConsumption to the initial collection
		 * @parameter trainingEnergyConsumption trainingEnergyConsumption to add
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addTrainingEnergyConsumption(EnergyConsumptionDescription trainingEnergyConsumption) {
			if (Objects.nonNull(trainingEnergyConsumption)) {
				trainingEnergyConsumptions.add(trainingEnergyConsumption);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial trainingEnergyConsumption collection
		 * @parameter trainingEnergyConsumptionCollection collection to initialize the trainingEnergyConsumption
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addAllTrainingEnergyConsumption(Collection<EnergyConsumptionDescription> trainingEnergyConsumptionCollection) {
			if (Objects.nonNull(trainingEnergyConsumptionCollection)) {
				trainingEnergyConsumptions.addAll(trainingEnergyConsumptionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a finetuningEnergyConsumption to the initial collection
		 * @parameter finetuningEnergyConsumption finetuningEnergyConsumption to add
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addFinetuningEnergyConsumption(EnergyConsumptionDescription finetuningEnergyConsumption) {
			if (Objects.nonNull(finetuningEnergyConsumption)) {
				finetuningEnergyConsumptions.add(finetuningEnergyConsumption);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial finetuningEnergyConsumption collection
		 * @parameter finetuningEnergyConsumptionCollection collection to initialize the finetuningEnergyConsumption
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addAllFinetuningEnergyConsumption(Collection<EnergyConsumptionDescription> finetuningEnergyConsumptionCollection) {
			if (Objects.nonNull(finetuningEnergyConsumptionCollection)) {
				finetuningEnergyConsumptions.addAll(finetuningEnergyConsumptionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a inferenceEnergyConsumption to the initial collection
		 * @parameter inferenceEnergyConsumption inferenceEnergyConsumption to add
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addInferenceEnergyConsumption(EnergyConsumptionDescription inferenceEnergyConsumption) {
			if (Objects.nonNull(inferenceEnergyConsumption)) {
				inferenceEnergyConsumptions.add(inferenceEnergyConsumption);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial inferenceEnergyConsumption collection
		 * @parameter inferenceEnergyConsumptionCollection collection to initialize the inferenceEnergyConsumption
		 * @return this for chaining
		**/
		public EnergyConsumptionBuilder addAllInferenceEnergyConsumption(Collection<EnergyConsumptionDescription> inferenceEnergyConsumptionCollection) {
			if (Objects.nonNull(inferenceEnergyConsumptionCollection)) {
				inferenceEnergyConsumptions.addAll(inferenceEnergyConsumptionCollection);
			}
			return this;
		}
	
		/**
		 * @return the EnergyConsumption
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public EnergyConsumption build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new EnergyConsumption(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
