/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A collection of Elements, not necessarily with unifying context. 
 */
public abstract class ElementCollection extends Element  {

	Collection<Element> elements = Collections.emptyList();
	Collection<Element> rootElements = Collections.emptyList();
	Collection<ProfileIdentifierType> profileConformances = Collections.emptyList();
	
	/**
	 * Create the ElementCollection with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the ElementCollection
	 */
	public ElementCollection() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the ElementCollection
	 * @throws InvalidSPDXAnalysisException when unable to create the ElementCollection
	 */
	public ElementCollection(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the ElementCollection is to be stored
	 * @param objectUri URI or anonymous ID for the ElementCollection
	 * @param copyManager Copy manager for the ElementCollection - can be null if copying is not required
	 * @param create true if ElementCollection is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the ElementCollection
	 */
	 @SuppressWarnings("unchecked")
	public ElementCollection(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			elements = (Collection<Element>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ELEMENT, Element.class);
		}
		if (!isExternal()) {
			rootElements = (Collection<Element>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ROOT_ELEMENT, Element.class);
		}
		if (!isExternal()) {
			profileConformances = (Collection<ProfileIdentifierType>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PROFILE_CONFORMANCE, ProfileIdentifierType.class);
		}
	}

	/**
	 * Create the ElementCollection from the builder - used in the builder class
	 * @param builder Builder to create the ElementCollection from
	 * @throws InvalidSPDXAnalysisException when unable to create the ElementCollection
	 */
	 @SuppressWarnings("unchecked")
	protected ElementCollection(ElementCollectionBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		elements = (Collection<Element>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ELEMENT, Element.class);
		rootElements = (Collection<Element>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ROOT_ELEMENT, Element.class);
		profileConformances = (Collection<ProfileIdentifierType>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PROFILE_CONFORMANCE, ProfileIdentifierType.class);
		getElements().addAll(builder.elements);
		getRootElements().addAll(builder.rootElements);
		getProfileConformances().addAll(builder.profileConformances);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Core.ElementCollection";
	}
	
	// Getters and Setters
	public Collection<Element> getElements() {
		return elements;
	}
	public Collection<Element> getRootElements() {
		return rootElements;
	}
	public Collection<ProfileIdentifierType> getProfileConformances() {
		return profileConformances;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ElementCollection setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ElementCollection setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ElementCollection setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ElementCollection setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ElementCollection setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		for (Element element:elements) {
			retval.addAll(element.verify(verifiedIds, specVersionForVerify, profiles));
		}
		for (Element rootElement:rootElements) {
			retval.addAll(rootElement.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static abstract class ElementCollectionBuilder extends ElementBuilder {
	
		/**
		 * Create an ElementCollectionBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public ElementCollectionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an ElementCollectionBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public ElementCollectionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a ElementCollectionBuilder
		 * @param modelStore model store for the built ElementCollection
		 * @param objectUri objectUri for the built ElementCollection
		 * @param copyManager optional copyManager for the built ElementCollection
		 */
		public ElementCollectionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<Element> elements = new ArrayList<>();
		protected Collection<Element> rootElements = new ArrayList<>();
		protected Collection<ProfileIdentifierType> profileConformances = new ArrayList<>();
		
		
		/**
		 * Adds a element to the initial collection
		 * @parameter element element to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addElement(Element element) {
			if (Objects.nonNull(element)) {
				elements.add(element);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial element collection
		 * @parameter elementCollection collection to initialize the element
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllElement(Collection<Element> elementCollection) {
			if (Objects.nonNull(elementCollection)) {
				elements.addAll(elementCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a rootElement to the initial collection
		 * @parameter rootElement rootElement to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addRootElement(Element rootElement) {
			if (Objects.nonNull(rootElement)) {
				rootElements.add(rootElement);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial rootElement collection
		 * @parameter rootElementCollection collection to initialize the rootElement
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllRootElement(Collection<Element> rootElementCollection) {
			if (Objects.nonNull(rootElementCollection)) {
				rootElements.addAll(rootElementCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a profileConformance to the initial collection
		 * @parameter profileConformance profileConformance to add
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addProfileConformance(ProfileIdentifierType profileConformance) {
			if (Objects.nonNull(profileConformance)) {
				profileConformances.add(profileConformance);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial profileConformance collection
		 * @parameter profileConformanceCollection collection to initialize the profileConformance
		 * @return this for chaining
		**/
		public ElementCollectionBuilder addAllProfileConformance(Collection<ProfileIdentifierType> profileConformanceCollection) {
			if (Objects.nonNull(profileConformanceCollection)) {
				profileConformances.addAll(profileConformanceCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public ElementCollectionBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public ElementCollectionBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public ElementCollectionBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public ElementCollectionBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public ElementCollectionBuilder setName(String name) {
			super.name = name;
			return this;
		}
	
		/**
		 * @return the ElementCollection
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public abstract ElementCollection build() throws InvalidSPDXAnalysisException;
	}
}
