/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import org.spdx.core.IndividualUriValue;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Specifies the type of an external identifier. 
 */
public enum ExternalIdentifierType implements IndividualUriValue {

	CPE22("cpe22"),
	CVE("cve"),
	URL_SCHEME("urlScheme"),
	SWHID("swhid"),
	EMAIL("email"),
	CPE23("cpe23"),
	OTHER("other"),
	GITOID("gitoid"),
	SECURITY_OTHER("securityOther"),
	PACKAGE_URL("packageUrl"),
	SWID("swid");
	
	private String longName;
	
	private ExternalIdentifierType(String longName) {
		this.longName = longName;
	}
	
	@Override
	public String getIndividualURI() {
		return getNameSpace() + "/" + getLongName();
	}
	
	public String getLongName() {
		return longName;
	}
	
	public String getNameSpace() {
		return "https://spdx.org/rdf/3.0.1/terms/Core/ExternalIdentifierType";
	}
}

