/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.core;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A map of Element identifiers that are used within a Document but defined external 
 * to that Document. 
 */
public  class ExternalMap extends ModelObjectV3  {

	Collection<IntegrityMethod> verifiedUsings = Collections.emptyList();
	
	/**
	 * Create the ExternalMap with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalMap
	 */
	public ExternalMap() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the ExternalMap
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalMap
	 */
	public ExternalMap(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the ExternalMap is to be stored
	 * @param objectUri URI or anonymous ID for the ExternalMap
	 * @param copyManager Copy manager for the ExternalMap - can be null if copying is not required
	 * @param create true if ExternalMap is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalMap
	 */
	 @SuppressWarnings("unchecked")
	public ExternalMap(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			verifiedUsings = (Collection<IntegrityMethod>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
		}
	}

	/**
	 * Create the ExternalMap from the builder - used in the builder class
	 * @param builder Builder to create the ExternalMap from
	 * @throws InvalidSPDXAnalysisException when unable to create the ExternalMap
	 */
	 @SuppressWarnings("unchecked")
	protected ExternalMap(ExternalMapBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		verifiedUsings = (Collection<IntegrityMethod>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_VERIFIED_USING, IntegrityMethod.class);
		getVerifiedUsings().addAll(builder.verifiedUsings);
		setDefiningArtifact(builder.definingArtifact);
		if (Objects.nonNull(builder.externalSpdxId)) {
			setExternalSpdxId(builder.externalSpdxId);
		}
		setLocationHint(builder.locationHint);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Core.ExternalMap";
	}
	
	// Getters and Setters
	public Collection<IntegrityMethod> getVerifiedUsings() {
		return verifiedUsings;
	}
	
		/**
	 * @return the definingArtifact
	 */
	 @SuppressWarnings("unchecked")
	public Optional<Artifact> getDefiningArtifact() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_DEFINING_ARTIFACT);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof Artifact)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for definingArtifact");
			}
			return (Optional<Artifact>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	
	/**
	 * @param definingArtifact the definingArtifact to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalMap setDefiningArtifact(@Nullable Artifact definingArtifact) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DEFINING_ARTIFACT, definingArtifact);
		return this;
	}
	/**
	 * @return the externalSpdxId
	 */
	public @Nullable String getExternalSpdxId() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_SPDX_ID);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param externalSpdxId the externalSpdxId to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalMap setExternalSpdxId(@Nullable String externalSpdxId) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(externalSpdxId)) {
			throw new InvalidSPDXAnalysisException("externalSpdxId is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_SPDX_ID, externalSpdxId);
		return this;
	}
		/**
	 * @return the locationHint
	 */
	public Optional<String> getLocationHint() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_LOCATION_HINT);
	}
	/**
	 * @param locationHint the locationHint to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ExternalMap setLocationHint(@Nullable String locationHint) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_LOCATION_HINT, locationHint);
		return this;
	}
	
	
	@Override
	public String toString() {
		return "ExternalMap: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		Optional<Artifact> definingArtifact;
		try {
			definingArtifact = getDefiningArtifact();
			if (definingArtifact.isPresent()) {
				retval.addAll(definingArtifact.get().verify(verifiedIds, specVersionForVerify, profiles));
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting definingArtifact for ExternalMap: "+e.getMessage());
		}
		try {
			String externalSpdxId = getExternalSpdxId();
			if (Objects.isNull(externalSpdxId) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.CORE }))) {
				retval.add("Missing externalSpdxId in ExternalMap");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting externalSpdxId for ExternalMap: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> locationHint = getLocationHint();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting locationHint for ExternalMap: "+e.getMessage());
		}
		for (IntegrityMethod verifiedUsing:verifiedUsings) {
			retval.addAll(verifiedUsing.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class ExternalMapBuilder extends ModelObjectV3Builder {
	
		/**
		 * Create an ExternalMapBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public ExternalMapBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an ExternalMapBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public ExternalMapBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a ExternalMapBuilder
		 * @param modelStore model store for the built ExternalMap
		 * @param objectUri objectUri for the built ExternalMap
		 * @param copyManager optional copyManager for the built ExternalMap
		 */
		public ExternalMapBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<IntegrityMethod> verifiedUsings = new ArrayList<>();
		protected Artifact definingArtifact = null;
		protected String externalSpdxId = null;
		protected String locationHint = null;
		
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public ExternalMapBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public ExternalMapBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of definingArtifact
		 * @parameter definingArtifact value to set
		 * @return this for chaining
		**/
		public ExternalMapBuilder setDefiningArtifact(Artifact definingArtifact) {
			this.definingArtifact = definingArtifact;
			return this;
		}
		
		/**
		 * Sets the initial value of externalSpdxId
		 * @parameter externalSpdxId value to set
		 * @return this for chaining
		**/
		public ExternalMapBuilder setExternalSpdxId(String externalSpdxId) {
			this.externalSpdxId = externalSpdxId;
			return this;
		}
		
		/**
		 * Sets the initial value of locationHint
		 * @parameter locationHint value to set
		 * @return this for chaining
		**/
		public ExternalMapBuilder setLocationHint(String locationHint) {
			this.locationHint = locationHint;
			return this;
		}
	
		/**
		 * @return the ExternalMap
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public ExternalMap build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new ExternalMap(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
