/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.expandedlicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Portion of an AnyLicenseInfo representing a set of licensing information where 
 * all elements apply. 
 */
public  class ConjunctiveLicenseSet extends AnyLicenseInfo  {

	Set<AnyLicenseInfo> members = Collections.emptySet();
	
	/**
	 * Create the ConjunctiveLicenseSet with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the ConjunctiveLicenseSet
	 */
	public ConjunctiveLicenseSet() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the ConjunctiveLicenseSet
	 * @throws InvalidSPDXAnalysisException when unable to create the ConjunctiveLicenseSet
	 */
	public ConjunctiveLicenseSet(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the ConjunctiveLicenseSet is to be stored
	 * @param objectUri URI or anonymous ID for the ConjunctiveLicenseSet
	 * @param copyManager Copy manager for the ConjunctiveLicenseSet - can be null if copying is not required
	 * @param create true if ConjunctiveLicenseSet is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the ConjunctiveLicenseSet
	 */
	 @SuppressWarnings("unchecked")
	public ConjunctiveLicenseSet(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			members = (Set<AnyLicenseInfo>)(Set<?>)this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
		}
	}

	/**
	 * Create the ConjunctiveLicenseSet from the builder - used in the builder class
	 * @param builder Builder to create the ConjunctiveLicenseSet from
	 * @throws InvalidSPDXAnalysisException when unable to create the ConjunctiveLicenseSet
	 */
	 @SuppressWarnings("unchecked")
	protected ConjunctiveLicenseSet(ConjunctiveLicenseSetBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		members = (Set<AnyLicenseInfo>)(Set<?>)this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
		getMembers().addAll(builder.members);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "ExpandedLicensing.ConjunctiveLicenseSet";
	}
	
	// Getters and Setters
	public Set<AnyLicenseInfo> getMembers() {
		return members;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ConjunctiveLicenseSet setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ConjunctiveLicenseSet setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ConjunctiveLicenseSet setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ConjunctiveLicenseSet setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ConjunctiveLicenseSet setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	
	
	@Override
	public String toString() {
				StringBuilder sb = new StringBuilder("(");
		boolean moreThanOne = false;
		Iterator<AnyLicenseInfo> iter;
		iter = this.getMembers().iterator();
		while (iter.hasNext()) {
			if (moreThanOne) {
				sb.append(" AND ");
			}
			moreThanOne = true;
			sb.append(iter.next().toString());
		}
		sb.append(')');
		return sb.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		for (AnyLicenseInfo member:members) {
			retval.addAll(member.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
		/**
	 * License sets can contain other conjunctive license sets as members.  Logically,
	 * the members of these "sub-conjunctive license sets" could be direct members and have the same
	 * meaning.
	 * @return all members "flattening out" license sets which are members of this set
	 * @throws SpdxInvalidTypeException 
	 */
	public List<AnyLicenseInfo> getFlattenedMembers() throws InvalidSPDXAnalysisException {
		HashSet<AnyLicenseInfo> retval = new HashSet<>();	// Use a set since any duplicated elements would be still considered equal
		Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
		while (iter.hasNext()) {
			AnyLicenseInfo li = iter.next();
			if (li instanceof ConjunctiveLicenseSet) {
				// we need to flatten this out
				List<AnyLicenseInfo> members = ((ConjunctiveLicenseSet)li).getFlattenedMembers();
				for (int i = 0; i < members.size(); i++) {
					retval.add(members.get(i));
				}
			} else {
				retval.add(li);
			}
		}
		List<AnyLicenseInfo> retvallist = new ArrayList<>();
		retvallist.addAll(retval);
		return retvallist;
	}

	@Override
	public int hashCode() {
		// We override equals and hashcode to take into account flattening of the license set
		// Calculate a hashcode by XOR'ing all of the hashcodes of the license set
		int retval = 1381;	// Prime number
		List<AnyLicenseInfo> allMembers;
		try {
			allMembers = this.getFlattenedMembers();
		} catch (InvalidSPDXAnalysisException e) {
			throw new RuntimeException("Error getting license set members",e);
		}
		for (AnyLicenseInfo licenseInfo:allMembers) {
			retval = retval ^ licenseInfo.hashCode();
		}
		return retval;
	}

	/* (non-Javadoc)
	 * @see org.spdx.rdfparser.license.AnyLicenseInfo#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object o) {
		// We override equals and hashcode to take into account flattening of the license set
		if (o == this) {
			return true;
		}
		if (!(o instanceof ConjunctiveLicenseSet)) {
			// covers o == null, as null is not an instance of anything
			return false;
		}
		ConjunctiveLicenseSet comp = (ConjunctiveLicenseSet)o;
		List<AnyLicenseInfo> compInfos;
		try {
			compInfos = comp.getFlattenedMembers();
		} catch (InvalidSPDXAnalysisException e) {
			throw new RuntimeException("Error getting compare license set members",e);
		}
		List<AnyLicenseInfo> myInfos;
		try {
			myInfos = this.getFlattenedMembers();
		} catch (InvalidSPDXAnalysisException e) {
			throw new RuntimeException("Error getting license set members",e);
		}
		if (compInfos.size() != myInfos.size()) {
			return false;
		}
		for (AnyLicenseInfo myInfo:myInfos) {
			if (!compInfos.contains(myInfo)) {
				return false;
			}
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.rdfparser.model.IRdfModel#equivalent(org.spdx.rdfparser.model.IRdfModel)
	 */
	@Override
	public boolean equivalent(CoreModelObject compare) throws InvalidSPDXAnalysisException {
		if (!(compare instanceof ConjunctiveLicenseSet)) {
			return false;
		}
		return setsEquivalent((ConjunctiveLicenseSet)compare);
	}

	protected boolean setsEquivalent(ConjunctiveLicenseSet compare) throws InvalidSPDXAnalysisException {
		List<AnyLicenseInfo> compInfos;
		try {
			compInfos = compare.getFlattenedMembers();
		} catch (InvalidSPDXAnalysisException e) {
			throw new RuntimeException("Error getting compare license set members",e);
		}
		List<AnyLicenseInfo> myInfos;
		try {
			myInfos = this.getFlattenedMembers();
		} catch (InvalidSPDXAnalysisException e) {
			throw new RuntimeException("Error getting license set members",e);
		}
		if (compInfos.size() != myInfos.size()) {
			return false;
		}
		for (AnyLicenseInfo myInfo:myInfos) {
			if (!compInfos.contains(myInfo)) {
				boolean found = false;
				for (AnyLicenseInfo compInfo:compInfos) {
					if (myInfo.equivalent(compInfo)) {
						found = true;
						break;
					}
				}
				if (!found) {
					return false;
				}
			}
		}
		return true;
	}
	
	public static class ConjunctiveLicenseSetBuilder extends AnyLicenseInfoBuilder {
	
		/**
		 * Create an ConjunctiveLicenseSetBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public ConjunctiveLicenseSetBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an ConjunctiveLicenseSetBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public ConjunctiveLicenseSetBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a ConjunctiveLicenseSetBuilder
		 * @param modelStore model store for the built ConjunctiveLicenseSet
		 * @param objectUri objectUri for the built ConjunctiveLicenseSet
		 * @param copyManager optional copyManager for the built ConjunctiveLicenseSet
		 */
		public ConjunctiveLicenseSetBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Set<AnyLicenseInfo> members = new HashSet<>();
		
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a member to the initial collection
		 * @parameter member member to add
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addMember(AnyLicenseInfo member) {
			if (Objects.nonNull(member)) {
				members.add(member);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial member collection
		 * @parameter memberCollection collection to initialize the member
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder addAllMember(Set<AnyLicenseInfo> memberSet) {
			if (Objects.nonNull(memberSet)) {
				members.addAll(memberSet);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public ConjunctiveLicenseSetBuilder setName(String name) {
			super.name = name;
			return this;
		}
	
		/**
		 * @return the ConjunctiveLicenseSet
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public ConjunctiveLicenseSet build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new ConjunctiveLicenseSet(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
