/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.expandedlicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A license that is not listed on the SPDX License List. 
 */
public  class CustomLicense extends License  {

	
	/**
	 * Create the CustomLicense with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the CustomLicense
	 */
	public CustomLicense() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the CustomLicense
	 * @throws InvalidSPDXAnalysisException when unable to create the CustomLicense
	 */
	public CustomLicense(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the CustomLicense is to be stored
	 * @param objectUri URI or anonymous ID for the CustomLicense
	 * @param copyManager Copy manager for the CustomLicense - can be null if copying is not required
	 * @param create true if CustomLicense is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the CustomLicense
	 */
	 @SuppressWarnings("unchecked")
	public CustomLicense(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the CustomLicense from the builder - used in the builder class
	 * @param builder Builder to create the CustomLicense from
	 * @throws InvalidSPDXAnalysisException when unable to create the CustomLicense
	 */
	 @SuppressWarnings("unchecked")
	protected CustomLicense(CustomLicenseBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "ExpandedLicensing.CustomLicense";
	}
	
	// Getters and Setters
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param isFsfLibre the isFsfLibre to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public CustomLicense setIsFsfLibre(@Nullable Boolean isFsfLibre) throws InvalidSPDXAnalysisException {
		super.setIsFsfLibre(isFsfLibre);
		return this;
	}
	/**
	 * @param isDeprecatedLicenseId the isDeprecatedLicenseId to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public CustomLicense setIsDeprecatedLicenseId(@Nullable Boolean isDeprecatedLicenseId) throws InvalidSPDXAnalysisException {
		super.setIsDeprecatedLicenseId(isDeprecatedLicenseId);
		return this;
	}
	/**
	 * @param isOsiApproved the isOsiApproved to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public CustomLicense setIsOsiApproved(@Nullable Boolean isOsiApproved) throws InvalidSPDXAnalysisException {
		super.setIsOsiApproved(isOsiApproved);
		return this;
	}
	/**
	 * @param licenseText the licenseText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
		super.setLicenseText(licenseText);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param standardLicenseTemplate the standardLicenseTemplate to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setStandardLicenseTemplate(@Nullable String standardLicenseTemplate) throws InvalidSPDXAnalysisException {
		super.setStandardLicenseTemplate(standardLicenseTemplate);
		return this;
	}	
	/**
	 * @param obsoletedBy the obsoletedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
		super.setObsoletedBy(obsoletedBy);
		return this;
	}	
	/**
	 * @param licenseXml the licenseXml to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
		super.setLicenseXml(licenseXml);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	/**
	 * @param standardLicenseHeader the standardLicenseHeader to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public CustomLicense setStandardLicenseHeader(@Nullable String standardLicenseHeader) throws InvalidSPDXAnalysisException {
		super.setStandardLicenseHeader(standardLicenseHeader);
		return this;
	}	
	
	
	@Override
	public String toString() {
		if (this.getObjectUri().contains("LicenseRef-")) {
			return (this.getObjectUri().substring(this.getObjectUri().lastIndexOf("LicenseRef-")));
		} else {
			return this.getObjectUri();
		}
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		return retval;
	}
	
	
	
	public static class CustomLicenseBuilder extends LicenseBuilder {
	
		/**
		 * Create an CustomLicenseBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public CustomLicenseBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an CustomLicenseBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public CustomLicenseBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a CustomLicenseBuilder
		 * @param modelStore model store for the built CustomLicense
		 * @param objectUri objectUri for the built CustomLicense
		 * @param copyManager optional copyManager for the built CustomLicense
		 */
		public CustomLicenseBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a seeAlso to the initial collection
		 * @parameter seeAlso seeAlso to add
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addSeeAlso(String seeAlso) {
			if (Objects.nonNull(seeAlso)) {
				super.seeAlsos.add(seeAlso);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial seeAlso collection
		 * @parameter seeAlsoCollection collection to initialize the seeAlso
		 * @return this for chaining
		**/
		public CustomLicenseBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
			if (Objects.nonNull(seeAlsoCollection)) {
				super.seeAlsos.addAll(seeAlsoCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of isFsfLibre
		 * @parameter isFsfLibre value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setIsFsfLibre(Boolean isFsfLibre) {
			super.isFsfLibre = isFsfLibre;
			return this;
		}
		
		/**
		 * Sets the initial value of isDeprecatedLicenseId
		 * @parameter isDeprecatedLicenseId value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setIsDeprecatedLicenseId(Boolean isDeprecatedLicenseId) {
			super.isDeprecatedLicenseId = isDeprecatedLicenseId;
			return this;
		}
		
		/**
		 * Sets the initial value of isOsiApproved
		 * @parameter isOsiApproved value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setIsOsiApproved(Boolean isOsiApproved) {
			super.isOsiApproved = isOsiApproved;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseText
		 * @parameter licenseText value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setLicenseText(String licenseText) {
			super.licenseText = licenseText;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseTemplate
		 * @parameter standardLicenseTemplate value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setStandardLicenseTemplate(String standardLicenseTemplate) {
			super.standardLicenseTemplate = standardLicenseTemplate;
			return this;
		}
		
		/**
		 * Sets the initial value of obsoletedBy
		 * @parameter obsoletedBy value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setObsoletedBy(String obsoletedBy) {
			super.obsoletedBy = obsoletedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseXml
		 * @parameter licenseXml value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setLicenseXml(String licenseXml) {
			super.licenseXml = licenseXml;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseHeader
		 * @parameter standardLicenseHeader value to set
		 * @return this for chaining
		**/
		public CustomLicenseBuilder setStandardLicenseHeader(String standardLicenseHeader) {
			super.standardLicenseHeader = standardLicenseHeader;
			return this;
		}
	
		/**
		 * @return the CustomLicense
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public CustomLicense build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new CustomLicense(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
