/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.expandedlicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Abstract class for the portion of an AnyLicenseInfo representing a license. 
 */
public abstract class License extends ExtendableLicense  {

	Collection<String> seeAlsos = Collections.emptyList();
	
	/**
	 * Create the License with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the License
	 */
	public License() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the License
	 * @throws InvalidSPDXAnalysisException when unable to create the License
	 */
	public License(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the License is to be stored
	 * @param objectUri URI or anonymous ID for the License
	 * @param copyManager Copy manager for the License - can be null if copying is not required
	 * @param create true if License is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the License
	 */
	 @SuppressWarnings("unchecked")
	public License(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			seeAlsos = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
		}
	}

	/**
	 * Create the License from the builder - used in the builder class
	 * @param builder Builder to create the License from
	 * @throws InvalidSPDXAnalysisException when unable to create the License
	 */
	 @SuppressWarnings("unchecked")
	protected License(LicenseBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		seeAlsos = (Collection<String>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SEE_ALSO, String.class);
		getSeeAlsos().addAll(builder.seeAlsos);
		setIsFsfLibre(builder.isFsfLibre);
		setIsDeprecatedLicenseId(builder.isDeprecatedLicenseId);
		setIsOsiApproved(builder.isOsiApproved);
		if (Objects.nonNull(builder.licenseText)) {
			setLicenseText(builder.licenseText);
		}
		setStandardLicenseTemplate(builder.standardLicenseTemplate);
		setObsoletedBy(builder.obsoletedBy);
		setLicenseXml(builder.licenseXml);
		setStandardLicenseHeader(builder.standardLicenseHeader);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "ExpandedLicensing.License";
	}
	
	// Getters and Setters
	public Collection<String> getSeeAlsos() {
		return seeAlsos;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public License setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
		/**
	 * @return the isFsfLibre
	 */
	public Optional<Boolean> getIsFsfLibre() throws InvalidSPDXAnalysisException {
		return getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_FSF_LIBRE);
	}
	
	/**
	 * @param isFsfLibre the isFsfLibre to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setIsFsfLibre(@Nullable Boolean isFsfLibre) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_IS_FSF_LIBRE, isFsfLibre);
		return this;
	}
		/**
	 * @return the isDeprecatedLicenseId
	 */
	public Optional<Boolean> getIsDeprecatedLicenseId() throws InvalidSPDXAnalysisException {
		return getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID);
	}
	
	/**
	 * @param isDeprecatedLicenseId the isDeprecatedLicenseId to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setIsDeprecatedLicenseId(@Nullable Boolean isDeprecatedLicenseId) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_IS_DEPRECATED_LICENSE_ID, isDeprecatedLicenseId);
		return this;
	}
		/**
	 * @return the isOsiApproved
	 */
	public Optional<Boolean> getIsOsiApproved() throws InvalidSPDXAnalysisException {
		return getBooleanPropertyValue(SpdxConstantsV3.PROP_IS_OSI_APPROVED);
	}
	
	/**
	 * @param isOsiApproved the isOsiApproved to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setIsOsiApproved(@Nullable Boolean isOsiApproved) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_IS_OSI_APPROVED, isOsiApproved);
		return this;
	}
	/**
	 * @return the licenseText
	 */
	public @Nullable String getLicenseText() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param licenseText the licenseText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(licenseText)) {
			throw new InvalidSPDXAnalysisException("licenseText is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_LICENSE_TEXT, licenseText);
		return this;
	}
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public License setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public License setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
		/**
	 * @return the standardLicenseTemplate
	 */
	public Optional<String> getStandardLicenseTemplate() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE);
	}
	/**
	 * @param standardLicenseTemplate the standardLicenseTemplate to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setStandardLicenseTemplate(@Nullable String standardLicenseTemplate) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_TEMPLATE, standardLicenseTemplate);
		return this;
	}
		/**
	 * @return the obsoletedBy
	 */
	public Optional<String> getObsoletedBy() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY);
	}
	/**
	 * @param obsoletedBy the obsoletedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_OBSOLETED_BY, obsoletedBy);
		return this;
	}
		/**
	 * @return the licenseXml
	 */
	public Optional<String> getLicenseXml() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML);
	}
	/**
	 * @param licenseXml the licenseXml to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_LICENSE_XML, licenseXml);
		return this;
	}
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public License setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public License setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
		/**
	 * @return the standardLicenseHeader
	 */
	public Optional<String> getStandardLicenseHeader() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER);
	}
	/**
	 * @param standardLicenseHeader the standardLicenseHeader to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public License setStandardLicenseHeader(@Nullable String standardLicenseHeader) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_STANDARD_LICENSE_HEADER, standardLicenseHeader);
		return this;
	}
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			@SuppressWarnings("unused")
			Optional<Boolean> isFsfLibre = getIsFsfLibre();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting isFsfLibre for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<Boolean> isDeprecatedLicenseId = getIsDeprecatedLicenseId();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting isDeprecatedLicenseId for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<Boolean> isOsiApproved = getIsOsiApproved();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting isOsiApproved for License: "+e.getMessage());
		}
		try {
			String licenseText = getLicenseText();
			if (Objects.isNull(licenseText) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.EXPANDED_LICENSING }))) {
				retval.add("Missing licenseText in License");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting licenseText for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> standardLicenseTemplate = getStandardLicenseTemplate();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting standardLicenseTemplate for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> obsoletedBy = getObsoletedBy();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting obsoletedBy for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> licenseXml = getLicenseXml();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting licenseXml for License: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> standardLicenseHeader = getStandardLicenseHeader();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting standardLicenseHeader for License: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static abstract class LicenseBuilder extends ExtendableLicenseBuilder {
	
		/**
		 * Create an LicenseBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public LicenseBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an LicenseBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public LicenseBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a LicenseBuilder
		 * @param modelStore model store for the built License
		 * @param objectUri objectUri for the built License
		 * @param copyManager optional copyManager for the built License
		 */
		public LicenseBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<String> seeAlsos = new ArrayList<>();
		protected Boolean isFsfLibre = null;
		protected Boolean isDeprecatedLicenseId = null;
		protected Boolean isOsiApproved = null;
		protected String licenseText = null;
		protected String standardLicenseTemplate = null;
		protected String obsoletedBy = null;
		protected String licenseXml = null;
		protected String standardLicenseHeader = null;
		
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public LicenseBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public LicenseBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public LicenseBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public LicenseBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public LicenseBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public LicenseBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public LicenseBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public LicenseBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a seeAlso to the initial collection
		 * @parameter seeAlso seeAlso to add
		 * @return this for chaining
		**/
		public LicenseBuilder addSeeAlso(String seeAlso) {
			if (Objects.nonNull(seeAlso)) {
				seeAlsos.add(seeAlso);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial seeAlso collection
		 * @parameter seeAlsoCollection collection to initialize the seeAlso
		 * @return this for chaining
		**/
		public LicenseBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
			if (Objects.nonNull(seeAlsoCollection)) {
				seeAlsos.addAll(seeAlsoCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of isFsfLibre
		 * @parameter isFsfLibre value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setIsFsfLibre(Boolean isFsfLibre) {
			this.isFsfLibre = isFsfLibre;
			return this;
		}
		
		/**
		 * Sets the initial value of isDeprecatedLicenseId
		 * @parameter isDeprecatedLicenseId value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setIsDeprecatedLicenseId(Boolean isDeprecatedLicenseId) {
			this.isDeprecatedLicenseId = isDeprecatedLicenseId;
			return this;
		}
		
		/**
		 * Sets the initial value of isOsiApproved
		 * @parameter isOsiApproved value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setIsOsiApproved(Boolean isOsiApproved) {
			this.isOsiApproved = isOsiApproved;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseText
		 * @parameter licenseText value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setLicenseText(String licenseText) {
			this.licenseText = licenseText;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseTemplate
		 * @parameter standardLicenseTemplate value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setStandardLicenseTemplate(String standardLicenseTemplate) {
			this.standardLicenseTemplate = standardLicenseTemplate;
			return this;
		}
		
		/**
		 * Sets the initial value of obsoletedBy
		 * @parameter obsoletedBy value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setObsoletedBy(String obsoletedBy) {
			this.obsoletedBy = obsoletedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseXml
		 * @parameter licenseXml value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setLicenseXml(String licenseXml) {
			this.licenseXml = licenseXml;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseHeader
		 * @parameter standardLicenseHeader value to set
		 * @return this for chaining
		**/
		public LicenseBuilder setStandardLicenseHeader(String standardLicenseHeader) {
			this.standardLicenseHeader = standardLicenseHeader;
			return this;
		}
	
		/**
		 * @return the License
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public abstract License build() throws InvalidSPDXAnalysisException;
	}
}
