/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.expandedlicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A license that is listed on the SPDX License List. 
 */
public  class ListedLicense extends License  {

	
	/**
	 * Create the ListedLicense with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the ListedLicense
	 */
	public ListedLicense() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the ListedLicense
	 * @throws InvalidSPDXAnalysisException when unable to create the ListedLicense
	 */
	public ListedLicense(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the ListedLicense is to be stored
	 * @param objectUri URI or anonymous ID for the ListedLicense
	 * @param copyManager Copy manager for the ListedLicense - can be null if copying is not required
	 * @param create true if ListedLicense is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the ListedLicense
	 */
	 @SuppressWarnings("unchecked")
	public ListedLicense(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the ListedLicense from the builder - used in the builder class
	 * @param builder Builder to create the ListedLicense from
	 * @throws InvalidSPDXAnalysisException when unable to create the ListedLicense
	 */
	 @SuppressWarnings("unchecked")
	protected ListedLicense(ListedLicenseBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		setListVersionAdded(builder.listVersionAdded);
		setDeprecatedVersion(builder.deprecatedVersion);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "ExpandedLicensing.ListedLicense";
	}
	
	// Getters and Setters
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param isFsfLibre the isFsfLibre to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ListedLicense setIsFsfLibre(@Nullable Boolean isFsfLibre) throws InvalidSPDXAnalysisException {
		super.setIsFsfLibre(isFsfLibre);
		return this;
	}
	/**
	 * @param isDeprecatedLicenseId the isDeprecatedLicenseId to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ListedLicense setIsDeprecatedLicenseId(@Nullable Boolean isDeprecatedLicenseId) throws InvalidSPDXAnalysisException {
		super.setIsDeprecatedLicenseId(isDeprecatedLicenseId);
		return this;
	}
	/**
	 * @param isOsiApproved the isOsiApproved to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ListedLicense setIsOsiApproved(@Nullable Boolean isOsiApproved) throws InvalidSPDXAnalysisException {
		super.setIsOsiApproved(isOsiApproved);
		return this;
	}
	/**
	 * @param licenseText the licenseText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setLicenseText(@Nullable String licenseText) throws InvalidSPDXAnalysisException {
		super.setLicenseText(licenseText);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param standardLicenseTemplate the standardLicenseTemplate to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setStandardLicenseTemplate(@Nullable String standardLicenseTemplate) throws InvalidSPDXAnalysisException {
		super.setStandardLicenseTemplate(standardLicenseTemplate);
		return this;
	}	
	/**
	 * @param obsoletedBy the obsoletedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setObsoletedBy(@Nullable String obsoletedBy) throws InvalidSPDXAnalysisException {
		super.setObsoletedBy(obsoletedBy);
		return this;
	}	
		/**
	 * @return the listVersionAdded
	 */
	public Optional<String> getListVersionAdded() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_LIST_VERSION_ADDED);
	}
	/**
	 * @param listVersionAdded the listVersionAdded to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ListedLicense setListVersionAdded(@Nullable String listVersionAdded) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_LIST_VERSION_ADDED, listVersionAdded);
		return this;
	}
	/**
	 * @param licenseXml the licenseXml to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setLicenseXml(@Nullable String licenseXml) throws InvalidSPDXAnalysisException {
		super.setLicenseXml(licenseXml);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
		/**
	 * @return the deprecatedVersion
	 */
	public Optional<String> getDeprecatedVersion() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_DEPRECATED_VERSION);
	}
	/**
	 * @param deprecatedVersion the deprecatedVersion to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public ListedLicense setDeprecatedVersion(@Nullable String deprecatedVersion) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_DEPRECATED_VERSION, deprecatedVersion);
		return this;
	}
	/**
	 * @param standardLicenseHeader the standardLicenseHeader to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public ListedLicense setStandardLicenseHeader(@Nullable String standardLicenseHeader) throws InvalidSPDXAnalysisException {
		super.setStandardLicenseHeader(standardLicenseHeader);
		return this;
	}	
	
	
	@Override
	public String toString() {
				return this.getObjectUri().substring(SpdxConstantsV3.SPDX_LISTED_LICENSE_NAMESPACE.length());
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			@SuppressWarnings("unused")
			Optional<String> listVersionAdded = getListVersionAdded();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting listVersionAdded for ListedLicense: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> deprecatedVersion = getDeprecatedVersion();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting deprecatedVersion for ListedLicense: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class ListedLicenseBuilder extends LicenseBuilder {
	
		/**
		 * Create an ListedLicenseBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public ListedLicenseBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an ListedLicenseBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public ListedLicenseBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a ListedLicenseBuilder
		 * @param modelStore model store for the built ListedLicense
		 * @param objectUri objectUri for the built ListedLicense
		 * @param copyManager optional copyManager for the built ListedLicense
		 */
		public ListedLicenseBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected String listVersionAdded = null;
		protected String deprecatedVersion = null;
		
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a seeAlso to the initial collection
		 * @parameter seeAlso seeAlso to add
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addSeeAlso(String seeAlso) {
			if (Objects.nonNull(seeAlso)) {
				super.seeAlsos.add(seeAlso);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial seeAlso collection
		 * @parameter seeAlsoCollection collection to initialize the seeAlso
		 * @return this for chaining
		**/
		public ListedLicenseBuilder addAllSeeAlso(Collection<String> seeAlsoCollection) {
			if (Objects.nonNull(seeAlsoCollection)) {
				super.seeAlsos.addAll(seeAlsoCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of isFsfLibre
		 * @parameter isFsfLibre value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setIsFsfLibre(Boolean isFsfLibre) {
			super.isFsfLibre = isFsfLibre;
			return this;
		}
		
		/**
		 * Sets the initial value of isDeprecatedLicenseId
		 * @parameter isDeprecatedLicenseId value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setIsDeprecatedLicenseId(Boolean isDeprecatedLicenseId) {
			super.isDeprecatedLicenseId = isDeprecatedLicenseId;
			return this;
		}
		
		/**
		 * Sets the initial value of isOsiApproved
		 * @parameter isOsiApproved value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setIsOsiApproved(Boolean isOsiApproved) {
			super.isOsiApproved = isOsiApproved;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseText
		 * @parameter licenseText value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setLicenseText(String licenseText) {
			super.licenseText = licenseText;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseTemplate
		 * @parameter standardLicenseTemplate value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setStandardLicenseTemplate(String standardLicenseTemplate) {
			super.standardLicenseTemplate = standardLicenseTemplate;
			return this;
		}
		
		/**
		 * Sets the initial value of obsoletedBy
		 * @parameter obsoletedBy value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setObsoletedBy(String obsoletedBy) {
			super.obsoletedBy = obsoletedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of listVersionAdded
		 * @parameter listVersionAdded value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setListVersionAdded(String listVersionAdded) {
			this.listVersionAdded = listVersionAdded;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseXml
		 * @parameter licenseXml value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setLicenseXml(String licenseXml) {
			super.licenseXml = licenseXml;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of deprecatedVersion
		 * @parameter deprecatedVersion value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setDeprecatedVersion(String deprecatedVersion) {
			this.deprecatedVersion = deprecatedVersion;
			return this;
		}
		
		/**
		 * Sets the initial value of standardLicenseHeader
		 * @parameter standardLicenseHeader value to set
		 * @return this for chaining
		**/
		public ListedLicenseBuilder setStandardLicenseHeader(String standardLicenseHeader) {
			super.standardLicenseHeader = standardLicenseHeader;
			return this;
		}
	
		/**
		 * @return the ListedLicense
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public ListedLicense build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new ListedLicense(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
