/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.extension;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A type of extension consisting of a list of name value pairs. 
 */
public  class CdxPropertiesExtension extends Extension  {

	Collection<CdxPropertyEntry> cdxPropertys = Collections.emptyList();
	
	/**
	 * Create the CdxPropertiesExtension with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertiesExtension
	 */
	public CdxPropertiesExtension() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the CdxPropertiesExtension
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertiesExtension
	 */
	public CdxPropertiesExtension(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the CdxPropertiesExtension is to be stored
	 * @param objectUri URI or anonymous ID for the CdxPropertiesExtension
	 * @param copyManager Copy manager for the CdxPropertiesExtension - can be null if copying is not required
	 * @param create true if CdxPropertiesExtension is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertiesExtension
	 */
	 @SuppressWarnings("unchecked")
	public CdxPropertiesExtension(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			cdxPropertys = (Collection<CdxPropertyEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CDX_PROPERTY, CdxPropertyEntry.class);
		}
	}

	/**
	 * Create the CdxPropertiesExtension from the builder - used in the builder class
	 * @param builder Builder to create the CdxPropertiesExtension from
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertiesExtension
	 */
	 @SuppressWarnings("unchecked")
	protected CdxPropertiesExtension(CdxPropertiesExtensionBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		cdxPropertys = (Collection<CdxPropertyEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CDX_PROPERTY, CdxPropertyEntry.class);
		getCdxPropertys().addAll(builder.cdxPropertys);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Extension.CdxPropertiesExtension";
	}
	
	// Getters and Setters
	public Collection<CdxPropertyEntry> getCdxPropertys() {
		return cdxPropertys;
	}
	
	
	
	@Override
	public String toString() {
		return "CdxPropertiesExtension: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		for (CdxPropertyEntry cdxProperty:cdxPropertys) {
			retval.addAll(cdxProperty.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class CdxPropertiesExtensionBuilder extends ExtensionBuilder {
	
		/**
		 * Create an CdxPropertiesExtensionBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public CdxPropertiesExtensionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an CdxPropertiesExtensionBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public CdxPropertiesExtensionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a CdxPropertiesExtensionBuilder
		 * @param modelStore model store for the built CdxPropertiesExtension
		 * @param objectUri objectUri for the built CdxPropertiesExtension
		 * @param copyManager optional copyManager for the built CdxPropertiesExtension
		 */
		public CdxPropertiesExtensionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<CdxPropertyEntry> cdxPropertys = new ArrayList<>();
		
		
		/**
		 * Adds a cdxProperty to the initial collection
		 * @parameter cdxProperty cdxProperty to add
		 * @return this for chaining
		**/
		public CdxPropertiesExtensionBuilder addCdxProperty(CdxPropertyEntry cdxProperty) {
			if (Objects.nonNull(cdxProperty)) {
				cdxPropertys.add(cdxProperty);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial cdxProperty collection
		 * @parameter cdxPropertyCollection collection to initialize the cdxProperty
		 * @return this for chaining
		**/
		public CdxPropertiesExtensionBuilder addAllCdxProperty(Collection<CdxPropertyEntry> cdxPropertyCollection) {
			if (Objects.nonNull(cdxPropertyCollection)) {
				cdxPropertys.addAll(cdxPropertyCollection);
			}
			return this;
		}
	
		/**
		 * @return the CdxPropertiesExtension
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public CdxPropertiesExtension build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new CdxPropertiesExtension(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
