/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.extension;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * A property name with an associated value. 
 */
public  class CdxPropertyEntry extends ModelObjectV3  {

	
	/**
	 * Create the CdxPropertyEntry with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertyEntry
	 */
	public CdxPropertyEntry() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the CdxPropertyEntry
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertyEntry
	 */
	public CdxPropertyEntry(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the CdxPropertyEntry is to be stored
	 * @param objectUri URI or anonymous ID for the CdxPropertyEntry
	 * @param copyManager Copy manager for the CdxPropertyEntry - can be null if copying is not required
	 * @param create true if CdxPropertyEntry is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertyEntry
	 */
	public CdxPropertyEntry(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the CdxPropertyEntry from the builder - used in the builder class
	 * @param builder Builder to create the CdxPropertyEntry from
	 * @throws InvalidSPDXAnalysisException when unable to create the CdxPropertyEntry
	 */
	protected CdxPropertyEntry(CdxPropertyEntryBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		if (Objects.nonNull(builder.cdxPropName)) {
			setCdxPropName(builder.cdxPropName);
		}
		setCdxPropValue(builder.cdxPropValue);
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Extension.CdxPropertyEntry";
	}
	
	// Getters and Setters
	
	/**
	 * @return the cdxPropName
	 */
	public @Nullable String getCdxPropName() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_NAME);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param cdxPropName the cdxPropName to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public CdxPropertyEntry setCdxPropName(@Nullable String cdxPropName) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(cdxPropName)) {
			throw new InvalidSPDXAnalysisException("cdxPropName is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_NAME, cdxPropName);
		return this;
	}
		/**
	 * @return the cdxPropValue
	 */
	public Optional<String> getCdxPropValue() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_VALUE);
	}
	/**
	 * @param cdxPropValue the cdxPropValue to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public CdxPropertyEntry setCdxPropValue(@Nullable String cdxPropValue) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_CDX_PROP_VALUE, cdxPropValue);
		return this;
	}
	
	
	@Override
	public String toString() {
		return "CdxPropertyEntry: "+getObjectUri();
		
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		try {
			String cdxPropName = getCdxPropName();
			if (Objects.isNull(cdxPropName) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.EXTENSION }))) {
				retval.add("Missing cdxPropName in CdxPropertyEntry");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting cdxPropName for CdxPropertyEntry: "+e.getMessage());
		}
		try {
			@SuppressWarnings("unused")
			Optional<String> cdxPropValue = getCdxPropValue();
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting cdxPropValue for CdxPropertyEntry: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class CdxPropertyEntryBuilder extends ModelObjectV3Builder {
	
		/**
		 * Create an CdxPropertyEntryBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public CdxPropertyEntryBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an CdxPropertyEntryBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public CdxPropertyEntryBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
		}
		
		/**
		 * Creates a CdxPropertyEntryBuilder
		 * @param modelStore model store for the built CdxPropertyEntry
		 * @param objectUri objectUri for the built CdxPropertyEntry
		 * @param copyManager optional copyManager for the built CdxPropertyEntry
		 */
		public CdxPropertyEntryBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected String cdxPropName = null;
		protected String cdxPropValue = null;
		
		
		/**
		 * Sets the initial value of cdxPropName
		 * @parameter cdxPropName value to set
		 * @return this for chaining
		**/
		public CdxPropertyEntryBuilder setCdxPropName(String cdxPropName) {
			this.cdxPropName = cdxPropName;
			return this;
		}
		
		/**
		 * Sets the initial value of cdxPropValue
		 * @parameter cdxPropValue value to set
		 * @return this for chaining
		**/
		public CdxPropertyEntryBuilder setCdxPropValue(String cdxPropValue) {
			this.cdxPropValue = cdxPropValue;
			return this;
		}
	
		/**
		 * @return the CdxPropertyEntry
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public CdxPropertyEntry build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new CdxPropertyEntry(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
