/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.simplelicensing;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * An SPDX Element containing an SPDX license expression string. 
 */
public  class LicenseExpression extends AnyLicenseInfo  {

	Collection<DictionaryEntry> customIdToUris = Collections.emptyList();
	
	/**
	 * Create the LicenseExpression with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the LicenseExpression
	 */
	public LicenseExpression() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the LicenseExpression
	 * @throws InvalidSPDXAnalysisException when unable to create the LicenseExpression
	 */
	public LicenseExpression(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the LicenseExpression is to be stored
	 * @param objectUri URI or anonymous ID for the LicenseExpression
	 * @param copyManager Copy manager for the LicenseExpression - can be null if copying is not required
	 * @param create true if LicenseExpression is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the LicenseExpression
	 */
	 @SuppressWarnings("unchecked")
	public LicenseExpression(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
		if (!isExternal()) {
			customIdToUris = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CUSTOM_ID_TO_URI, DictionaryEntry.class);
		}
	}

	/**
	 * Create the LicenseExpression from the builder - used in the builder class
	 * @param builder Builder to create the LicenseExpression from
	 * @throws InvalidSPDXAnalysisException when unable to create the LicenseExpression
	 */
	 @SuppressWarnings("unchecked")
	protected LicenseExpression(LicenseExpressionBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		customIdToUris = (Collection<DictionaryEntry>)(Collection<?>)this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CUSTOM_ID_TO_URI, DictionaryEntry.class);
		getCustomIdToUris().addAll(builder.customIdToUris);
		setLicenseListVersion(builder.licenseListVersion);
		if (Objects.nonNull(builder.licenseExpression)) {
			setLicenseExpression(builder.licenseExpression);
		}
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "SimpleLicensing.LicenseExpression";
	}
	
	// Getters and Setters
	public Collection<DictionaryEntry> getCustomIdToUris() {
		return customIdToUris;
	}
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public LicenseExpression setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
		/**
	 * @return the licenseListVersion
	 */
	public Optional<String> getLicenseListVersion() throws InvalidSPDXAnalysisException {
		return getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_LIST_VERSION);
	}
	/**
	 * @param licenseListVersion the licenseListVersion to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public LicenseExpression setLicenseListVersion(@Nullable String licenseListVersion) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.nonNull(licenseListVersion) && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", licenseListVersion)) {
			throw new InvalidSPDXAnalysisException("licenseListVersion value '" + licenseListVersion + 
				"' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
		}
		setPropertyValue(SpdxConstantsV3.PROP_LICENSE_LIST_VERSION, licenseListVersion);
		return this;
	}
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public LicenseExpression setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public LicenseExpression setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public LicenseExpression setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public LicenseExpression setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	/**
	 * @return the licenseExpression
	 */
	public @Nullable String getLicenseExpression() throws InvalidSPDXAnalysisException {
		Optional<String> retval = getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_EXPRESSION);
		return retval.isPresent() ? retval.get() : null;
	}
		/**
	 * @param licenseExpression the licenseExpression to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public LicenseExpression setLicenseExpression(@Nullable String licenseExpression) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(licenseExpression)) {
			throw new InvalidSPDXAnalysisException("licenseExpression is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_LICENSE_EXPRESSION, licenseExpression);
		return this;
	}
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		try {
			Optional<String> licenseListVersion = getLicenseListVersion();
			if (licenseListVersion.isPresent() && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", licenseListVersion.get())) {
				retval.add("licenseListVersion value '" + licenseListVersion.get() + 
					"' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting licenseListVersion for LicenseExpression: "+e.getMessage());
		}
		try {
			String licenseExpression = getLicenseExpression();
			if (Objects.isNull(licenseExpression) &&
					Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.SIMPLE_LICENSING }))) {
				retval.add("Missing licenseExpression in LicenseExpression");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting licenseExpression for LicenseExpression: "+e.getMessage());
		}
		for (DictionaryEntry customIdToUri:customIdToUris) {
			retval.addAll(customIdToUri.verify(verifiedIds, specVersionForVerify, profiles));
		}
		return retval;
	}
	
	
	
	public static class LicenseExpressionBuilder extends AnyLicenseInfoBuilder {
	
		/**
		 * Create an LicenseExpressionBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public LicenseExpressionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an LicenseExpressionBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public LicenseExpressionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a LicenseExpressionBuilder
		 * @param modelStore model store for the built LicenseExpression
		 * @param objectUri objectUri for the built LicenseExpression
		 * @param copyManager optional copyManager for the built LicenseExpression
		 */
		public LicenseExpressionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected Collection<DictionaryEntry> customIdToUris = new ArrayList<>();
		protected String licenseListVersion = null;
		protected String licenseExpression = null;
		
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a customIdToUri to the initial collection
		 * @parameter customIdToUri customIdToUri to add
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addCustomIdToUri(DictionaryEntry customIdToUri) {
			if (Objects.nonNull(customIdToUri)) {
				customIdToUris.add(customIdToUri);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial customIdToUri collection
		 * @parameter customIdToUriCollection collection to initialize the customIdToUri
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addAllCustomIdToUri(Collection<DictionaryEntry> customIdToUriCollection) {
			if (Objects.nonNull(customIdToUriCollection)) {
				customIdToUris.addAll(customIdToUriCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseListVersion
		 * @parameter licenseListVersion value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setLicenseListVersion(String licenseListVersion) {
			this.licenseListVersion = licenseListVersion;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setName(String name) {
			super.name = name;
			return this;
		}
		
		/**
		 * Sets the initial value of licenseExpression
		 * @parameter licenseExpression value to set
		 * @return this for chaining
		**/
		public LicenseExpressionBuilder setLicenseExpression(String licenseExpression) {
			this.licenseExpression = licenseExpression;
			return this;
		}
	
		/**
		 * @return the LicenseExpression
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public LicenseExpression build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new LicenseExpression(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
