/**
 * Copyright (c) 2024 Source Auditor Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
 
package org.spdx.library.model.v3_0_1.software;

import javax.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.storage.IModelStore;
import org.spdx.storage.IModelStore.IdType;
import org.spdx.storage.IModelStore.IModelStoreLock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.PositiveIntegerRange;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;

/**
 * DO NOT EDIT - this file is generated by the Owl to Java Utility 
 * See: https://github.com/spdx/tools-java 
 * 
 * Describes a certain part of a file. 
 */
public  class Snippet extends SoftwareArtifact  {

	
	/**
	 * Create the Snippet with default model store and generated anonymous ID
	 * @throws InvalidSPDXAnalysisException when unable to create the Snippet
	 */
	public Snippet() throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore().getNextId(IdType.Anonymous));
	}

	/**
	 * @param objectUri URI or anonymous ID for the Snippet
	 * @throws InvalidSPDXAnalysisException when unable to create the Snippet
	 */
	public Snippet(String objectUri) throws InvalidSPDXAnalysisException {
		this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), 
				true, DefaultModelStore.getDefaultDocumentUri() + "#");
	}

	/**
	 * @param modelStore Model store where the Snippet is to be stored
	 * @param objectUri URI or anonymous ID for the Snippet
	 * @param copyManager Copy manager for the Snippet - can be null if copying is not required
	 * @param create true if Snippet is to be created
	 * @param idPrefix - prefix to be used when generating new SPDX IDs
	 * @throws InvalidSPDXAnalysisException when unable to create the Snippet
	 */
	 @SuppressWarnings("unchecked")
	public Snippet(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager,
			boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
		super(modelStore, objectUri, copyManager, create, idPrefix);
	}

	/**
	 * Create the Snippet from the builder - used in the builder class
	 * @param builder Builder to create the Snippet from
	 * @throws InvalidSPDXAnalysisException when unable to create the Snippet
	 */
	 @SuppressWarnings("unchecked")
	protected Snippet(SnippetBuilder builder) throws InvalidSPDXAnalysisException {
		super(builder);
		setLineRange(builder.lineRange);
		setByteRange(builder.byteRange);
		if (Objects.nonNull(builder.snippetFromFile)) {
			setSnippetFromFile(builder.snippetFromFile);
		}
	}

	/* (non-Javadoc)
	 * @see org.spdx.library.core.CoreModelObject#getType()
	 */
	@Override
	public String getType() {
		return "Software.Snippet";
	}
	
	// Getters and Setters
	
	/**
	 * @param creationInfo the creationInfo to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
		super.setCreationInfo(creationInfo);
		return this;
	}	
	/**
	 * @param suppliedBy the suppliedBy to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
		super.setSuppliedBy(suppliedBy);
		return this;
	}	
		/**
	 * @return the lineRange
	 */
	 @SuppressWarnings("unchecked")
	public Optional<PositiveIntegerRange> getLineRange() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_LINE_RANGE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof PositiveIntegerRange)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for lineRange");
			}
			return (Optional<PositiveIntegerRange>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	
	/**
	 * @param lineRange the lineRange to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Snippet setLineRange(@Nullable PositiveIntegerRange lineRange) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_LINE_RANGE, lineRange);
		return this;
	}
		/**
	 * @return the byteRange
	 */
	 @SuppressWarnings("unchecked")
	public Optional<PositiveIntegerRange> getByteRange() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_BYTE_RANGE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof PositiveIntegerRange)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for byteRange");
			}
			return (Optional<PositiveIntegerRange>)(Optional<?>)(retval);
		} else {
			return Optional.empty();
		}
	}
	
	/**
	 * @param byteRange the byteRange to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Snippet setByteRange(@Nullable PositiveIntegerRange byteRange) throws InvalidSPDXAnalysisException {
		setPropertyValue(SpdxConstantsV3.PROP_BYTE_RANGE, byteRange);
		return this;
	}
	/**
	 * @return the snippetFromFile
	 */
	 @SuppressWarnings("unchecked")
	public @Nullable SpdxFile getSnippetFromFile() throws InvalidSPDXAnalysisException {
		Optional<Object> retval = getObjectPropertyValue(SpdxConstantsV3.PROP_SNIPPET_FROM_FILE);
		if (retval.isPresent()) {
			if (!(retval.get() instanceof SpdxFile)) {
				throw new InvalidSPDXAnalysisException("Incorrect type stored for snippetFromFile");
			}
			return (SpdxFile)(retval.get());
		} else {
			return null;
		}
	}
		
	/**
	 * @param snippetFromFile the snippetFromFile to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	public Snippet setSnippetFromFile(@Nullable SpdxFile snippetFromFile) throws InvalidSPDXAnalysisException {
		if (isStrict() && Objects.isNull(snippetFromFile)) {
			throw new InvalidSPDXAnalysisException("snippetFromFile is a required property");
		}
		setPropertyValue(SpdxConstantsV3.PROP_SNIPPET_FROM_FILE, snippetFromFile);
		return this;
	}
	/**
	 * @param primaryPurpose the primaryPurpose to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
		super.setPrimaryPurpose(primaryPurpose);
		return this;
	}	
	/**
	 * @param validUntilTime the validUntilTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
		super.setValidUntilTime(validUntilTime);
		return this;
	}	
	/**
	 * @param builtTime the builtTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
		super.setBuiltTime(builtTime);
		return this;
	}	
	/**
	 * @param summary the summary to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
		super.setSummary(summary);
		return this;
	}	
	/**
	 * @param description the description to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
		super.setDescription(description);
		return this;
	}	
	/**
	 * @param releaseTime the releaseTime to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
		super.setReleaseTime(releaseTime);
		return this;
	}	
	/**
	 * @param copyrightText the copyrightText to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
		super.setCopyrightText(copyrightText);
		return this;
	}	
	/**
	 * @param comment the comment to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
		super.setComment(comment);
		return this;
	}	
	/**
	 * @param name the name to set
	 * @return this to chain setters
	 * @throws InvalidSPDXAnalysisException 
	 */
	 @Override
	public Snippet setName(@Nullable String name) throws InvalidSPDXAnalysisException {
		super.setName(name);
		return this;
	}	
	
	
	@Override
	public String toString() {
				return super.toString();
	}
	
	/* (non-Javadoc)
	 * @see org.spdx.library.model.v3.ModelObjectV3#_verify(java.util.List)
	 */
	@Override
	public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
		List<String> retval = new ArrayList<>();
		retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
		Optional<PositiveIntegerRange> lineRange;
		try {
			lineRange = getLineRange();
			if (lineRange.isPresent()) {
				retval.addAll(lineRange.get().verify(verifiedIds, specVersionForVerify, profiles));
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting lineRange for Snippet: "+e.getMessage());
		}
		Optional<PositiveIntegerRange> byteRange;
		try {
			byteRange = getByteRange();
			if (byteRange.isPresent()) {
				retval.addAll(byteRange.get().verify(verifiedIds, specVersionForVerify, profiles));
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting byteRange for Snippet: "+e.getMessage());
		}
		SpdxFile snippetFromFile;
		try {
			snippetFromFile = getSnippetFromFile();
			if (Objects.nonNull(snippetFromFile)) {
				retval.addAll(snippetFromFile.verify(verifiedIds, specVersionForVerify, profiles));
			} else if (!Collections.disjoint(profiles, Arrays.asList(new ProfileIdentifierType[] { ProfileIdentifierType.SOFTWARE }))) {
					retval.add("Missing snippetFromFile in Snippet");
			}
		} catch (InvalidSPDXAnalysisException e) {
			retval.add("Error getting snippetFromFile for Snippet: "+e.getMessage());
		}
		return retval;
	}
	
	
	
	public static class SnippetBuilder extends SoftwareArtifactBuilder {
	
		/**
		 * Create an SnippetBuilder from another model object copying the modelStore and copyManager and using an anonymous ID
		 * @param from model object to copy the model store and copyManager from
		 * @throws InvalidSPDXAnalysisException
		 */
		public SnippetBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
			this(from, from.getModelStore().getNextId(IdType.Anonymous));
		}
	
		/**
		 * Create an SnippetBuilder from another model object copying the modelStore and copyManager
		 * @param from model object to copy the model store and copyManager from
		 * @param objectUri URI for the object
		 * @throws InvalidSPDXAnalysisException if creationInfo can not be fetched from the from
		 */
		public SnippetBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
			this(from.getModelStore(), objectUri, from.getCopyManager());
			setStrict(from.isStrict());
			setIdPrefix(from.getIdPrefix());
			if (from instanceof Element) {
				setCreationInfo(((Element)from).getCreationInfo());
			} else if (from instanceof CreationInfo) {
				setCreationInfo((CreationInfo)from);
			}
		}
		
		/**
		 * Creates a SnippetBuilder
		 * @param modelStore model store for the built Snippet
		 * @param objectUri objectUri for the built Snippet
		 * @param copyManager optional copyManager for the built Snippet
		 */
		public SnippetBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
			super(modelStore, objectUri, copyManager);
		}
		
		protected PositiveIntegerRange lineRange = null;
		protected PositiveIntegerRange byteRange = null;
		protected SpdxFile snippetFromFile = null;
		
		
		/**
		 * Adds a contentIdentifier to the initial collection
		 * @parameter contentIdentifier contentIdentifier to add
		 * @return this for chaining
		**/
		public SnippetBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
			if (Objects.nonNull(contentIdentifier)) {
				super.contentIdentifiers.add(contentIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial contentIdentifier collection
		 * @parameter contentIdentifierCollection collection to initialize the contentIdentifier
		 * @return this for chaining
		**/
		public SnippetBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
			if (Objects.nonNull(contentIdentifierCollection)) {
				super.contentIdentifiers.addAll(contentIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a extension to the initial collection
		 * @parameter extension extension to add
		 * @return this for chaining
		**/
		public SnippetBuilder addExtension(Extension extension) {
			if (Objects.nonNull(extension)) {
				super.extensions.add(extension);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial extension collection
		 * @parameter extensionCollection collection to initialize the extension
		 * @return this for chaining
		**/
		public SnippetBuilder addAllExtension(Collection<Extension> extensionCollection) {
			if (Objects.nonNull(extensionCollection)) {
				super.extensions.addAll(extensionCollection);
			}
			return this;
		}
		
		/**
		 * Adds a verifiedUsing to the initial collection
		 * @parameter verifiedUsing verifiedUsing to add
		 * @return this for chaining
		**/
		public SnippetBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
			if (Objects.nonNull(verifiedUsing)) {
				super.verifiedUsings.add(verifiedUsing);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial verifiedUsing collection
		 * @parameter verifiedUsingCollection collection to initialize the verifiedUsing
		 * @return this for chaining
		**/
		public SnippetBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
			if (Objects.nonNull(verifiedUsingCollection)) {
				super.verifiedUsings.addAll(verifiedUsingCollection);
			}
			return this;
		}
		
		/**
		 * Adds a originatedBy to the initial collection
		 * @parameter originatedBy originatedBy to add
		 * @return this for chaining
		**/
		public SnippetBuilder addOriginatedBy(Agent originatedBy) {
			if (Objects.nonNull(originatedBy)) {
				super.originatedBys.add(originatedBy);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial originatedBy collection
		 * @parameter originatedByCollection collection to initialize the originatedBy
		 * @return this for chaining
		**/
		public SnippetBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
			if (Objects.nonNull(originatedByCollection)) {
				super.originatedBys.addAll(originatedByCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalRef to the initial collection
		 * @parameter externalRef externalRef to add
		 * @return this for chaining
		**/
		public SnippetBuilder addExternalRef(ExternalRef externalRef) {
			if (Objects.nonNull(externalRef)) {
				super.externalRefs.add(externalRef);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalRef collection
		 * @parameter externalRefCollection collection to initialize the externalRef
		 * @return this for chaining
		**/
		public SnippetBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
			if (Objects.nonNull(externalRefCollection)) {
				super.externalRefs.addAll(externalRefCollection);
			}
			return this;
		}
		
		/**
		 * Adds a externalIdentifier to the initial collection
		 * @parameter externalIdentifier externalIdentifier to add
		 * @return this for chaining
		**/
		public SnippetBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
			if (Objects.nonNull(externalIdentifier)) {
				super.externalIdentifiers.add(externalIdentifier);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial externalIdentifier collection
		 * @parameter externalIdentifierCollection collection to initialize the externalIdentifier
		 * @return this for chaining
		**/
		public SnippetBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
			if (Objects.nonNull(externalIdentifierCollection)) {
				super.externalIdentifiers.addAll(externalIdentifierCollection);
			}
			return this;
		}
		
		/**
		 * Adds a supportLevel to the initial collection
		 * @parameter supportLevel supportLevel to add
		 * @return this for chaining
		**/
		public SnippetBuilder addSupportLevel(SupportType supportLevel) {
			if (Objects.nonNull(supportLevel)) {
				super.supportLevels.add(supportLevel);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial supportLevel collection
		 * @parameter supportLevelCollection collection to initialize the supportLevel
		 * @return this for chaining
		**/
		public SnippetBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
			if (Objects.nonNull(supportLevelCollection)) {
				super.supportLevels.addAll(supportLevelCollection);
			}
			return this;
		}
		
		/**
		 * Adds a additionalPurpose to the initial collection
		 * @parameter additionalPurpose additionalPurpose to add
		 * @return this for chaining
		**/
		public SnippetBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
			if (Objects.nonNull(additionalPurpose)) {
				super.additionalPurposes.add(additionalPurpose);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial additionalPurpose collection
		 * @parameter additionalPurposeCollection collection to initialize the additionalPurpose
		 * @return this for chaining
		**/
		public SnippetBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
			if (Objects.nonNull(additionalPurposeCollection)) {
				super.additionalPurposes.addAll(additionalPurposeCollection);
			}
			return this;
		}
		
		/**
		 * Adds a attributionText to the initial collection
		 * @parameter attributionText attributionText to add
		 * @return this for chaining
		**/
		public SnippetBuilder addAttributionText(String attributionText) {
			if (Objects.nonNull(attributionText)) {
				super.attributionTexts.add(attributionText);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial attributionText collection
		 * @parameter attributionTextCollection collection to initialize the attributionText
		 * @return this for chaining
		**/
		public SnippetBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
			if (Objects.nonNull(attributionTextCollection)) {
				super.attributionTexts.addAll(attributionTextCollection);
			}
			return this;
		}
		
		/**
		 * Adds a standardName to the initial collection
		 * @parameter standardName standardName to add
		 * @return this for chaining
		**/
		public SnippetBuilder addStandardName(String standardName) {
			if (Objects.nonNull(standardName)) {
				super.standardNames.add(standardName);
			}
			return this;
		}
		
		/**
		 * Adds all elements from a collection to the initial standardName collection
		 * @parameter standardNameCollection collection to initialize the standardName
		 * @return this for chaining
		**/
		public SnippetBuilder addAllStandardName(Collection<String> standardNameCollection) {
			if (Objects.nonNull(standardNameCollection)) {
				super.standardNames.addAll(standardNameCollection);
			}
			return this;
		}
		
		/**
		 * Sets the initial value of creationInfo
		 * @parameter creationInfo value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setCreationInfo(CreationInfo creationInfo) {
			super.creationInfo = creationInfo;
			return this;
		}
		
		/**
		 * Sets the initial value of suppliedBy
		 * @parameter suppliedBy value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setSuppliedBy(Agent suppliedBy) {
			super.suppliedBy = suppliedBy;
			return this;
		}
		
		/**
		 * Sets the initial value of lineRange
		 * @parameter lineRange value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setLineRange(PositiveIntegerRange lineRange) {
			this.lineRange = lineRange;
			return this;
		}
		
		/**
		 * Sets the initial value of byteRange
		 * @parameter byteRange value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setByteRange(PositiveIntegerRange byteRange) {
			this.byteRange = byteRange;
			return this;
		}
		
		/**
		 * Sets the initial value of snippetFromFile
		 * @parameter snippetFromFile value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setSnippetFromFile(SpdxFile snippetFromFile) {
			this.snippetFromFile = snippetFromFile;
			return this;
		}
		
		/**
		 * Sets the initial value of primaryPurpose
		 * @parameter primaryPurpose value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
			super.primaryPurpose = primaryPurpose;
			return this;
		}
		
		/**
		 * Sets the initial value of validUntilTime
		 * @parameter validUntilTime value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setValidUntilTime(String validUntilTime) {
			super.validUntilTime = validUntilTime;
			return this;
		}
		
		/**
		 * Sets the initial value of builtTime
		 * @parameter builtTime value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setBuiltTime(String builtTime) {
			super.builtTime = builtTime;
			return this;
		}
		
		/**
		 * Sets the initial value of summary
		 * @parameter summary value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setSummary(String summary) {
			super.summary = summary;
			return this;
		}
		
		/**
		 * Sets the initial value of description
		 * @parameter description value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setDescription(String description) {
			super.description = description;
			return this;
		}
		
		/**
		 * Sets the initial value of releaseTime
		 * @parameter releaseTime value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setReleaseTime(String releaseTime) {
			super.releaseTime = releaseTime;
			return this;
		}
		
		/**
		 * Sets the initial value of copyrightText
		 * @parameter copyrightText value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setCopyrightText(String copyrightText) {
			super.copyrightText = copyrightText;
			return this;
		}
		
		/**
		 * Sets the initial value of comment
		 * @parameter comment value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setComment(String comment) {
			super.comment = comment;
			return this;
		}
		
		/**
		 * Sets the initial value of name
		 * @parameter name value to set
		 * @return this for chaining
		**/
		public SnippetBuilder setName(String name) {
			super.name = name;
			return this;
		}
	
		/**
		 * @return the Snippet
		 * @throws InvalidSPDXAnalysisException on any errors during build
		 */
		public Snippet build() throws InvalidSPDXAnalysisException {
			IModelStoreLock lock = getModelStore().enterCriticalSection(false);
			try {
				return new Snippet(this);
			} finally {
				getModelStore().leaveCriticalSection(lock);
			}
		}
	}
}
