/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.ai.EnergyUnitType;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class EnergyConsumptionDescription
extends ModelObjectV3 {
    public EnergyConsumptionDescription() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public EnergyConsumptionDescription(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public EnergyConsumptionDescription(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected EnergyConsumptionDescription(EnergyConsumptionDescriptionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.energyUnit)) {
            this.setEnergyUnit(builder.energyUnit);
        }
        if (Objects.nonNull(builder.energyQuantity)) {
            this.setEnergyQuantity(builder.energyQuantity);
        }
    }

    public String getType() {
        return "AI.EnergyConsumptionDescription";
    }

    @Nullable
    public EnergyUnitType getEnergyUnit() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_ENERGY_UNIT);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof EnergyUnitType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for energyUnit");
            }
            return (EnergyUnitType)((Object)retval.get());
        }
        return null;
    }

    public EnergyConsumptionDescription setEnergyUnit(@Nullable EnergyUnitType energyUnit) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)energyUnit)) {
            throw new InvalidSPDXAnalysisException("energyUnit is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ENERGY_UNIT, (Object)energyUnit);
        return this;
    }

    @Nullable
    public Double getEnergyQuantity() throws InvalidSPDXAnalysisException {
        Optional retval = this.getDoublePropertyValue(SpdxConstantsV3.PROP_ENERGY_QUANTITY);
        return retval.isPresent() ? (Double)retval.get() : null;
    }

    public EnergyConsumptionDescription setEnergyQuantity(@Nullable Double energyQuantity) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(energyQuantity)) {
            throw new InvalidSPDXAnalysisException("energyQuantity is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ENERGY_QUANTITY, energyQuantity);
        return this;
    }

    public String toString() {
        return "EnergyConsumptionDescription: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            EnergyUnitType energyUnit = this.getEnergyUnit();
            if (Objects.isNull((Object)energyUnit) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.AI))) {
                retval.add("Missing energyUnit in EnergyConsumptionDescription");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting energyUnit for EnergyConsumptionDescription: " + e.getMessage());
        }
        try {
            Double energyQuantity = this.getEnergyQuantity();
            if (Objects.isNull(energyQuantity) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.AI))) {
                retval.add("Missing energyQuantity in EnergyConsumptionDescription");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting energyQuantity for EnergyConsumptionDescription: " + e.getMessage());
        }
        return retval;
    }

    public static class EnergyConsumptionDescriptionBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected EnergyUnitType energyUnit = null;
        protected Double energyQuantity = null;

        public EnergyConsumptionDescriptionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public EnergyConsumptionDescriptionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public EnergyConsumptionDescriptionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public EnergyConsumptionDescriptionBuilder setEnergyUnit(EnergyUnitType energyUnit) {
            this.energyUnit = energyUnit;
            return this;
        }

        public EnergyConsumptionDescriptionBuilder setEnergyQuantity(Double energyQuantity) {
            this.energyQuantity = energyQuantity;
            return this;
        }

        public EnergyConsumptionDescription build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                EnergyConsumptionDescription energyConsumptionDescription = new EnergyConsumptionDescription(this);
                return energyConsumptionDescription;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

