/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.AnnotationType;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class Annotation
extends Element {
    public Annotation() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Annotation(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Annotation(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected Annotation(AnnotationBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.subject)) {
            this.setSubject(builder.subject);
        }
        if (Objects.nonNull((Object)builder.annotationType)) {
            this.setAnnotationType(builder.annotationType);
        }
        this.setStatement(builder.statement);
        this.setContentType(builder.contentType);
    }

    @Override
    public String getType() {
        return "Core.Annotation";
    }

    @Nullable
    public Element getSubject() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_SUBJECT);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof Element)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for subject");
            }
            return (Element)((Object)retval.get());
        }
        return null;
    }

    public Annotation setSubject(@Nullable Element subject) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)subject)) {
            throw new InvalidSPDXAnalysisException("subject is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SUBJECT, (Object)subject);
        return this;
    }

    @Override
    public Annotation setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Nullable
    public AnnotationType getAnnotationType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_ANNOTATION_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof AnnotationType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for annotationType");
            }
            return (AnnotationType)((Object)retval.get());
        }
        return null;
    }

    public Annotation setAnnotationType(@Nullable AnnotationType annotationType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)annotationType)) {
            throw new InvalidSPDXAnalysisException("annotationType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_ANNOTATION_TYPE, (Object)annotationType);
        return this;
    }

    @Override
    public Annotation setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Annotation setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getStatement() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_STATEMENT);
    }

    public Annotation setStatement(@Nullable String statement) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_STATEMENT, statement);
        return this;
    }

    public Optional<String> getContentType() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE);
    }

    public Annotation setContentType(@Nullable String contentType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(contentType) && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType)) {
            throw new InvalidSPDXAnalysisException("contentType value '" + contentType + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE, contentType);
        return this;
    }

    @Override
    public Annotation setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Annotation setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Element subject = this.getSubject();
            if (Objects.nonNull((Object)subject)) {
                retval.addAll(subject.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing subject in Annotation");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting subject for Annotation: " + e.getMessage());
        }
        try {
            AnnotationType annotationType = this.getAnnotationType();
            if (Objects.isNull((Object)annotationType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing annotationType in Annotation");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting annotationType for Annotation: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getStatement();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting statement for Annotation: " + e.getMessage());
        }
        try {
            Optional<String> contentType = this.getContentType();
            if (contentType.isPresent() && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType.get())) {
                retval.add("contentType value '" + contentType.get() + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting contentType for Annotation: " + e.getMessage());
        }
        return retval;
    }

    public static class AnnotationBuilder
    extends Element.ElementBuilder {
        protected Element subject = null;
        protected AnnotationType annotationType = null;
        protected String statement = null;
        protected String contentType = null;

        public AnnotationBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public AnnotationBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public AnnotationBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public AnnotationBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public AnnotationBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public AnnotationBuilder setSubject(Element subject) {
            this.subject = subject;
            return this;
        }

        @Override
        public AnnotationBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public AnnotationBuilder setAnnotationType(AnnotationType annotationType) {
            this.annotationType = annotationType;
            return this;
        }

        @Override
        public AnnotationBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public AnnotationBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public AnnotationBuilder setStatement(String statement) {
            this.statement = statement;
            return this;
        }

        public AnnotationBuilder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public AnnotationBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public AnnotationBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Annotation build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Annotation annotation = new Annotation(this);
                return annotation;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

