/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public abstract class Artifact
extends Element {
    Collection<Agent> originatedBys = Collections.emptyList();
    Collection<String> standardNames = Collections.emptyList();
    Collection<SupportType> supportLevels = Collections.emptyList();

    public Artifact() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Artifact(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Artifact(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.originatedBys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ORIGINATED_BY, Agent.class);
        }
        if (!this.isExternal()) {
            this.supportLevels = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SUPPORT_LEVEL, SupportType.class);
        }
        if (!this.isExternal()) {
            this.standardNames = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_NAME, String.class);
        }
    }

    protected Artifact(ArtifactBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.originatedBys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ORIGINATED_BY, Agent.class);
        this.supportLevels = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_SUPPORT_LEVEL, SupportType.class);
        this.standardNames = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_STANDARD_NAME, String.class);
        this.getOriginatedBys().addAll(builder.originatedBys);
        this.getSupportLevels().addAll(builder.supportLevels);
        this.getStandardNames().addAll(builder.standardNames);
        this.setSuppliedBy(builder.suppliedBy);
        this.setValidUntilTime(builder.validUntilTime);
        this.setBuiltTime(builder.builtTime);
        this.setReleaseTime(builder.releaseTime);
    }

    @Override
    public String getType() {
        return "Core.Artifact";
    }

    public Collection<Agent> getOriginatedBys() {
        return this.originatedBys;
    }

    public Collection<SupportType> getSupportLevels() {
        return this.supportLevels;
    }

    public Collection<String> getStandardNames() {
        return this.standardNames;
    }

    @Override
    public Artifact setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<Agent> getSuppliedBy() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_SUPPLIED_BY);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof Agent)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for suppliedBy");
            }
            return retval;
        }
        return Optional.empty();
    }

    public Artifact setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_SUPPLIED_BY, (Object)suppliedBy);
        return this;
    }

    public Optional<String> getValidUntilTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_VALID_UNTIL_TIME);
    }

    public Artifact setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(validUntilTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", validUntilTime)) {
            throw new InvalidSPDXAnalysisException("validUntilTime value '" + validUntilTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_VALID_UNTIL_TIME, validUntilTime);
        return this;
    }

    public Optional<String> getBuiltTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_BUILT_TIME);
    }

    public Artifact setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(builtTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", builtTime)) {
            throw new InvalidSPDXAnalysisException("builtTime value '" + builtTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_BUILT_TIME, builtTime);
        return this;
    }

    @Override
    public Artifact setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Artifact setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getReleaseTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_RELEASE_TIME);
    }

    public Artifact setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(releaseTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", releaseTime)) {
            throw new InvalidSPDXAnalysisException("releaseTime value '" + releaseTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_RELEASE_TIME, releaseTime);
        return this;
    }

    @Override
    public Artifact setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Artifact setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<Agent> suppliedBy = this.getSuppliedBy();
            if (suppliedBy.isPresent()) {
                retval.addAll(suppliedBy.get().verify(verifiedIds, specVersionForVerify, profiles));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting suppliedBy for Artifact: " + e.getMessage());
        }
        try {
            Optional<String> validUntilTime = this.getValidUntilTime();
            if (validUntilTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", validUntilTime.get())) {
                retval.add("validUntilTime value '" + validUntilTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting validUntilTime for Artifact: " + e.getMessage());
        }
        try {
            Optional<String> builtTime = this.getBuiltTime();
            if (builtTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", builtTime.get())) {
                retval.add("builtTime value '" + builtTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting builtTime for Artifact: " + e.getMessage());
        }
        try {
            Optional<String> releaseTime = this.getReleaseTime();
            if (releaseTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", releaseTime.get())) {
                retval.add("releaseTime value '" + releaseTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting releaseTime for Artifact: " + e.getMessage());
        }
        for (Agent originatedBy : this.originatedBys) {
            retval.addAll(originatedBy.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static abstract class ArtifactBuilder
    extends Element.ElementBuilder {
        protected Collection<Agent> originatedBys = new ArrayList<Agent>();
        protected Collection<SupportType> supportLevels = new ArrayList<SupportType>();
        protected Collection<String> standardNames = new ArrayList<String>();
        protected Agent suppliedBy = null;
        protected String validUntilTime = null;
        protected String builtTime = null;
        protected String releaseTime = null;

        public ArtifactBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ArtifactBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ArtifactBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public ArtifactBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public ArtifactBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        public ArtifactBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public ArtifactBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public ArtifactBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        public ArtifactBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        public ArtifactBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        public ArtifactBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        @Override
        public ArtifactBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public ArtifactBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        public ArtifactBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        public ArtifactBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public ArtifactBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ArtifactBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public ArtifactBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public ArtifactBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ArtifactBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public abstract Artifact build() throws InvalidSPDXAnalysisException;
    }
}

