/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class DictionaryEntry
extends ModelObjectV3 {
    public DictionaryEntry() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public DictionaryEntry(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public DictionaryEntry(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected DictionaryEntry(DictionaryEntryBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setValue(builder.value);
        if (Objects.nonNull(builder.key)) {
            this.setKey(builder.key);
        }
    }

    public String getType() {
        return "Core.DictionaryEntry";
    }

    public Optional<String> getValue() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_VALUE);
    }

    public DictionaryEntry setValue(@Nullable String value) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_VALUE, value);
        return this;
    }

    @Nullable
    public String getKey() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_KEY);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public DictionaryEntry setKey(@Nullable String key) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(key)) {
            throw new InvalidSPDXAnalysisException("key is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_KEY, key);
        return this;
    }

    public String toString() {
        return "DictionaryEntry: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<String> optional = this.getValue();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting value for DictionaryEntry: " + e.getMessage());
        }
        try {
            String key = this.getKey();
            if (Objects.isNull(key) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing key in DictionaryEntry");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting key for DictionaryEntry: " + e.getMessage());
        }
        return retval;
    }

    public static class DictionaryEntryBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected String value = null;
        protected String key = null;

        public DictionaryEntryBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public DictionaryEntryBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public DictionaryEntryBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public DictionaryEntryBuilder setValue(String value) {
            this.value = value;
            return this;
        }

        public DictionaryEntryBuilder setKey(String key) {
            this.key = key;
            return this;
        }

        public DictionaryEntry build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                DictionaryEntry dictionaryEntry = new DictionaryEntry(this);
                return dictionaryEntry;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

