/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public abstract class ElementCollection
extends Element {
    Collection<Element> rootElements = Collections.emptyList();
    Collection<Element> elements = Collections.emptyList();
    Collection<ProfileIdentifierType> profileConformances = Collections.emptyList();

    public ElementCollection() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ElementCollection(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ElementCollection(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.rootElements = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ROOT_ELEMENT, Element.class);
        }
        if (!this.isExternal()) {
            this.elements = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ELEMENT, Element.class);
        }
        if (!this.isExternal()) {
            this.profileConformances = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PROFILE_CONFORMANCE, ProfileIdentifierType.class);
        }
    }

    protected ElementCollection(ElementCollectionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.rootElements = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ROOT_ELEMENT, Element.class);
        this.elements = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_ELEMENT, Element.class);
        this.profileConformances = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_PROFILE_CONFORMANCE, ProfileIdentifierType.class);
        this.getRootElements().addAll(builder.rootElements);
        this.getElements().addAll(builder.elements);
        this.getProfileConformances().addAll(builder.profileConformances);
    }

    @Override
    public String getType() {
        return "Core.ElementCollection";
    }

    public Collection<Element> getRootElements() {
        return this.rootElements;
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    public Collection<ProfileIdentifierType> getProfileConformances() {
        return this.profileConformances;
    }

    @Override
    public ElementCollection setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public ElementCollection setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public ElementCollection setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public ElementCollection setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public ElementCollection setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        for (Element rootElement : this.rootElements) {
            retval.addAll(rootElement.verify(verifiedIds, specVersionForVerify, profiles));
        }
        for (Element element : this.elements) {
            retval.addAll(element.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static abstract class ElementCollectionBuilder
    extends Element.ElementBuilder {
        protected Collection<Element> rootElements = new ArrayList<Element>();
        protected Collection<Element> elements = new ArrayList<Element>();
        protected Collection<ProfileIdentifierType> profileConformances = new ArrayList<ProfileIdentifierType>();

        public ElementCollectionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ElementCollectionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ElementCollectionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public ElementCollectionBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public ElementCollectionBuilder addRootElement(Element rootElement) {
            if (Objects.nonNull((Object)rootElement)) {
                this.rootElements.add(rootElement);
            }
            return this;
        }

        public ElementCollectionBuilder addAllRootElement(Collection<Element> rootElementCollection) {
            if (Objects.nonNull(rootElementCollection)) {
                this.rootElements.addAll(rootElementCollection);
            }
            return this;
        }

        public ElementCollectionBuilder addElement(Element element) {
            if (Objects.nonNull((Object)element)) {
                this.elements.add(element);
            }
            return this;
        }

        public ElementCollectionBuilder addAllElement(Collection<Element> elementCollection) {
            if (Objects.nonNull(elementCollection)) {
                this.elements.addAll(elementCollection);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public ElementCollectionBuilder addProfileConformance(ProfileIdentifierType profileConformance) {
            if (Objects.nonNull((Object)profileConformance)) {
                this.profileConformances.add(profileConformance);
            }
            return this;
        }

        public ElementCollectionBuilder addAllProfileConformance(Collection<ProfileIdentifierType> profileConformanceCollection) {
            if (Objects.nonNull(profileConformanceCollection)) {
                this.profileConformances.addAll(profileConformanceCollection);
            }
            return this;
        }

        @Override
        public ElementCollectionBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public ElementCollectionBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ElementCollectionBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ElementCollectionBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ElementCollectionBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public abstract ElementCollection build() throws InvalidSPDXAnalysisException;
    }
}

