/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ExternalRefType;
import org.spdx.storage.IModelStore;

public class ExternalRef
extends ModelObjectV3 {
    Collection<String> locators = Collections.emptyList();

    public ExternalRef() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ExternalRef(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ExternalRef(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.locators = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_LOCATOR, String.class);
        }
    }

    protected ExternalRef(ExternalRefBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.locators = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_LOCATOR, String.class);
        this.getLocators().addAll(builder.locators);
        this.setExternalRefType(builder.externalRefType);
        this.setContentType(builder.contentType);
        this.setComment(builder.comment);
    }

    public String getType() {
        return "Core.ExternalRef";
    }

    public Collection<String> getLocators() {
        return this.locators;
    }

    public Optional<ExternalRefType> getExternalRefType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_REF_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ExternalRefType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for externalRefType");
            }
            return retval;
        }
        return Optional.empty();
    }

    public ExternalRef setExternalRefType(@Nullable ExternalRefType externalRefType) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_EXTERNAL_REF_TYPE, (Object)externalRefType);
        return this;
    }

    public Optional<String> getContentType() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE);
    }

    public ExternalRef setContentType(@Nullable String contentType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(contentType) && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType)) {
            throw new InvalidSPDXAnalysisException("contentType value '" + contentType + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE, contentType);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_COMMENT);
    }

    public ExternalRef setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMMENT, comment);
        return this;
    }

    public String toString() {
        return "ExternalRef: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<ExternalRefType> optional = this.getExternalRefType();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting externalRefType for ExternalRef: " + e.getMessage());
        }
        try {
            Optional<String> contentType = this.getContentType();
            if (contentType.isPresent() && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType.get())) {
                retval.add("contentType value '" + contentType.get() + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting contentType for ExternalRef: " + e.getMessage());
        }
        try {
            Optional<String> e = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting comment for ExternalRef: " + e.getMessage());
        }
        return retval;
    }

    public static class ExternalRefBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Collection<String> locators = new ArrayList<String>();
        protected ExternalRefType externalRefType = null;
        protected String contentType = null;
        protected String comment = null;

        public ExternalRefBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ExternalRefBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public ExternalRefBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public ExternalRefBuilder addLocator(String locator) {
            if (Objects.nonNull(locator)) {
                this.locators.add(locator);
            }
            return this;
        }

        public ExternalRefBuilder addAllLocator(Collection<String> locatorCollection) {
            if (Objects.nonNull(locatorCollection)) {
                this.locators.addAll(locatorCollection);
            }
            return this;
        }

        public ExternalRefBuilder setExternalRefType(ExternalRefType externalRefType) {
            this.externalRefType = externalRefType;
            return this;
        }

        public ExternalRefBuilder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public ExternalRefBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public ExternalRef build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ExternalRef externalRef = new ExternalRef(this);
                return externalRef;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

