/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.storage.IModelStore;

public class PositiveIntegerRange
extends ModelObjectV3 {
    public PositiveIntegerRange() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public PositiveIntegerRange(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public PositiveIntegerRange(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected PositiveIntegerRange(PositiveIntegerRangeBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull(builder.endIntegerRange)) {
            this.setEndIntegerRange(builder.endIntegerRange);
        }
        if (Objects.nonNull(builder.beginIntegerRange)) {
            this.setBeginIntegerRange(builder.beginIntegerRange);
        }
    }

    public String getType() {
        return "Core.PositiveIntegerRange";
    }

    @Nullable
    public Integer getEndIntegerRange() throws InvalidSPDXAnalysisException {
        Optional retval = this.getIntegerPropertyValue(SpdxConstantsV3.PROP_END_INTEGER_RANGE);
        return retval.isPresent() ? (Integer)retval.get() : null;
    }

    public PositiveIntegerRange setEndIntegerRange(@Nullable Integer endIntegerRange) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(endIntegerRange)) {
            throw new InvalidSPDXAnalysisException("endIntegerRange is a required property");
        }
        if (this.isStrict() && Objects.nonNull(endIntegerRange) && endIntegerRange < 1) {
            throw new InvalidSPDXAnalysisException("endIntegerRange value " + endIntegerRange + " is less than the minimum 1 in PositiveIntegerRange");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_END_INTEGER_RANGE, endIntegerRange);
        return this;
    }

    @Nullable
    public Integer getBeginIntegerRange() throws InvalidSPDXAnalysisException {
        Optional retval = this.getIntegerPropertyValue(SpdxConstantsV3.PROP_BEGIN_INTEGER_RANGE);
        return retval.isPresent() ? (Integer)retval.get() : null;
    }

    public PositiveIntegerRange setBeginIntegerRange(@Nullable Integer beginIntegerRange) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(beginIntegerRange)) {
            throw new InvalidSPDXAnalysisException("beginIntegerRange is a required property");
        }
        if (this.isStrict() && Objects.nonNull(beginIntegerRange) && beginIntegerRange < 1) {
            throw new InvalidSPDXAnalysisException("beginIntegerRange value " + beginIntegerRange + " is less than the minimum 1 in PositiveIntegerRange");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_BEGIN_INTEGER_RANGE, beginIntegerRange);
        return this;
    }

    public String toString() {
        return "PositiveIntegerRange: " + this.getObjectUri();
    }

    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Integer endIntegerRange = this.getEndIntegerRange();
            if (Objects.isNull(endIntegerRange) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing endIntegerRange in PositiveIntegerRange");
            }
            if (Objects.nonNull(endIntegerRange) && endIntegerRange < 1) {
                retval.add("endIntegerRange value " + endIntegerRange + " is less than the minimum 1 in PositiveIntegerRange");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting endIntegerRange for PositiveIntegerRange: " + e.getMessage());
        }
        try {
            Integer beginIntegerRange = this.getBeginIntegerRange();
            if (Objects.isNull(beginIntegerRange) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing beginIntegerRange in PositiveIntegerRange");
            }
            if (Objects.nonNull(beginIntegerRange) && beginIntegerRange < 1) {
                retval.add("beginIntegerRange value " + beginIntegerRange + " is less than the minimum 1 in PositiveIntegerRange");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting beginIntegerRange for PositiveIntegerRange: " + e.getMessage());
        }
        return retval;
    }

    public static class PositiveIntegerRangeBuilder
    extends ModelObjectV3.ModelObjectV3Builder {
        protected Integer endIntegerRange = null;
        protected Integer beginIntegerRange = null;

        public PositiveIntegerRangeBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public PositiveIntegerRangeBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public PositiveIntegerRangeBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public PositiveIntegerRangeBuilder setEndIntegerRange(Integer endIntegerRange) {
            this.endIntegerRange = endIntegerRange;
            return this;
        }

        public PositiveIntegerRangeBuilder setBeginIntegerRange(Integer beginIntegerRange) {
            this.beginIntegerRange = beginIntegerRange;
            return this;
        }

        public PositiveIntegerRange build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                PositiveIntegerRange positiveIntegerRange = new PositiveIntegerRange(this);
                return positiveIntegerRange;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

