/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class Relationship
extends Element {
    Collection<Element> tos = Collections.emptyList();

    public Relationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public Relationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public Relationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.tos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TO, Element.class);
        }
    }

    protected Relationship(RelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.tos = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_TO, Element.class);
        this.getTos().addAll(builder.tos);
        if (Objects.nonNull((Object)builder.from)) {
            this.setFrom(builder.from);
        }
        this.setCompleteness(builder.completeness);
        if (Objects.nonNull((Object)builder.relationshipType)) {
            this.setRelationshipType(builder.relationshipType);
        }
        this.setEndTime(builder.endTime);
        this.setStartTime(builder.startTime);
    }

    @Override
    public String getType() {
        return "Core.Relationship";
    }

    public Collection<Element> getTos() {
        return this.tos;
    }

    @Nullable
    public Element getFrom() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_FROM);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof Element)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for from");
            }
            return (Element)((Object)retval.get());
        }
        return null;
    }

    public Relationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)from)) {
            throw new InvalidSPDXAnalysisException("from is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_FROM, (Object)from);
        return this;
    }

    @Override
    public Relationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    public Optional<RelationshipCompleteness> getCompleteness() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_COMPLETENESS);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof RelationshipCompleteness)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for completeness");
            }
            return retval;
        }
        return Optional.empty();
    }

    public Relationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_COMPLETENESS, (Object)completeness);
        return this;
    }

    @Nullable
    public RelationshipType getRelationshipType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_RELATIONSHIP_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof RelationshipType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for relationshipType");
            }
            return (RelationshipType)((Object)retval.get());
        }
        return null;
    }

    public Relationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)relationshipType)) {
            throw new InvalidSPDXAnalysisException("relationshipType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_RELATIONSHIP_TYPE, (Object)relationshipType);
        return this;
    }

    @Override
    public Relationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public Relationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    public Optional<String> getEndTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_END_TIME);
    }

    public Relationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(endTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", endTime)) {
            throw new InvalidSPDXAnalysisException("endTime value '" + endTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_END_TIME, endTime);
        return this;
    }

    public Optional<String> getStartTime() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_START_TIME);
    }

    public Relationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(startTime) && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", startTime)) {
            throw new InvalidSPDXAnalysisException("startTime value '" + startTime + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_START_TIME, startTime);
        return this;
    }

    @Override
    public Relationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public Relationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Element from = this.getFrom();
            if (Objects.nonNull((Object)from)) {
                retval.addAll(from.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing from in Relationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting from for Relationship: " + e.getMessage());
        }
        try {
            Optional<RelationshipCompleteness> e = this.getCompleteness();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting completeness for Relationship: " + e.getMessage());
        }
        try {
            RelationshipType relationshipType = this.getRelationshipType();
            if (Objects.isNull((Object)relationshipType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.CORE))) {
                retval.add("Missing relationshipType in Relationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting relationshipType for Relationship: " + e.getMessage());
        }
        try {
            Optional<String> endTime = this.getEndTime();
            if (endTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", endTime.get())) {
                retval.add("endTime value '" + endTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting endTime for Relationship: " + e.getMessage());
        }
        try {
            Optional<String> startTime = this.getStartTime();
            if (startTime.isPresent() && !Pattern.matches("^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$", startTime.get())) {
                retval.add("startTime value '" + startTime.get() + "' does not match the pattern '^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\dZ$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting startTime for Relationship: " + e.getMessage());
        }
        for (Element to : this.tos) {
            retval.addAll(to.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class RelationshipBuilder
    extends Element.ElementBuilder {
        protected Collection<Element> tos = new ArrayList<Element>();
        protected Element from = null;
        protected RelationshipCompleteness completeness = null;
        protected RelationshipType relationshipType = null;
        protected String endTime = null;
        protected String startTime = null;

        public RelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public RelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public RelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public RelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        public RelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        public RelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public RelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public RelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public RelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public RelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        public RelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        public RelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public RelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public RelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public RelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public RelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public RelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Relationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                Relationship relationship = new Relationship(this);
                return relationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

