/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class ConjunctiveLicenseSet
extends AnyLicenseInfo {
    Set<AnyLicenseInfo> members = Collections.emptySet();

    public ConjunctiveLicenseSet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ConjunctiveLicenseSet(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ConjunctiveLicenseSet(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.members = this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
        }
    }

    protected ConjunctiveLicenseSet(ConjunctiveLicenseSetBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.members = this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
        this.getMembers().addAll(builder.members);
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.ConjunctiveLicenseSet";
    }

    public Set<AnyLicenseInfo> getMembers() {
        return this.members;
    }

    @Override
    public ConjunctiveLicenseSet setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public ConjunctiveLicenseSet setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public ConjunctiveLicenseSet setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public ConjunctiveLicenseSet setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public ConjunctiveLicenseSet setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
        while (iter.hasNext()) {
            if (moreThanOne) {
                sb.append(" AND ");
            }
            moreThanOne = true;
            sb.append(iter.next().toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        for (AnyLicenseInfo member : this.members) {
            retval.addAll(member.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public List<AnyLicenseInfo> getFlattenedMembers() throws InvalidSPDXAnalysisException {
        HashSet<AnyLicenseInfo> retval = new HashSet<AnyLicenseInfo>();
        for (AnyLicenseInfo li : this.getMembers()) {
            if (li instanceof ConjunctiveLicenseSet) {
                List<AnyLicenseInfo> members = ((ConjunctiveLicenseSet)li).getFlattenedMembers();
                for (int i = 0; i < members.size(); ++i) {
                    retval.add(members.get(i));
                }
                continue;
            }
            retval.add(li);
        }
        ArrayList<AnyLicenseInfo> retvallist = new ArrayList<AnyLicenseInfo>();
        retvallist.addAll(retval);
        return retvallist;
    }

    public int hashCode() {
        List<AnyLicenseInfo> allMembers;
        int retval = 1381;
        try {
            allMembers = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        for (AnyLicenseInfo licenseInfo : allMembers) {
            retval ^= licenseInfo.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConjunctiveLicenseSet)) {
            return false;
        }
        ConjunctiveLicenseSet comp = (ConjunctiveLicenseSet)((Object)o);
        try {
            compInfos = comp.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting compare license set members", e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains((Object)myInfo)) continue;
            return false;
        }
        return true;
    }

    public boolean equivalent(CoreModelObject compare) throws InvalidSPDXAnalysisException {
        if (!(compare instanceof ConjunctiveLicenseSet)) {
            return false;
        }
        return this.setsEquivalent((ConjunctiveLicenseSet)compare);
    }

    protected boolean setsEquivalent(ConjunctiveLicenseSet compare) throws InvalidSPDXAnalysisException {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        try {
            compInfos = compare.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting compare license set members", e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains((Object)myInfo)) continue;
            boolean found = false;
            for (AnyLicenseInfo compInfo : compInfos) {
                if (!myInfo.equivalent(compInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static class ConjunctiveLicenseSetBuilder
    extends AnyLicenseInfo.AnyLicenseInfoBuilder {
        protected Set<AnyLicenseInfo> members = new HashSet<AnyLicenseInfo>();

        public ConjunctiveLicenseSetBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ConjunctiveLicenseSetBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ConjunctiveLicenseSetBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public ConjunctiveLicenseSetBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public ConjunctiveLicenseSetBuilder addMember(AnyLicenseInfo member) {
            if (Objects.nonNull((Object)member)) {
                this.members.add(member);
            }
            return this;
        }

        public ConjunctiveLicenseSetBuilder addAllMember(Set<AnyLicenseInfo> memberSet) {
            if (Objects.nonNull(memberSet)) {
                this.members.addAll(memberSet);
            }
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ConjunctiveLicenseSetBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ConjunctiveLicenseSet build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ConjunctiveLicenseSet conjunctiveLicenseSet = new ConjunctiveLicenseSet(this);
                return conjunctiveLicenseSet;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

