/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.CoreModelObject;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class DisjunctiveLicenseSet
extends AnyLicenseInfo {
    Set<AnyLicenseInfo> members = Collections.emptySet();

    public DisjunctiveLicenseSet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public DisjunctiveLicenseSet(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public DisjunctiveLicenseSet(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.members = this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
        }
    }

    protected DisjunctiveLicenseSet(DisjunctiveLicenseSetBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.members = this.getObjectPropertyValueSet(SpdxConstantsV3.PROP_MEMBER, AnyLicenseInfo.class);
        this.getMembers().addAll(builder.members);
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.DisjunctiveLicenseSet";
    }

    public Set<AnyLicenseInfo> getMembers() {
        return this.members;
    }

    @Override
    public DisjunctiveLicenseSet setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public DisjunctiveLicenseSet setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public DisjunctiveLicenseSet setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public DisjunctiveLicenseSet setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public DisjunctiveLicenseSet setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
        while (iter.hasNext()) {
            if (moreThanOne) {
                sb.append(" OR ");
            }
            moreThanOne = true;
            sb.append(iter.next().toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        for (AnyLicenseInfo member : this.members) {
            retval.addAll(member.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public List<AnyLicenseInfo> getFlattenedMembers() throws InvalidSPDXAnalysisException {
        HashSet<AnyLicenseInfo> retval = new HashSet<AnyLicenseInfo>();
        for (AnyLicenseInfo li : this.getMembers()) {
            if (li instanceof DisjunctiveLicenseSet) {
                List<AnyLicenseInfo> members = ((DisjunctiveLicenseSet)li).getFlattenedMembers();
                for (int i = 0; i < members.size(); ++i) {
                    retval.add(members.get(i));
                }
                continue;
            }
            retval.add(li);
        }
        ArrayList<AnyLicenseInfo> retvallist = new ArrayList<AnyLicenseInfo>();
        retvallist.addAll(retval);
        return retvallist;
    }

    public int hashCode() {
        List<AnyLicenseInfo> allMembers;
        int retval = 41;
        try {
            allMembers = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        for (AnyLicenseInfo licenseInfo : allMembers) {
            retval ^= licenseInfo.hashCode();
        }
        return retval;
    }

    public boolean equals(Object o) {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        DisjunctiveLicenseSet comp = (DisjunctiveLicenseSet)((Object)o);
        try {
            compInfos = comp.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting compare license set members", e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains((Object)myInfo)) continue;
            return false;
        }
        return true;
    }

    public boolean equivalent(CoreModelObject compare) throws InvalidSPDXAnalysisException {
        if (!(compare instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        return this.setsEquivalent((DisjunctiveLicenseSet)compare);
    }

    protected boolean setsEquivalent(DisjunctiveLicenseSet compare) throws InvalidSPDXAnalysisException {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        try {
            compInfos = compare.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting compare license set members", e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains((Object)myInfo)) continue;
            boolean found = false;
            for (AnyLicenseInfo compInfo : compInfos) {
                if (!myInfo.equivalent(compInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static class DisjunctiveLicenseSetBuilder
    extends AnyLicenseInfo.AnyLicenseInfoBuilder {
        protected Set<AnyLicenseInfo> members = new HashSet<AnyLicenseInfo>();

        public DisjunctiveLicenseSetBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public DisjunctiveLicenseSetBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public DisjunctiveLicenseSetBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public DisjunctiveLicenseSetBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        public DisjunctiveLicenseSetBuilder addMember(AnyLicenseInfo member) {
            if (Objects.nonNull((Object)member)) {
                this.members.add(member);
            }
            return this;
        }

        public DisjunctiveLicenseSetBuilder addAllMember(Set<AnyLicenseInfo> memberSet) {
            if (Objects.nonNull(memberSet)) {
                this.members.addAll(memberSet);
            }
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DisjunctiveLicenseSetBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public DisjunctiveLicenseSet build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                DisjunctiveLicenseSet disjunctiveLicenseSet = new DisjunctiveLicenseSet(this);
                return disjunctiveLicenseSet;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

