/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExtendableLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class OrLaterOperator
extends ExtendableLicense {
    public OrLaterOperator() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public OrLaterOperator(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public OrLaterOperator(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected OrLaterOperator(OrLaterOperatorBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.subjectLicense)) {
            this.setSubjectLicense(builder.subjectLicense);
        }
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.OrLaterOperator";
    }

    @Override
    public OrLaterOperator setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Nullable
    public License getSubjectLicense() throws InvalidSPDXAnalysisException {
        Optional retval = this.getObjectPropertyValue(SpdxConstantsV3.PROP_SUBJECT_LICENSE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof License)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for subjectLicense");
            }
            return (License)((Object)retval.get());
        }
        return null;
    }

    public OrLaterOperator setSubjectLicense(@Nullable License subjectLicense) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)subjectLicense)) {
            throw new InvalidSPDXAnalysisException("subjectLicense is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SUBJECT_LICENSE, (Object)subjectLicense);
        return this;
    }

    @Override
    public OrLaterOperator setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public OrLaterOperator setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public OrLaterOperator setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public OrLaterOperator setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public String toString() {
        try {
            String subjectLicense = Objects.nonNull((Object)this.getSubjectLicense()) ? this.getSubjectLicense().toString() : "[Missing Subject License]";
            return subjectLicense + "+";
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error: " + e.getMessage();
        }
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            License subjectLicense = this.getSubjectLicense();
            if (Objects.nonNull((Object)subjectLicense)) {
                retval.addAll(subjectLicense.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXPANDED_LICENSING))) {
                retval.add("Missing subjectLicense in OrLaterOperator");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting subjectLicense for OrLaterOperator: " + e.getMessage());
        }
        return retval;
    }

    public boolean equals(Object compare) {
        if (!(compare instanceof OrLaterOperator)) {
            return false;
        }
        try {
            License cLic = ((OrLaterOperator)((Object)compare)).getSubjectLicense();
            return Objects.equals((Object)this.getSubjectLicense(), (Object)cLic);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int licHashCode = 101;
        try {
            if (this.getSubjectLicense() != null) {
                licHashCode = this.getSubjectLicense().hashCode() ^ 0x65;
            }
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        return licHashCode;
    }

    public static class OrLaterOperatorBuilder
    extends ExtendableLicense.ExtendableLicenseBuilder {
        protected License subjectLicense = null;

        public OrLaterOperatorBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public OrLaterOperatorBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public OrLaterOperatorBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public OrLaterOperatorBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public OrLaterOperatorBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public OrLaterOperatorBuilder setSubjectLicense(License subjectLicense) {
            this.subjectLicense = subjectLicense;
            return this;
        }

        @Override
        public OrLaterOperatorBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public OrLaterOperatorBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public OrLaterOperatorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public OrLaterOperatorBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public OrLaterOperator build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                OrLaterOperator orLaterOperator = new OrLaterOperator(this);
                return orLaterOperator;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

