/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.expandedlicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExtendableLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.LicenseAddition;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class WithAdditionOperator
extends AnyLicenseInfo {
    public WithAdditionOperator() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public WithAdditionOperator(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public WithAdditionOperator(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected WithAdditionOperator(WithAdditionOperatorBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.subjectAddition)) {
            this.setSubjectAddition(builder.subjectAddition);
        }
        if (Objects.nonNull((Object)builder.subjectExtendableLicense)) {
            this.setSubjectExtendableLicense(builder.subjectExtendableLicense);
        }
    }

    @Override
    public String getType() {
        return "ExpandedLicensing.WithAdditionOperator";
    }

    @Override
    public WithAdditionOperator setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Nullable
    public LicenseAddition getSubjectAddition() throws InvalidSPDXAnalysisException {
        Optional<LicenseAddition> retval = this.getLicenseAdditionPropertyValue(SpdxConstantsV3.PROP_SUBJECT_ADDITION);
        return retval.isPresent() ? retval.get() : null;
    }

    public WithAdditionOperator setSubjectAddition(@Nullable LicenseAddition subjectAddition) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)subjectAddition)) {
            throw new InvalidSPDXAnalysisException("subjectAddition is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SUBJECT_ADDITION, (Object)subjectAddition);
        return this;
    }

    @Nullable
    public ExtendableLicense getSubjectExtendableLicense() throws InvalidSPDXAnalysisException {
        Optional<ExtendableLicense> retval = this.getExtendableLicensePropertyValue(SpdxConstantsV3.PROP_SUBJECT_EXTENDABLE_LICENSE);
        return retval.isPresent() ? retval.get() : null;
    }

    public WithAdditionOperator setSubjectExtendableLicense(@Nullable ExtendableLicense subjectExtendableLicense) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)subjectExtendableLicense)) {
            throw new InvalidSPDXAnalysisException("subjectExtendableLicense is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SUBJECT_EXTENDABLE_LICENSE, (Object)subjectExtendableLicense);
        return this;
    }

    @Override
    public WithAdditionOperator setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public WithAdditionOperator setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public WithAdditionOperator setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public WithAdditionOperator setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public String toString() {
        try {
            String extendableLicenseStr = Objects.nonNull((Object)this.getSubjectExtendableLicense()) ? this.getSubjectExtendableLicense().toString() : "[Missing extendableLicense]";
            String subjectAdditionStr = Objects.nonNull((Object)this.getSubjectAddition()) ? this.getSubjectAddition().toString() : "[Missing subjectAddition]";
            return extendableLicenseStr + " WITH " + subjectAdditionStr;
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error: " + e.getMessage();
        }
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            LicenseAddition subjectAddition = this.getSubjectAddition();
            if (Objects.nonNull((Object)subjectAddition)) {
                retval.addAll(subjectAddition.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXPANDED_LICENSING))) {
                retval.add("Missing subjectAddition in WithAdditionOperator");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting subjectAddition for WithAdditionOperator: " + e.getMessage());
        }
        try {
            ExtendableLicense subjectExtendableLicense = this.getSubjectExtendableLicense();
            if (Objects.nonNull((Object)subjectExtendableLicense)) {
                retval.addAll(subjectExtendableLicense.verify(verifiedIds, specVersionForVerify, profiles));
            } else if (!Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.EXPANDED_LICENSING))) {
                retval.add("Missing subjectExtendableLicense in WithAdditionOperator");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting subjectExtendableLicense for WithAdditionOperator: " + e.getMessage());
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WithAdditionOperator)) {
            return false;
        }
        WithAdditionOperator comp = (WithAdditionOperator)((Object)o);
        ExtendableLicense myLicense = null;
        ExtendableLicense compLicense = null;
        LicenseAddition myException = null;
        LicenseAddition compException = null;
        try {
            myLicense = this.getSubjectExtendableLicense();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            compLicense = comp.getSubjectExtendableLicense();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            myException = this.getSubjectAddition();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            compException = comp.getSubjectAddition();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        if (!Objects.equals((Object)myLicense, (Object)compLicense)) {
            return false;
        }
        return Objects.equals((Object)myException, (Object)compException);
    }

    public int hashCode() {
        int licHashCode = 0;
        int exceptionHashCode = 0;
        try {
            licHashCode = this.getSubjectExtendableLicense().hashCode();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        try {
            exceptionHashCode = this.getSubjectAddition().hashCode();
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        return 0x3D1 ^ licHashCode ^ exceptionHashCode;
    }

    public static class WithAdditionOperatorBuilder
    extends AnyLicenseInfo.AnyLicenseInfoBuilder {
        protected LicenseAddition subjectAddition = null;
        protected ExtendableLicense subjectExtendableLicense = null;

        public WithAdditionOperatorBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public WithAdditionOperatorBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public WithAdditionOperatorBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public WithAdditionOperatorBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public WithAdditionOperatorBuilder setSubjectAddition(LicenseAddition subjectAddition) {
            this.subjectAddition = subjectAddition;
            return this;
        }

        public WithAdditionOperatorBuilder setSubjectExtendableLicense(ExtendableLicense subjectExtendableLicense) {
            this.subjectExtendableLicense = subjectExtendableLicense;
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public WithAdditionOperatorBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public WithAdditionOperator build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                WithAdditionOperator withAdditionOperator = new WithAdditionOperator(this);
                return withAdditionOperator;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

