/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.extension.CdxPropertyEntry;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.storage.IModelStore;

public class CdxPropertiesExtension
extends Extension {
    Collection<CdxPropertyEntry> cdxPropertys = Collections.emptyList();

    public CdxPropertiesExtension() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public CdxPropertiesExtension(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public CdxPropertiesExtension(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.cdxPropertys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CDX_PROPERTY, CdxPropertyEntry.class);
        }
    }

    protected CdxPropertiesExtension(CdxPropertiesExtensionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.cdxPropertys = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CDX_PROPERTY, CdxPropertyEntry.class);
        this.getCdxPropertys().addAll(builder.cdxPropertys);
    }

    @Override
    public String getType() {
        return "Extension.CdxPropertiesExtension";
    }

    public Collection<CdxPropertyEntry> getCdxPropertys() {
        return this.cdxPropertys;
    }

    @Override
    public String toString() {
        return "CdxPropertiesExtension: " + this.getObjectUri();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        for (CdxPropertyEntry cdxProperty : this.cdxPropertys) {
            retval.addAll(cdxProperty.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class CdxPropertiesExtensionBuilder
    extends Extension.ExtensionBuilder {
        protected Collection<CdxPropertyEntry> cdxPropertys = new ArrayList<CdxPropertyEntry>();

        public CdxPropertiesExtensionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public CdxPropertiesExtensionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
        }

        public CdxPropertiesExtensionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        public CdxPropertiesExtensionBuilder addCdxProperty(CdxPropertyEntry cdxProperty) {
            if (Objects.nonNull((Object)cdxProperty)) {
                this.cdxPropertys.add(cdxProperty);
            }
            return this;
        }

        public CdxPropertiesExtensionBuilder addAllCdxProperty(Collection<CdxPropertyEntry> cdxPropertyCollection) {
            if (Objects.nonNull(cdxPropertyCollection)) {
                this.cdxPropertys.addAll(cdxPropertyCollection);
            }
            return this;
        }

        @Override
        public CdxPropertiesExtension build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                CdxPropertiesExtension cdxPropertiesExtension = new CdxPropertiesExtension(this);
                return cdxPropertiesExtension;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

