/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.VulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class EpssVulnAssessmentRelationship
extends VulnAssessmentRelationship {
    public EpssVulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public EpssVulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public EpssVulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected EpssVulnAssessmentRelationship(EpssVulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull(builder.probability)) {
            this.setProbability(builder.probability);
        }
        if (Objects.nonNull(builder.percentile)) {
            this.setPercentile(builder.percentile);
        }
    }

    @Override
    public String getType() {
        return "Security.EpssVulnAssessmentRelationship";
    }

    @Override
    public EpssVulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Nullable
    public Double getProbability() throws InvalidSPDXAnalysisException {
        Optional retval = this.getDoublePropertyValue(SpdxConstantsV3.PROP_PROBABILITY);
        return retval.isPresent() ? (Double)retval.get() : null;
    }

    public EpssVulnAssessmentRelationship setProbability(@Nullable Double probability) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(probability)) {
            throw new InvalidSPDXAnalysisException("probability is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_PROBABILITY, probability);
        return this;
    }

    @Nullable
    public Double getPercentile() throws InvalidSPDXAnalysisException {
        Optional retval = this.getDoublePropertyValue(SpdxConstantsV3.PROP_PERCENTILE);
        return retval.isPresent() ? (Double)retval.get() : null;
    }

    public EpssVulnAssessmentRelationship setPercentile(@Nullable Double percentile) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(percentile)) {
            throw new InvalidSPDXAnalysisException("percentile is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_PERCENTILE, percentile);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public EpssVulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Double probability = this.getProbability();
            if (Objects.isNull(probability) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing probability in EpssVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting probability for EpssVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            Double percentile = this.getPercentile();
            if (Objects.isNull(percentile) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing percentile in EpssVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting percentile for EpssVulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class EpssVulnAssessmentRelationshipBuilder
    extends VulnAssessmentRelationship.VulnAssessmentRelationshipBuilder {
        protected Double probability = null;
        protected Double percentile = null;

        public EpssVulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public EpssVulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public EpssVulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        public EpssVulnAssessmentRelationshipBuilder setProbability(Double probability) {
            this.probability = probability;
            return this;
        }

        public EpssVulnAssessmentRelationshipBuilder setPercentile(Double percentile) {
            this.percentile = percentile;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public EpssVulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                EpssVulnAssessmentRelationship epssVulnAssessmentRelationship = new EpssVulnAssessmentRelationship(this);
                return epssVulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

