/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.RelationshipCompleteness;
import org.spdx.library.model.v3_0_1.core.RelationshipType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.security.ExploitCatalogType;
import org.spdx.library.model.v3_0_1.security.VulnAssessmentRelationship;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.storage.IModelStore;

public class ExploitCatalogVulnAssessmentRelationship
extends VulnAssessmentRelationship {
    public ExploitCatalogVulnAssessmentRelationship() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public ExploitCatalogVulnAssessmentRelationship(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public ExploitCatalogVulnAssessmentRelationship(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected ExploitCatalogVulnAssessmentRelationship(ExploitCatalogVulnAssessmentRelationshipBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        if (Objects.nonNull((Object)builder.catalogType)) {
            this.setCatalogType(builder.catalogType);
        }
        if (Objects.nonNull(builder.exploited)) {
            this.setExploited(builder.exploited);
        }
        if (Objects.nonNull(builder.SecurityLocator)) {
            this.setSecurityLocator(builder.SecurityLocator);
        }
    }

    @Override
    public String getType() {
        return "Security.ExploitCatalogVulnAssessmentRelationship";
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setFrom(@Nullable Element from) throws InvalidSPDXAnalysisException {
        super.setFrom(from);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setAssessedElement(@Nullable SoftwareArtifact assessedElement) throws InvalidSPDXAnalysisException {
        super.setAssessedElement(assessedElement);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setCompleteness(@Nullable RelationshipCompleteness completeness) throws InvalidSPDXAnalysisException {
        super.setCompleteness(completeness);
        return this;
    }

    @Nullable
    public ExploitCatalogType getCatalogType() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_CATALOG_TYPE);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ExploitCatalogType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for catalogType");
            }
            return (ExploitCatalogType)((Object)retval.get());
        }
        return null;
    }

    public ExploitCatalogVulnAssessmentRelationship setCatalogType(@Nullable ExploitCatalogType catalogType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull((Object)catalogType)) {
            throw new InvalidSPDXAnalysisException("catalogType is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CATALOG_TYPE, (Object)catalogType);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setRelationshipType(@Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        super.setRelationshipType(relationshipType);
        return this;
    }

    @Nullable
    public Boolean getExploited() throws InvalidSPDXAnalysisException {
        Optional retval = this.getBooleanPropertyValue(SpdxConstantsV3.PROP_EXPLOITED);
        return retval.isPresent() ? (Boolean)retval.get() : null;
    }

    public ExploitCatalogVulnAssessmentRelationship setExploited(@Nullable Boolean exploited) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(exploited)) {
            throw new InvalidSPDXAnalysisException("exploited is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_EXPLOITED, exploited);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setPublishedTime(@Nullable String publishedTime) throws InvalidSPDXAnalysisException {
        super.setPublishedTime(publishedTime);
        return this;
    }

    @Nullable
    public String getSecurityLocator() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_SECURITY_LOCATOR);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public ExploitCatalogVulnAssessmentRelationship setSecurityLocator(@Nullable String SecurityLocator) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(SecurityLocator)) {
            throw new InvalidSPDXAnalysisException("SecurityLocator is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_SECURITY_LOCATOR, SecurityLocator);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setEndTime(@Nullable String endTime) throws InvalidSPDXAnalysisException {
        super.setEndTime(endTime);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setStartTime(@Nullable String startTime) throws InvalidSPDXAnalysisException {
        super.setStartTime(startTime);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setWithdrawnTime(@Nullable String withdrawnTime) throws InvalidSPDXAnalysisException {
        super.setWithdrawnTime(withdrawnTime);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public ExploitCatalogVulnAssessmentRelationship setModifiedTime(@Nullable String modifiedTime) throws InvalidSPDXAnalysisException {
        super.setModifiedTime(modifiedTime);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            ExploitCatalogType catalogType = this.getCatalogType();
            if (Objects.isNull((Object)catalogType) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing catalogType in ExploitCatalogVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting catalogType for ExploitCatalogVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            Boolean exploited = this.getExploited();
            if (Objects.isNull(exploited) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing exploited in ExploitCatalogVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting exploited for ExploitCatalogVulnAssessmentRelationship: " + e.getMessage());
        }
        try {
            String SecurityLocator = this.getSecurityLocator();
            if (Objects.isNull(SecurityLocator) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SECURITY))) {
                retval.add("Missing SecurityLocator in ExploitCatalogVulnAssessmentRelationship");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting SecurityLocator for ExploitCatalogVulnAssessmentRelationship: " + e.getMessage());
        }
        return retval;
    }

    public static class ExploitCatalogVulnAssessmentRelationshipBuilder
    extends VulnAssessmentRelationship.VulnAssessmentRelationshipBuilder {
        protected ExploitCatalogType catalogType = null;
        protected Boolean exploited = null;
        protected String SecurityLocator = null;

        public ExploitCatalogVulnAssessmentRelationshipBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public ExploitCatalogVulnAssessmentRelationshipBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public ExploitCatalogVulnAssessmentRelationshipBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addTo(Element to) {
            if (Objects.nonNull((Object)to)) {
                this.tos.add(to);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addAllTo(Collection<Element> toCollection) {
            if (Objects.nonNull(toCollection)) {
                this.tos.addAll(toCollection);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setFrom(Element from) {
            this.from = from;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setAssessedElement(SoftwareArtifact assessedElement) {
            this.assessedElement = assessedElement;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setCompleteness(RelationshipCompleteness completeness) {
            this.completeness = completeness;
            return this;
        }

        public ExploitCatalogVulnAssessmentRelationshipBuilder setCatalogType(ExploitCatalogType catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setRelationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        public ExploitCatalogVulnAssessmentRelationshipBuilder setExploited(Boolean exploited) {
            this.exploited = exploited;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setPublishedTime(String publishedTime) {
            this.publishedTime = publishedTime;
            return this;
        }

        public ExploitCatalogVulnAssessmentRelationshipBuilder setSecurityLocator(String SecurityLocator) {
            this.SecurityLocator = SecurityLocator;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setWithdrawnTime(String withdrawnTime) {
            this.withdrawnTime = withdrawnTime;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationshipBuilder setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        @Override
        public ExploitCatalogVulnAssessmentRelationship build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                ExploitCatalogVulnAssessmentRelationship exploitCatalogVulnAssessmentRelationship = new ExploitCatalogVulnAssessmentRelationship(this);
                return exploitCatalogVulnAssessmentRelationship;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

