/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.simplelicensing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.DictionaryEntry;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public class LicenseExpression
extends AnyLicenseInfo {
    Collection<DictionaryEntry> customIdToUris = Collections.emptyList();

    public LicenseExpression() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public LicenseExpression(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public LicenseExpression(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
        if (!this.isExternal()) {
            this.customIdToUris = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CUSTOM_ID_TO_URI, DictionaryEntry.class);
        }
    }

    protected LicenseExpression(LicenseExpressionBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.customIdToUris = this.getObjectPropertyValueCollection(SpdxConstantsV3.PROP_CUSTOM_ID_TO_URI, DictionaryEntry.class);
        this.getCustomIdToUris().addAll(builder.customIdToUris);
        if (Objects.nonNull(builder.licenseExpression)) {
            this.setLicenseExpression(builder.licenseExpression);
        }
        this.setLicenseListVersion(builder.licenseListVersion);
    }

    @Override
    public String getType() {
        return "SimpleLicensing.LicenseExpression";
    }

    public Collection<DictionaryEntry> getCustomIdToUris() {
        return this.customIdToUris;
    }

    @Override
    public LicenseExpression setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public LicenseExpression setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public LicenseExpression setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Nullable
    public String getLicenseExpression() throws InvalidSPDXAnalysisException {
        Optional retval = this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_EXPRESSION);
        return retval.isPresent() ? (String)retval.get() : null;
    }

    public LicenseExpression setLicenseExpression(@Nullable String licenseExpression) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.isNull(licenseExpression)) {
            throw new InvalidSPDXAnalysisException("licenseExpression is a required property");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_EXPRESSION, licenseExpression);
        return this;
    }

    public Optional<String> getLicenseListVersion() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_LICENSE_LIST_VERSION);
    }

    public LicenseExpression setLicenseListVersion(@Nullable String licenseListVersion) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(licenseListVersion) && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", licenseListVersion)) {
            throw new InvalidSPDXAnalysisException("licenseListVersion value '" + licenseListVersion + "' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_LICENSE_LIST_VERSION, licenseListVersion);
        return this;
    }

    @Override
    public LicenseExpression setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public LicenseExpression setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            String licenseExpression = this.getLicenseExpression();
            if (Objects.isNull(licenseExpression) && Collections.disjoint(profiles, Arrays.asList(ProfileIdentifierType.SIMPLE_LICENSING))) {
                retval.add("Missing licenseExpression in LicenseExpression");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting licenseExpression for LicenseExpression: " + e.getMessage());
        }
        try {
            Optional<String> licenseListVersion = this.getLicenseListVersion();
            if (licenseListVersion.isPresent() && !Pattern.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$", licenseListVersion.get())) {
                retval.add("licenseListVersion value '" + licenseListVersion.get() + "' does not match the pattern '^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting licenseListVersion for LicenseExpression: " + e.getMessage());
        }
        for (DictionaryEntry customIdToUri : this.customIdToUris) {
            retval.addAll(customIdToUri.verify(verifiedIds, specVersionForVerify, profiles));
        }
        return retval;
    }

    public static class LicenseExpressionBuilder
    extends AnyLicenseInfo.AnyLicenseInfoBuilder {
        protected Collection<DictionaryEntry> customIdToUris = new ArrayList<DictionaryEntry>();
        protected String licenseExpression = null;
        protected String licenseListVersion = null;

        public LicenseExpressionBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public LicenseExpressionBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public LicenseExpressionBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public LicenseExpressionBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        public LicenseExpressionBuilder addCustomIdToUri(DictionaryEntry customIdToUri) {
            if (Objects.nonNull((Object)customIdToUri)) {
                this.customIdToUris.add(customIdToUri);
            }
            return this;
        }

        public LicenseExpressionBuilder addAllCustomIdToUri(Collection<DictionaryEntry> customIdToUriCollection) {
            if (Objects.nonNull(customIdToUriCollection)) {
                this.customIdToUris.addAll(customIdToUriCollection);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public LicenseExpressionBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public LicenseExpressionBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public LicenseExpressionBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public LicenseExpressionBuilder setLicenseExpression(String licenseExpression) {
            this.licenseExpression = licenseExpression;
            return this;
        }

        public LicenseExpressionBuilder setLicenseListVersion(String licenseListVersion) {
            this.licenseListVersion = licenseListVersion;
            return this;
        }

        @Override
        public LicenseExpressionBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public LicenseExpressionBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public LicenseExpression build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                LicenseExpression licenseExpression = new LicenseExpression(this);
                return licenseExpression;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

