/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.FileKindType;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.storage.IModelStore;

public class SpdxFile
extends SoftwareArtifact {
    public SpdxFile() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SpdxFile(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SpdxFile(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected SpdxFile(SpdxFileBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setFileKind(builder.fileKind);
        this.setContentType(builder.contentType);
    }

    @Override
    public String getType() {
        return "Software.SpdxFile";
    }

    @Override
    public SpdxFile setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public SpdxFile setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public SpdxFile setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        super.setPrimaryPurpose(primaryPurpose);
        return this;
    }

    public Optional<FileKindType> getFileKind() throws InvalidSPDXAnalysisException {
        Optional retval = this.getEnumPropertyValue(SpdxConstantsV3.PROP_FILE_KIND);
        if (retval.isPresent()) {
            if (!(retval.get() instanceof FileKindType)) {
                throw new InvalidSPDXAnalysisException("Incorrect type stored for fileKind");
            }
            return retval;
        }
        return Optional.empty();
    }

    public SpdxFile setFileKind(@Nullable FileKindType fileKind) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_FILE_KIND, (Object)fileKind);
        return this;
    }

    @Override
    public SpdxFile setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    @Override
    public SpdxFile setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    @Override
    public SpdxFile setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    @Override
    public SpdxFile setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public SpdxFile setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    @Override
    public SpdxFile setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    public Optional<String> getContentType() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE);
    }

    public SpdxFile setContentType(@Nullable String contentType) throws InvalidSPDXAnalysisException {
        if (this.isStrict() && Objects.nonNull(contentType) && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType)) {
            throw new InvalidSPDXAnalysisException("contentType value '" + contentType + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
        }
        this.setPropertyValue(SpdxConstantsV3.PROP_CONTENT_TYPE, contentType);
        return this;
    }

    @Override
    public SpdxFile setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    @Override
    public SpdxFile setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<FileKindType> optional = this.getFileKind();
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting fileKind for SpdxFile: " + e.getMessage());
        }
        try {
            Optional<String> contentType = this.getContentType();
            if (contentType.isPresent() && !Pattern.matches("^[^\\/]+\\/[^\\/]+$", contentType.get())) {
                retval.add("contentType value '" + contentType.get() + "' does not match the pattern '^[^\\/]+\\/[^\\/]+$'");
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Error getting contentType for SpdxFile: " + e.getMessage());
        }
        return retval;
    }

    public static class SpdxFileBuilder
    extends SoftwareArtifact.SoftwareArtifactBuilder {
        protected FileKindType fileKind = null;
        protected String contentType = null;

        public SpdxFileBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SpdxFileBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SpdxFileBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SpdxFileBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        @Override
        public SpdxFileBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SpdxFileBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public SpdxFileBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        public SpdxFileBuilder setFileKind(FileKindType fileKind) {
            this.fileKind = fileKind;
            return this;
        }

        @Override
        public SpdxFileBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        @Override
        public SpdxFileBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public SpdxFileBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public SpdxFileBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SpdxFileBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public SpdxFileBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        public SpdxFileBuilder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public SpdxFileBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SpdxFileBuilder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SpdxFile build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                SpdxFile spdxFile = new SpdxFile(this);
                return spdxFile;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

