/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.v3_0_1.software;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.core.DefaultModelStore;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v3_0_1.ModelObjectV3;
import org.spdx.library.model.v3_0_1.SpdxConstantsV3;
import org.spdx.library.model.v3_0_1.core.Agent;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ExternalIdentifier;
import org.spdx.library.model.v3_0_1.core.ExternalRef;
import org.spdx.library.model.v3_0_1.core.IntegrityMethod;
import org.spdx.library.model.v3_0_1.core.SupportType;
import org.spdx.library.model.v3_0_1.extension.Extension;
import org.spdx.library.model.v3_0_1.software.ContentIdentifier;
import org.spdx.library.model.v3_0_1.software.SoftwareArtifact;
import org.spdx.library.model.v3_0_1.software.SoftwarePurpose;
import org.spdx.storage.IModelStore;

public class SpdxPackage
extends SoftwareArtifact {
    public SpdxPackage() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous));
    }

    public SpdxPackage(String objectUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), objectUri, DefaultModelStore.getDefaultCopyManager(), true, DefaultModelStore.getDefaultDocumentUri() + "#");
    }

    public SpdxPackage(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager, boolean create, String idPrefix) throws InvalidSPDXAnalysisException {
        super(modelStore, objectUri, copyManager, create, idPrefix);
    }

    protected SpdxPackage(SpdxPackageBuilder builder) throws InvalidSPDXAnalysisException {
        super(builder);
        this.setDownloadLocation(builder.downloadLocation);
        this.setPackageVersion(builder.packageVersion);
        this.setHomePage(builder.homePage);
        this.setSourceInfo(builder.sourceInfo);
        this.setPackageUrl(builder.packageUrl);
    }

    @Override
    public String getType() {
        return "Software.SpdxPackage";
    }

    @Override
    public SpdxPackage setCreationInfo(@Nullable CreationInfo creationInfo) throws InvalidSPDXAnalysisException {
        super.setCreationInfo(creationInfo);
        return this;
    }

    @Override
    public SpdxPackage setSuppliedBy(@Nullable Agent suppliedBy) throws InvalidSPDXAnalysisException {
        super.setSuppliedBy(suppliedBy);
        return this;
    }

    @Override
    public SpdxPackage setPrimaryPurpose(@Nullable SoftwarePurpose primaryPurpose) throws InvalidSPDXAnalysisException {
        super.setPrimaryPurpose(primaryPurpose);
        return this;
    }

    @Override
    public SpdxPackage setValidUntilTime(@Nullable String validUntilTime) throws InvalidSPDXAnalysisException {
        super.setValidUntilTime(validUntilTime);
        return this;
    }

    public Optional<String> getDownloadLocation() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_DOWNLOAD_LOCATION);
    }

    public SpdxPackage setDownloadLocation(@Nullable String downloadLocation) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_DOWNLOAD_LOCATION, downloadLocation);
        return this;
    }

    @Override
    public SpdxPackage setBuiltTime(@Nullable String builtTime) throws InvalidSPDXAnalysisException {
        super.setBuiltTime(builtTime);
        return this;
    }

    @Override
    public SpdxPackage setSummary(@Nullable String summary) throws InvalidSPDXAnalysisException {
        super.setSummary(summary);
        return this;
    }

    public Optional<String> getPackageVersion() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_PACKAGE_VERSION);
    }

    public SpdxPackage setPackageVersion(@Nullable String packageVersion) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_PACKAGE_VERSION, packageVersion);
        return this;
    }

    @Override
    public SpdxPackage setReleaseTime(@Nullable String releaseTime) throws InvalidSPDXAnalysisException {
        super.setReleaseTime(releaseTime);
        return this;
    }

    @Override
    public SpdxPackage setCopyrightText(@Nullable String copyrightText) throws InvalidSPDXAnalysisException {
        super.setCopyrightText(copyrightText);
        return this;
    }

    @Override
    public SpdxPackage setComment(@Nullable String comment) throws InvalidSPDXAnalysisException {
        super.setComment(comment);
        return this;
    }

    public Optional<String> getHomePage() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_HOME_PAGE);
    }

    public SpdxPackage setHomePage(@Nullable String homePage) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_HOME_PAGE, homePage);
        return this;
    }

    public Optional<String> getSourceInfo() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_SOURCE_INFO);
    }

    public SpdxPackage setSourceInfo(@Nullable String sourceInfo) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_SOURCE_INFO, sourceInfo);
        return this;
    }

    @Override
    public SpdxPackage setDescription(@Nullable String description) throws InvalidSPDXAnalysisException {
        super.setDescription(description);
        return this;
    }

    @Override
    public SpdxPackage setName(@Nullable String name) throws InvalidSPDXAnalysisException {
        super.setName(name);
        return this;
    }

    public Optional<String> getPackageUrl() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue(SpdxConstantsV3.PROP_PACKAGE_URL);
    }

    public SpdxPackage setPackageUrl(@Nullable String packageUrl) throws InvalidSPDXAnalysisException {
        this.setPropertyValue(SpdxConstantsV3.PROP_PACKAGE_URL, packageUrl);
        return this;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public List<String> _verify(Set<String> verifiedIds, String specVersionForVerify, List<IndividualUriValue> profiles) {
        Optional<String> e2;
        ArrayList<String> retval = new ArrayList<String>();
        retval.addAll(super._verify(verifiedIds, specVersionForVerify, profiles));
        try {
            Optional<String> optional = this.getDownloadLocation();
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting downloadLocation for SpdxPackage: " + e2.getMessage());
        }
        try {
            e2 = this.getPackageVersion();
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting packageVersion for SpdxPackage: " + e3.getMessage());
        }
        try {
            e2 = this.getHomePage();
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting homePage for SpdxPackage: " + e4.getMessage());
        }
        try {
            e2 = this.getSourceInfo();
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting sourceInfo for SpdxPackage: " + e5.getMessage());
        }
        try {
            e2 = this.getPackageUrl();
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting packageUrl for SpdxPackage: " + e6.getMessage());
        }
        return retval;
    }

    public static class SpdxPackageBuilder
    extends SoftwareArtifact.SoftwareArtifactBuilder {
        protected String downloadLocation = null;
        protected String packageVersion = null;
        protected String homePage = null;
        protected String sourceInfo = null;
        protected String packageUrl = null;

        public SpdxPackageBuilder(ModelObjectV3 from) throws InvalidSPDXAnalysisException {
            this(from, from.getModelStore().getNextId(IModelStore.IdType.Anonymous));
        }

        public SpdxPackageBuilder(ModelObjectV3 from, String objectUri) throws InvalidSPDXAnalysisException {
            this(from.getModelStore(), objectUri, from.getCopyManager());
            this.setStrict(from.isStrict());
            this.setIdPrefix(from.getIdPrefix());
            if (from instanceof Element) {
                this.setCreationInfo(((Element)from).getCreationInfo());
            } else if (from instanceof CreationInfo) {
                this.setCreationInfo((CreationInfo)from);
            }
        }

        public SpdxPackageBuilder(IModelStore modelStore, String objectUri, @Nullable IModelCopyManager copyManager) {
            super(modelStore, objectUri, copyManager);
        }

        @Override
        public SpdxPackageBuilder addContentIdentifier(ContentIdentifier contentIdentifier) {
            if (Objects.nonNull((Object)contentIdentifier)) {
                this.contentIdentifiers.add(contentIdentifier);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllContentIdentifier(Collection<ContentIdentifier> contentIdentifierCollection) {
            if (Objects.nonNull(contentIdentifierCollection)) {
                this.contentIdentifiers.addAll(contentIdentifierCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addVerifiedUsing(IntegrityMethod verifiedUsing) {
            if (Objects.nonNull((Object)verifiedUsing)) {
                this.verifiedUsings.add(verifiedUsing);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllVerifiedUsing(Collection<IntegrityMethod> verifiedUsingCollection) {
            if (Objects.nonNull(verifiedUsingCollection)) {
                this.verifiedUsings.addAll(verifiedUsingCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addExternalRef(ExternalRef externalRef) {
            if (Objects.nonNull((Object)externalRef)) {
                this.externalRefs.add(externalRef);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllExternalRef(Collection<ExternalRef> externalRefCollection) {
            if (Objects.nonNull(externalRefCollection)) {
                this.externalRefs.addAll(externalRefCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addExternalIdentifier(ExternalIdentifier externalIdentifier) {
            if (Objects.nonNull((Object)externalIdentifier)) {
                this.externalIdentifiers.add(externalIdentifier);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllExternalIdentifier(Collection<ExternalIdentifier> externalIdentifierCollection) {
            if (Objects.nonNull(externalIdentifierCollection)) {
                this.externalIdentifiers.addAll(externalIdentifierCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addExtension(Extension extension) {
            if (Objects.nonNull((Object)extension)) {
                this.extensions.add(extension);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllExtension(Collection<Extension> extensionCollection) {
            if (Objects.nonNull(extensionCollection)) {
                this.extensions.addAll(extensionCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addOriginatedBy(Agent originatedBy) {
            if (Objects.nonNull((Object)originatedBy)) {
                this.originatedBys.add(originatedBy);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllOriginatedBy(Collection<Agent> originatedByCollection) {
            if (Objects.nonNull(originatedByCollection)) {
                this.originatedBys.addAll(originatedByCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addSupportLevel(SupportType supportLevel) {
            if (Objects.nonNull((Object)supportLevel)) {
                this.supportLevels.add(supportLevel);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllSupportLevel(Collection<SupportType> supportLevelCollection) {
            if (Objects.nonNull(supportLevelCollection)) {
                this.supportLevels.addAll(supportLevelCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAdditionalPurpose(SoftwarePurpose additionalPurpose) {
            if (Objects.nonNull((Object)additionalPurpose)) {
                this.additionalPurposes.add(additionalPurpose);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllAdditionalPurpose(Collection<SoftwarePurpose> additionalPurposeCollection) {
            if (Objects.nonNull(additionalPurposeCollection)) {
                this.additionalPurposes.addAll(additionalPurposeCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAttributionText(String attributionText) {
            if (Objects.nonNull(attributionText)) {
                this.attributionTexts.add(attributionText);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllAttributionText(Collection<String> attributionTextCollection) {
            if (Objects.nonNull(attributionTextCollection)) {
                this.attributionTexts.addAll(attributionTextCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addStandardName(String standardName) {
            if (Objects.nonNull(standardName)) {
                this.standardNames.add(standardName);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder addAllStandardName(Collection<String> standardNameCollection) {
            if (Objects.nonNull(standardNameCollection)) {
                this.standardNames.addAll(standardNameCollection);
            }
            return this;
        }

        @Override
        public SpdxPackageBuilder setCreationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        @Override
        public SpdxPackageBuilder setSuppliedBy(Agent suppliedBy) {
            this.suppliedBy = suppliedBy;
            return this;
        }

        @Override
        public SpdxPackageBuilder setPrimaryPurpose(SoftwarePurpose primaryPurpose) {
            this.primaryPurpose = primaryPurpose;
            return this;
        }

        @Override
        public SpdxPackageBuilder setValidUntilTime(String validUntilTime) {
            this.validUntilTime = validUntilTime;
            return this;
        }

        public SpdxPackageBuilder setDownloadLocation(String downloadLocation) {
            this.downloadLocation = downloadLocation;
            return this;
        }

        @Override
        public SpdxPackageBuilder setBuiltTime(String builtTime) {
            this.builtTime = builtTime;
            return this;
        }

        @Override
        public SpdxPackageBuilder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public SpdxPackageBuilder setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        @Override
        public SpdxPackageBuilder setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
            return this;
        }

        @Override
        public SpdxPackageBuilder setCopyrightText(String copyrightText) {
            this.copyrightText = copyrightText;
            return this;
        }

        @Override
        public SpdxPackageBuilder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public SpdxPackageBuilder setHomePage(String homePage) {
            this.homePage = homePage;
            return this;
        }

        public SpdxPackageBuilder setSourceInfo(String sourceInfo) {
            this.sourceInfo = sourceInfo;
            return this;
        }

        @Override
        public SpdxPackageBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SpdxPackageBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public SpdxPackageBuilder setPackageUrl(String packageUrl) {
            this.packageUrl = packageUrl;
            return this;
        }

        @Override
        public SpdxPackage build() throws InvalidSPDXAnalysisException {
            IModelStore.IModelStoreLock lock = this.getModelStore().enterCriticalSection(false);
            try {
                SpdxPackage spdxPackage = new SpdxPackage(this);
                return spdxPackage;
            }
            finally {
                this.getModelStore().leaveCriticalSection(lock);
            }
        }
    }
}

