/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.maven.SnippetInfo;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxSourceFileParser;
import org.spdx.maven.SpdxSourceParserException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ConjunctiveLicenseSet;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

public class SpdxFileCollector {
    static Logger logger = LoggerFactory.getLogger(SpdxFileCollector.class);
    static Set<String> SOURCE_EXTENSIONS = new HashSet<String>();
    static Set<String> BINARY_EXTENSIONS = new HashSet<String>();
    static Set<String> ARCHIVE_EXTENSIONS = new HashSet<String>();
    static final String SPDX_FILE_TYPE_CONSTANTS_PROP_PATH = "resources/SpdxFileTypeConstants.prop";
    static final String SPDX_PROP_FILETYPE_SOURCE = "SpdxSourceExtensions";
    static final String SPDX_PROP_FILETYPE_BINARY = "SpdxBinaryExtensions";
    static final String SPDX_PROP_FILETYPE_ARCHIVE = "SpdxArchiveExtensions";
    static final Map<Checksum.ChecksumAlgorithm, String> checksumAlgorithms;
    Set<AnyLicenseInfo> licensesFromFiles = new HashSet<AnyLicenseInfo>();
    Map<String, SpdxFile> spdxFiles = new HashMap<String, SpdxFile>();
    List<SpdxSnippet> spdxSnippets = new ArrayList<SpdxSnippet>();
    FileSetManager fileSetManager = new FileSetManager();
    private Log log;

    public SpdxFileCollector(Log log) {
        this.log = log;
    }

    private static void loadFileExtensionConstants() {
        Properties prop = new Properties();
        try (InputStream is = SpdxFileCollector.class.getClassLoader().getResourceAsStream(SPDX_FILE_TYPE_CONSTANTS_PROP_PATH);){
            if (is == null) {
                logger.error("Unable to load properties file resources/SpdxFileTypeConstants.prop");
            }
            prop.load(is);
            String sourceExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_SOURCE);
            SpdxFileCollector.loadSetUpcase(SOURCE_EXTENSIONS, sourceExtensionStr);
            String binaryExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_BINARY);
            SpdxFileCollector.loadSetUpcase(BINARY_EXTENSIONS, binaryExtensionStr);
            String archiveExtensionStr = prop.getProperty(SPDX_PROP_FILETYPE_ARCHIVE);
            SpdxFileCollector.loadSetUpcase(ARCHIVE_EXTENSIONS, archiveExtensionStr);
        }
        catch (IOException e) {
            logger.warn("WARNING: Error reading SpdxFileTypeConstants properties file.  All file types will be mapped to Other.");
        }
    }

    private static void loadSetUpcase(Set<String> set, String str) {
        String[] values;
        for (String value : values = str.split(",")) {
            set.add(value.toUpperCase().trim());
        }
    }

    public void collectFiles(FileSet[] fileSets, String baseDir, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxPackage projectPackage, Relationship.RelationshipType relationshipType, SpdxDocumentContainer container, Set<Checksum.ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        for (FileSet fileSet : fileSets) {
            String[] includedFiles;
            for (String includedFile : includedFiles = this.fileSetManager.getIncludedFiles(fileSet)) {
                String filePath = fileSet.getDirectory() + File.separator + includedFile;
                File file = new File(filePath);
                String relativeFilePath = file.getAbsolutePath().substring(baseDir.length() + 1).replace('\\', '/');
                SpdxDefaultFileInformation fileInfo = this.findDefaultFileInformation(relativeFilePath, pathSpecificInformation);
                if (fileInfo == null) {
                    fileInfo = defaultFileInformation;
                }
                String outputFileName = fileSet.getOutputDirectory() != null ? fileSet.getOutputDirectory() + File.separator + includedFile : file.getAbsolutePath().substring(baseDir.length() + 1);
                this.collectFile(file, outputFileName, fileInfo, relationshipType, projectPackage, container, algorithms);
            }
        }
    }

    private SpdxDefaultFileInformation findDefaultFileInformation(String filePath, Map<String, SpdxDefaultFileInformation> pathSpecificInformation) {
        SpdxDefaultFileInformation retval;
        if (this.log != null) {
            this.log.debug((CharSequence)("Checking for file path " + filePath));
        }
        if ((retval = pathSpecificInformation.get(filePath)) != null) {
            if (this.log != null) {
                this.log.debug((CharSequence)"Found filepath");
            }
            return retval;
        }
        String parentPath = filePath;
        int parentPathIndex = 0;
        do {
            if ((parentPathIndex = parentPath.lastIndexOf("/")) <= 0) continue;
            parentPath = parentPath.substring(0, parentPathIndex);
            retval = pathSpecificInformation.get(parentPath);
        } while (retval == null && parentPathIndex > 0);
        if (retval != null) {
            this.debug("Found directory containing file path for path specific information.  File path: " + parentPath);
        }
        return retval;
    }

    private void debug(String msg) {
        if (this.getLog() != null) {
            this.getLog().debug((CharSequence)msg);
        } else {
            logger.debug(msg);
        }
    }

    private void collectFile(File file, String outputFileName, SpdxDefaultFileInformation fileInfo, Relationship.RelationshipType relationshipType, SpdxPackage projectPackage, SpdxDocumentContainer container, Set<Checksum.ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        if (this.spdxFiles.containsKey(file.getPath())) {
            return;
        }
        SpdxFile spdxFile = this.convertToSpdxFile(file, outputFileName, fileInfo, algorithms);
        Relationship relationship = new Relationship((SpdxElement)projectPackage, relationshipType, "");
        try {
            spdxFile.addRelationship(relationship);
        }
        catch (InvalidSPDXAnalysisException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Spdx exception creating file relationship: " + e.getMessage()), (Throwable)e);
            }
            throw new SpdxCollectionException("Error creating SPDX file relationship: " + e.getMessage());
        }
        if (fileInfo.getSnippets() != null) {
            for (SnippetInfo snippet : fileInfo.getSnippets()) {
                SpdxSnippet spdxSnippet;
                try {
                    spdxSnippet = this.convertToSpdxSnippet(snippet, spdxFile, container);
                }
                catch (InvalidLicenseStringException e) {
                    logger.error("Invalid license string creating snippet", (Throwable)e);
                    throw new SpdxCollectionException("Error processing SPDX snippet information.  Invalid license string specified in snippet.", e);
                }
                catch (SpdxBuilderException e) {
                    logger.error("Error creating SPDX snippet", (Throwable)e);
                    throw new SpdxCollectionException("Error creating SPDX snippet information.", e);
                }
                this.spdxSnippets.add(spdxSnippet);
            }
        }
        this.spdxFiles.put(file.getPath(), spdxFile);
        AnyLicenseInfo[] licenseInfoFromFiles = spdxFile.getLicenseInfoFromFiles();
        this.licensesFromFiles.addAll(Arrays.asList(licenseInfoFromFiles));
    }

    private SpdxSnippet convertToSpdxSnippet(SnippetInfo snippet, SpdxFile spdxFile, SpdxDocumentContainer container) throws InvalidLicenseStringException, SpdxBuilderException {
        SpdxSnippet retval = new SpdxSnippet(snippet.getName(), snippet.getComment(), new Annotation[0], new Relationship[0], snippet.getLicenseConcluded(container), snippet.getLicenseInfoInSnippet(container), snippet.getCopyrightText(), snippet.getLicensComment(), spdxFile, snippet.getByteRange((SpdxElement)spdxFile), snippet.getLineRange((SpdxElement)spdxFile));
        return retval;
    }

    private SpdxFile convertToSpdxFile(File file, String outputFileName, SpdxDefaultFileInformation defaultFileInformation, Set<Checksum.ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        String relativePath = this.convertFilePathToSpdxFileName(outputFileName);
        SpdxFile.FileType[] fileTypes = new SpdxFile.FileType[]{SpdxFileCollector.extensionToFileType(this.getExtension(file))};
        Set<Checksum> checksums = SpdxFileCollector.generateChecksum(file, algorithms);
        AnyLicenseInfo concludedLicense = null;
        Object license = null;
        String licenseComment = defaultFileInformation.getLicenseComment();
        if (this.isSourceFile(fileTypes) && file.length() < 300000L) {
            List<AnyLicenseInfo> fileSpdxLicenses;
            block12: {
                fileSpdxLicenses = null;
                try {
                    fileSpdxLicenses = SpdxSourceFileParser.parseFileForSpdxLicenses(file);
                }
                catch (SpdxSourceParserException ex) {
                    if (this.log == null) break block12;
                    this.log.error((CharSequence)"Error parsing for SPDX license ID's", (Throwable)ex);
                }
            }
            if (fileSpdxLicenses != null && fileSpdxLicenses.size() > 0) {
                license = fileSpdxLicenses.size() == 1 ? fileSpdxLicenses.get(0) : new ConjunctiveLicenseSet(fileSpdxLicenses.toArray(new AnyLicenseInfo[0]));
                if (licenseComment == null) {
                    licenseComment = "";
                } else if (licenseComment.length() > 0) {
                    licenseComment = licenseComment.concat(";  ");
                }
                licenseComment = licenseComment.concat("This file contains SPDX-License-Identifiers for ");
                licenseComment = licenseComment.concat(license.toString());
            }
        }
        if (license == null) {
            license = defaultFileInformation.getDeclaredLicense();
            concludedLicense = defaultFileInformation.getConcludedLicense();
        } else {
            concludedLicense = license;
        }
        String copyright = defaultFileInformation.getCopyright();
        String notice = defaultFileInformation.getNotice();
        String comment = defaultFileInformation.getComment();
        String[] contributors = defaultFileInformation.getContributors();
        DoapProject[] artifactOf = new DoapProject[]{};
        SpdxFile retval = null;
        try {
            retval = new SpdxFile(relativePath, comment, new Annotation[0], new Relationship[0], concludedLicense, new AnyLicenseInfo[]{license}, copyright, licenseComment, fileTypes, checksums.toArray(new Checksum[0]), new String[0], "", artifactOf);
            retval.setFileContributors(contributors);
            retval.setNoticeText(notice);
        }
        catch (InvalidSPDXAnalysisException e) {
            if (this.log != null) {
                this.log.error((CharSequence)("Spdx exception creating file: " + e.getMessage()), (Throwable)e);
            }
            throw new SpdxCollectionException("Error creating SPDX file: " + e.getMessage());
        }
        return retval;
    }

    protected boolean isSourceFile(SpdxFile.FileType[] fileTypes) {
        for (SpdxFile.FileType ft : fileTypes) {
            if (ft != SpdxFile.FileType.fileType_source) continue;
            return true;
        }
        return false;
    }

    public String convertFilePathToSpdxFileName(String filePath) {
        String result = filePath.replace('\\', '/');
        if (!result.startsWith("./")) {
            result = "./" + result;
        }
        return result;
    }

    public String getExtension(File file) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 1) {
            return "";
        }
        return fileName.substring(lastDot + 1);
    }

    private static SpdxFile.FileType extensionToFileType(String fileExtension) {
        if (fileExtension == null) {
            return SpdxFile.FileType.fileType_other;
        }
        String upperExtension = fileExtension.toUpperCase();
        if (SOURCE_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_source;
        }
        if (BINARY_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_binary;
        }
        if (ARCHIVE_EXTENSIONS.contains(upperExtension)) {
            return SpdxFile.FileType.fileType_archive;
        }
        return SpdxFile.FileType.fileType_other;
    }

    public SpdxFile[] getFiles() {
        return this.spdxFiles.values().toArray(new SpdxFile[0]);
    }

    public List<SpdxSnippet> getSnippets() {
        return this.spdxSnippets;
    }

    public AnyLicenseInfo[] getLicenseInfoFromFiles() {
        return this.licensesFromFiles.toArray(new AnyLicenseInfo[0]);
    }

    public SpdxPackageVerificationCode getVerificationCode(String spdxFilePath) throws NoSuchAlgorithmException {
        ArrayList<String> excludedFileNamesFromVerificationCode = new ArrayList<String>();
        if (spdxFilePath != null && this.spdxFiles.containsKey(spdxFilePath)) {
            excludedFileNamesFromVerificationCode.add(this.spdxFiles.get(spdxFilePath).getName());
        }
        SpdxPackageVerificationCode verificationCode = this.calculatePackageVerificationCode(this.spdxFiles.values(), excludedFileNamesFromVerificationCode);
        return verificationCode;
    }

    private SpdxPackageVerificationCode calculatePackageVerificationCode(Collection<SpdxFile> spdxFiles, List<String> excludedFileNamesFromVerificationCode) throws NoSuchAlgorithmException {
        ArrayList<String> fileChecksums = new ArrayList<String>();
        for (SpdxFile spdxFile : spdxFiles) {
            if (!this.includeInVerificationCode(spdxFile.getName(), excludedFileNamesFromVerificationCode)) continue;
            fileChecksums.add(spdxFile.getSha1());
        }
        Collections.sort(fileChecksums);
        MessageDigest verificationCodeDigest = MessageDigest.getInstance("SHA-1");
        for (String fileChecksum : fileChecksums) {
            byte[] hashInput = fileChecksum.getBytes(StandardCharsets.UTF_8);
            verificationCodeDigest.update(hashInput);
        }
        String string = SpdxFileCollector.convertChecksumToString(verificationCodeDigest.digest());
        return new SpdxPackageVerificationCode(string, excludedFileNamesFromVerificationCode.toArray(new String[0]));
    }

    private boolean includeInVerificationCode(String name, List<String> excludedFileNamesFromVerificationCode) {
        for (String s : excludedFileNamesFromVerificationCode) {
            if (!s.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static String convertChecksumToString(byte[] digestBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte digestByte : digestBytes) {
            String hex = Integer.toHexString(0xFF & digestByte);
            if (hex.length() < 2) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String generateSha1(File file) throws SpdxCollectionException {
        HashSet<Checksum.ChecksumAlgorithm> sha1 = new HashSet<Checksum.ChecksumAlgorithm>();
        sha1.add(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1);
        Checksum sha1Checksum = SpdxFileCollector.generateChecksum(file, sha1).iterator().next();
        return sha1Checksum.getValue();
    }

    public static Set<Checksum> generateChecksum(File file, Set<Checksum.ChecksumAlgorithm> algorithms) throws SpdxCollectionException {
        byte[] buffer;
        HashSet<Checksum> checksums = new HashSet<Checksum>();
        try {
            buffer = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            throw new SpdxCollectionException("IO error while calculating checksums.", e);
        }
        for (Checksum.ChecksumAlgorithm algorithm : algorithms) {
            MessageDigest digest;
            String checksumAlgorithm = checksumAlgorithms.get(algorithm);
            try {
                digest = MessageDigest.getInstance(checksumAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SpdxCollectionException(e);
            }
            digest.update(buffer);
            String checksum = SpdxFileCollector.convertChecksumToString(digest.digest());
            checksums.add(new Checksum(algorithm, checksum));
        }
        return checksums;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    static {
        SpdxFileCollector.loadFileExtensionConstants();
        checksumAlgorithms = new HashMap<Checksum.ChecksumAlgorithm, String>();
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, "SHA-1");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha224, "SHA-224");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha256, "SHA-256");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha384, "SHA-384");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha512, "SHA-512");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_md2, "MD2");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_md4, "MD4");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_md5, "MD5");
        checksumAlgorithms.put(Checksum.ChecksumAlgorithm.checksumAlgorithm_md6, "MD6");
    }
}

