/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;

public class SpdxProjectInformation {
    private String[] creators = new String[0];
    private String creatorComment = "";
    private AnyLicenseInfo concludedLicense = new SpdxNoAssertionLicense();
    private AnyLicenseInfo declaredLicense = new SpdxNoAssertionLicense();
    private String description;
    private String downloadUrl;
    private String homePage;
    private String shortDescription;
    private String originator;
    private String supplier;
    private String packageArchiveFileName;
    private String versionInfo;
    private String licenseComment;
    private String name;
    private String sourceInfo;
    private String copyrightText;
    private String documentComment;
    private Annotation[] packageAnnotations;
    private Annotation[] documentAnnotations;
    private List<ExternalReference> externalRefs;
    private Set<Checksum> checksums;

    public String getDocumentComment() {
        return this.documentComment;
    }

    public void setDocumentComment(String documentComment) {
        this.documentComment = documentComment;
    }

    public Set<Checksum> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(Set<Checksum> checksums) {
        this.checksums = checksums;
    }

    public AnyLicenseInfo getConcludedLicense() {
        return this.concludedLicense;
    }

    public void setConcludedLicense(AnyLicenseInfo concludedLicense) {
        this.concludedLicense = concludedLicense;
    }

    public AnyLicenseInfo getDeclaredLicense() {
        return this.declaredLicense;
    }

    public void setDeclaredLicense(AnyLicenseInfo declaredLicense) {
        this.declaredLicense = declaredLicense;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getPackageArchiveFileName() {
        return this.packageArchiveFileName;
    }

    public void setPackageArchiveFileName(String packageArchiveFileName) {
        this.packageArchiveFileName = packageArchiveFileName;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }

    public String getLicenseComment() {
        return this.licenseComment;
    }

    public void setLicenseComment(String licenseComment) {
        this.licenseComment = licenseComment;
    }

    public String[] getCreators() {
        return this.creators;
    }

    public void setCreators(String[] creators) {
        this.creators = creators;
    }

    public String getCreatorComment() {
        return this.creatorComment;
    }

    public void setCreatorComment(String creatorComment) {
        this.creatorComment = creatorComment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void logInfo(Log log) {
        String[] creators;
        log.debug((CharSequence)("SPDX Project Name: " + this.getName()));
        log.debug((CharSequence)("SPDX Document comment: " + this.getDocumentComment()));
        log.debug((CharSequence)("SPDX Creator comment: " + this.getCreatorComment()));
        log.debug((CharSequence)("SPDX Description: " + this.getDescription()));
        log.debug((CharSequence)("SPDX License comment: " + this.getLicenseComment()));
        log.debug((CharSequence)("SPDX Originator: " + this.getOriginator()));
        log.debug((CharSequence)("SPDX PackageArchiveFileName: " + this.getPackageArchiveFileName()));
        log.debug((CharSequence)("SPDX Short description: " + this.getShortDescription()));
        log.debug((CharSequence)("SPDX Supplier: " + this.getSupplier()));
        log.debug((CharSequence)("SPDX Source Info:  " + this.getSourceInfo()));
        log.debug((CharSequence)("SPDX Version info: " + this.getVersionInfo()));
        log.debug((CharSequence)("SPDX Concluded license: " + this.getConcludedLicense().toString()));
        log.debug((CharSequence)("SPDX Declared license: " + this.getDeclaredLicense().toString()));
        log.debug((CharSequence)("SPDX Download URL: " + this.getDownloadUrl()));
        log.debug((CharSequence)("SPDX Home page: " + this.getHomePage()));
        if (this.documentAnnotations != null && this.documentAnnotations.length > 0) {
            log.debug((CharSequence)"Document annotations: ");
            for (Annotation annotation : this.documentAnnotations) {
                annotation.logInfo(log);
            }
        }
        if (this.packageAnnotations != null && this.packageAnnotations.length > 0) {
            log.debug((CharSequence)"Package annotations: ");
            for (Annotation annotation : this.packageAnnotations) {
                annotation.logInfo(log);
            }
        }
        if ((creators = this.getCreators()) != null) {
            for (String creator : creators) {
                log.debug((CharSequence)("SPDX Creator: " + creator));
            }
        }
        if (this.externalRefs != null) {
            for (ExternalReference externalReference : this.externalRefs) {
                try {
                    ExternalRef externalRef = externalReference.getExternalRef();
                    StringBuilder externalRefString = new StringBuilder();
                    externalRefString.append(externalRef.getReferenceCategory().getTag());
                    externalRefString.append(' ');
                    try {
                        externalRefString.append(ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(externalRef.getReferenceType().getReferenceTypeUri()));
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        externalRefString.append("Invalid Reference Type");
                    }
                    externalRefString.append(' ');
                    externalRefString.append(externalRef.getReferenceLocator());
                    log.debug((CharSequence)("External Ref: " + externalRefString.toString()));
                }
                catch (MojoExecutionException e1) {
                    log.error((CharSequence)"Invalid external reference", (Throwable)e1);
                }
            }
        }
        if (this.checksums != null && this.checksums.size() > 0) {
            for (Checksum checksum : this.checksums) {
                String algorithm = SpdxFileCollector.checksumAlgorithms.get(checksum.getAlgorithm());
                log.debug((CharSequence)("SPDX " + algorithm + ": " + checksum.getValue()));
            }
        }
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInformation) {
        this.sourceInfo = sourceInformation;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setPackageAnnotations(Annotation[] packageAnnotations) {
        this.packageAnnotations = packageAnnotations;
    }

    public Annotation[] getPackageAnnotations() {
        return this.packageAnnotations;
    }

    public void setDocumentAnnotations(Annotation[] documentAnnotations) {
        this.documentAnnotations = documentAnnotations;
    }

    public Annotation[] getDocumentAnnotations() {
        return this.documentAnnotations;
    }

    public void setExternalRefs(List<ExternalReference> externalReferences) {
        this.externalRefs = externalReferences;
    }

    public List<ExternalReference> getExternalRefs() {
        return this.externalRefs;
    }
}

