/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxInvalidIdException;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalSpdxElement;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.MavenToSpdxLicenseMapper;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxDependencyInformation {
    private Log log;
    private List<Relationship> relationships = new ArrayList<Relationship>();
    private Map<String, ExternalDocumentRef> externalDocuments = new HashMap<String, ExternalDocumentRef>();
    private LicenseManager licenseManager;
    private SpdxDocument spdxDoc;

    public SpdxDependencyInformation(Log log, LicenseManager licenseManager, SpdxDocument spdxDoc) {
        this.log = log;
        this.licenseManager = licenseManager;
        this.spdxDoc = spdxDoc;
    }

    public void addMavenDependency(Artifact dependency) throws LicenseMapperException, InvalidSPDXAnalysisException {
        String scope = dependency.getScope();
        RelationshipType relType = this.scopeToRelationshipType(scope, dependency.isOptional());
        if (relType == RelationshipType.OTHER) {
            this.log.warn((CharSequence)("Could not determine the SPDX relationship type for dependency artifact ID " + dependency.getArtifactId() + " scope " + scope));
        }
        SpdxElement dependencyPackage = this.createSpdxPackage(dependency);
        this.relationships.add(this.spdxDoc.createRelationship(dependencyPackage, relType, "Relationship based on Maven POM file dependency information"));
    }

    private RelationshipType scopeToRelationshipType(String scope, boolean optional) {
        if (scope == null) {
            return RelationshipType.OTHER;
        }
        if (optional) {
            return RelationshipType.OPTIONAL_COMPONENT_OF;
        }
        if (scope.equals("compile") || scope.equals("runtime")) {
            return RelationshipType.DYNAMIC_LINK;
        }
        if (scope.equals("test")) {
            return RelationshipType.TEST_CASE_OF;
        }
        return RelationshipType.OTHER;
    }

    private SpdxElement createSpdxPackage(Artifact artifact) throws LicenseMapperException, InvalidSPDXAnalysisException {
        this.log.debug((CharSequence)("Creating SPDX package for artifact " + artifact.getArtifactId()));
        if (artifact.getFile() == null) {
            this.log.debug((CharSequence)"Artifact file is null");
        } else {
            this.log.debug((CharSequence)("Artifact file name = " + artifact.getFile().getName()));
        }
        File spdxFile = null;
        if (artifact.getFile() != null) {
            spdxFile = this.artifactFileToSpdxFile(artifact.getFile());
        }
        if (spdxFile != null && spdxFile.exists()) {
            this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Looking for SPDX file " + spdxFile.getAbsolutePath()));
            try {
                this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Dependency information collected from SPDX file " + spdxFile.getAbsolutePath()));
                SpdxDocument externalSpdxDoc = this.spdxDocumentFromFile(spdxFile.getPath());
                return this.createExternalSpdxPackageReference(externalSpdxDoc, spdxFile, SpdxConstants.EXTERNAL_DOC_REF_PRENUM + artifact.getArtifactId());
            }
            catch (IOException e) {
                this.log.warn((CharSequence)("IO error reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (SpdxInvalidIdException e) {
                this.log.warn((CharSequence)("Invalid SPDX ID exception reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.warn((CharSequence)("Invalid SPDX analysis exception reading SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (SpdxCollectionException e) {
                this.log.warn((CharSequence)("Unable to create file checksum for external SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("Unknown error processing SPDX document for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage() + ".  Using POM file information for creating SPDX package data."));
            }
        }
        File pomFile = null;
        if (artifact.getFile() != null) {
            pomFile = this.artifactFileToPomFile(artifact.getFile());
        }
        if (pomFile != null && pomFile.exists()) {
            this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Looking for POM file " + pomFile.getAbsolutePath()));
            try {
                this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Collecting information from POM file " + pomFile.getAbsolutePath()));
                return this.createSpdxPackage(pomFile);
            }
            catch (IOException e) {
                this.log.error((CharSequence)("IO Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (XmlPullParserException e) {
                this.log.error((CharSequence)("Parser Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (SpdxCollectionException e) {
                this.log.error((CharSequence)("SPDX File Collection Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error((CharSequence)("Verification Code Error reading POM file for dependency artifact ID " + artifact.getArtifactId() + ":" + e.getMessage()));
            }
            this.log.warn((CharSequence)("No POM file found for dependency artifact ID " + artifact.getArtifactId() + ".  A minimal SPDX package will be created."));
        }
        this.log.debug((CharSequence)("Dependency " + artifact.getArtifactId() + "Using only artifact information to create dependent package"));
        SpdxPackage pkg = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), artifact.getArtifactId(), (AnyLicenseInfo)new SpdxNoAssertionLicense(), "NOASSERTION", (AnyLicenseInfo)new SpdxNoAssertionLicense()).setComment("This package was created for a Maven dependency.  No SPDX or license information could be found in the Maven POM file.").setVersionInfo(artifact.getBaseVersion()).setFilesAnalyzed(false).build();
        return pkg;
    }

    private SpdxDocument spdxDocumentFromFile(String path) throws FileNotFoundException, IOException, InvalidSPDXAnalysisException {
        Object modelStore = path.toLowerCase().endsWith("json") ? new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT) : new RdfStore();
        try {
            SpdxDocument spdxDocument;
            try (FileInputStream inputStream = new FileInputStream(path);){
                String documentUri = modelStore.deSerialize((InputStream)inputStream, false);
                spdxDocument = new SpdxDocument((IModelStore)modelStore, documentUri, this.spdxDoc.getCopyManager(), false);
            }
            return spdxDocument;
        }
        finally {
            if (modelStore != null) {
                try {
                    modelStore.close();
                }
                catch (Exception e) {
                    this.log.error((CharSequence)"Error closing SPDX model store", (Throwable)e);
                }
            }
        }
    }

    private SpdxElement createExternalSpdxPackageReference(SpdxDocument externalSpdxDoc, File spdxFile, String externalRefId) throws SpdxCollectionException, InvalidSPDXAnalysisException {
        SpdxItem[] describedItems;
        String fixedExternalRefId = this.fixExternalRefId(externalRefId);
        ExternalDocumentRef externalRef = this.externalDocuments.get(fixedExternalRefId);
        if (externalRef == null) {
            this.log.debug((CharSequence)("Creating external document ref " + fixedExternalRefId));
            String sha1 = SpdxFileCollector.generateSha1(spdxFile, this.spdxDoc);
            Checksum cksum = externalSpdxDoc.createChecksum(ChecksumAlgorithm.SHA1, sha1);
            externalRef = this.spdxDoc.createExternalDocumentRef(fixedExternalRefId, externalSpdxDoc.getDocumentUri(), cksum);
            this.spdxDoc.getExternalDocumentRefs().add(externalRef);
            this.externalDocuments.put(fixedExternalRefId, externalRef);
            this.log.debug((CharSequence)("Created external document ref " + fixedExternalRefId));
        }
        if ((describedItems = externalSpdxDoc.getDocumentDescribes().toArray(new SpdxItem[externalSpdxDoc.getDocumentDescribes().size()])) == null || describedItems.length == 0) {
            throw new InvalidSPDXAnalysisException("SPDX document does not contain any described items.");
        }
        SpdxItem itemDescribed = describedItems[0];
        if (describedItems.length > 1) {
            for (SpdxItem item : describedItems) {
                if (!(item instanceof SpdxPackage)) continue;
                itemDescribed = item;
                break;
            }
        }
        return new ExternalSpdxElement(this.spdxDoc.getModelStore(), this.spdxDoc.getDocumentUri(), fixedExternalRefId + ":" + itemDescribed.getId(), this.spdxDoc.getCopyManager(), true);
    }

    private String fixExternalRefId(String externalRefId) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < externalRefId.length(); ++i) {
            if (this.validExternalRefIdChar(externalRefId.charAt(i))) {
                sb.append(externalRefId.charAt(i));
                continue;
            }
            sb.append("-");
        }
        return sb.toString();
    }

    private boolean validExternalRefIdChar(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-';
    }

    private SpdxPackage createSpdxPackage(File pomFile) throws IOException, XmlPullParserException, SpdxCollectionException, NoSuchAlgorithmException, LicenseMapperException, InvalidSPDXAnalysisException {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read((Reader)ReaderFactory.newXmlReader((File)pomFile));
        SpdxDefaultFileInformation fileInfo = new SpdxDefaultFileInformation();
        String packageName = model.getName();
        if (packageName == null || packageName.isEmpty()) {
            packageName = model.getArtifactId();
        }
        List contributors = model.getContributors();
        ArrayList<String> fileContributorList = new ArrayList<String>();
        if (contributors != null) {
            for (Contributor contributor : contributors) {
                fileContributorList.add(contributor.getName());
            }
        }
        String copyright = "UNSPECIFIED";
        String notice = "UNSPECIFIED";
        String downloadLocation = "NOASSERTION";
        AnyLicenseInfo declaredLicense = this.mavenLicensesToSpdxLicense(model.getLicenses());
        fileInfo.setComment("");
        fileInfo.setConcludedLicense((AnyLicenseInfo)new SpdxNoAssertionLicense());
        fileInfo.setContributors(fileContributorList.toArray(new String[0]));
        fileInfo.setCopyright(copyright);
        fileInfo.setDeclaredLicense(declaredLicense);
        fileInfo.setLicenseComment("");
        fileInfo.setNotice(notice);
        SpdxPackage retval = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), packageName, (AnyLicenseInfo)new SpdxNoAssertionLicense(), copyright, declaredLicense).setDownloadLocation(downloadLocation).setFilesAnalyzed(false).build();
        if (model.getVersion() != null) {
            retval.setVersionInfo(model.getVersion());
        }
        if (model.getDescription() != null) {
            retval.setDescription(model.getDescription());
            retval.setSummary(model.getDescription());
        }
        if (model.getOrganization() != null) {
            retval.setOriginator("Organization:" + model.getOrganization().getName());
        }
        if (model.getUrl() != null) {
            try {
                retval.setHomepage(model.getUrl());
            }
            catch (InvalidSPDXAnalysisException e) {
                this.log.warn((CharSequence)("Invalid homepage for dependency " + model.getArtifactId() + ": " + model.getUrl()));
            }
        }
        return retval;
    }

    private AnyLicenseInfo mavenLicensesToSpdxLicense(List<License> mavenLicenses) throws LicenseMapperException, InvalidSPDXAnalysisException {
        try {
            return this.licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
        }
        catch (LicenseManagerException ex) {
            return MavenToSpdxLicenseMapper.getInstance(this.log).mavenLicenseListToSpdxLicense(mavenLicenses, this.spdxDoc);
        }
    }

    private FileSet[] getIncludedDirectoriesFromModel(Model model) {
        List resourceList;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        String sourcePath = model.getBuild().getSourceDirectory();
        if (sourcePath != null && !sourcePath.isEmpty()) {
            FileSet srcFileSet = new FileSet();
            File sourceDir = new File(sourcePath);
            srcFileSet.setDirectory(sourceDir.getAbsolutePath());
            srcFileSet.addInclude("**/*");
            result.add(srcFileSet);
        }
        if ((resourceList = model.getBuild().getResources()) != null) {
            for (Resource resource : resourceList) {
                FileSet resourceFileSet = new FileSet();
                File resourceDir = new File(resource.getDirectory());
                resourceFileSet.setDirectory(resourceDir.getAbsolutePath());
                resourceFileSet.setExcludes(resource.getExcludes());
                resourceFileSet.setIncludes(resource.getIncludes());
                result.add(resourceFileSet);
            }
        }
        return result.toArray(new FileSet[0]);
    }

    private File artifactFileToSpdxFile(File file) {
        File retval = this.getFileWithDifferentType(file, "spdx.rdf.xml");
        if (retval == null || !retval.exists()) {
            retval = this.getFileWithDifferentType(file, "spdx.json");
        }
        if (retval == null || !retval.exists()) {
            retval = this.getFileWithDifferentType(file, "spdx");
        }
        return retval;
    }

    private File getFileWithDifferentType(File file, String type) {
        String filePath = file.getAbsolutePath();
        int indexOfDot = filePath.lastIndexOf(46);
        if (indexOfDot > 0) {
            filePath = filePath.substring(0, indexOfDot + 1);
        }
        filePath = filePath + type;
        File retval = new File(filePath);
        return retval;
    }

    private File artifactFileToPomFile(File file) {
        return this.getFileWithDifferentType(file, "pom");
    }

    public List<Relationship> getPackageRelationships() {
        return this.relationships;
    }

    public Collection<ExternalDocumentRef> getDocumentExternalReferences() {
        return this.externalDocuments.values();
    }
}

