/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxDependencyInformation;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.maven.SpdxProjectInformation;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class SpdxDocumentBuilder {
    private static final String UNSPECIFIED = "UNSPECIFIED";
    public static final String NULL_SHA1 = "cf23df2207d99a74fbe169e3eba035e633b65d94";
    DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Log log;
    private SpdxDocument spdxDoc;
    private SpdxPackage projectPackage;
    private LicenseManager licenseManager;
    private File spdxFile;
    private ISerializableModelStore modelStore;
    private ModelCopyManager copyManager;

    public SpdxDocumentBuilder(Log log, File spdxFile, URL spdxDocumentNamespace, boolean useStdLicenseSourceUrls, String outputFormat) throws SpdxBuilderException, LicenseMapperException {
        this.log = log;
        this.spdxFile = spdxFile;
        if (spdxDocumentNamespace == null) {
            this.getLog().error((CharSequence)"spdxDocumentNamespace must be specified as a configuration parameter");
            throw new SpdxBuilderException("Missing spdxDocumentNamespace");
        }
        if (!spdxFile.exists()) {
            File parentDir = spdxFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                this.getLog().error((CharSequence)("Unable to create directory containing the SPDX file: " + parentDir.getPath()));
                throw new SpdxBuilderException("Unable to create directories for SPDX file");
            }
            try {
                if (!spdxFile.createNewFile()) {
                    this.getLog().error((CharSequence)("Unable to create the SPDX file: " + spdxFile.getPath()));
                    throw new SpdxBuilderException("Unable to create the SPDX file");
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("IO error creating the SPDX file " + spdxFile.getPath() + ":" + e.getMessage()), (Throwable)e);
                throw new SpdxBuilderException("IO error creating the SPDX file");
            }
        }
        if (!spdxFile.canWrite()) {
            this.getLog().error((CharSequence)("Can not write to SPDX file " + spdxFile.getPath()));
            throw new SpdxBuilderException("Unable to write to SPDX file - check permissions: " + spdxFile.getPath());
        }
        try {
            this.modelStore = outputFormat.equals("RDF/XML") ? new RdfStore() : new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY);
            this.copyManager = new ModelCopyManager();
            this.spdxDoc = SpdxModelFactory.createSpdxDocument((IModelStore)this.modelStore, (String)spdxDocumentNamespace.toString(), (ModelCopyManager)this.copyManager);
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error creating SPDX document", (Throwable)e);
            throw new SpdxBuilderException("Error creating SPDX document: " + e.getMessage());
        }
        this.licenseManager = new LicenseManager(this.spdxDoc, this.getLog(), useStdLicenseSourceUrls);
    }

    public void addNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) throws SpdxBuilderException {
        if (nonStandardLicenses != null) {
            for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
                try {
                    this.licenseManager.addExtractedLicense(nonStandardLicense);
                }
                catch (LicenseManagerException e) {
                    this.getLog().error((CharSequence)("Error adding license " + e.getMessage()), (Throwable)e);
                    throw new SpdxBuilderException("Error adding non standard license: " + e.getMessage(), e);
                }
            }
        }
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public SpdxDocument getSpdxDoc() {
        return this.spdxDoc;
    }

    public void buildDocumentFromFiles(FileSet[] includedSourceDirectories, FileSet[] includedTestDirectories, FileSet[] includedResourceDirectories, String baseDir, SpdxProjectInformation projectInformation, SpdxDefaultFileInformation defaultFileInformation, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, SpdxDependencyInformation dependencyInformation, Set<ChecksumAlgorithm> algorithms, String spdxDocumentNamespace) throws SpdxBuilderException {
        FileOutputStream spdxOut = null;
        try {
            this.log.debug((CharSequence)"Starting buid document from files");
            spdxOut = new FileOutputStream(this.spdxFile);
            this.fillSpdxDocumentInformation(projectInformation);
            this.collectSpdxFileInformation(includedSourceDirectories, includedTestDirectories, includedResourceDirectories, baseDir, defaultFileInformation, this.spdxFile.getPath().replace("\\", "/"), pathSpecificInformation, algorithms);
            this.addDependencyInformation(dependencyInformation);
            this.modelStore.serialize(spdxDocumentNamespace, (OutputStream)spdxOut);
            this.log.debug((CharSequence)"Completed build document from files");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)"Error saving SPDX data to file", (Throwable)e);
            throw new SpdxBuilderException("Error saving SPDX data to file: " + e.getMessage());
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error collecting SPDX file data", (Throwable)e);
            throw new SpdxBuilderException("Error collecting SPDX file data: " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"I/O Error saving SPDX data to file", (Throwable)e);
            throw new SpdxBuilderException("I/O Error saving SPDX data to file: " + e.getMessage());
        }
        finally {
            if (spdxOut != null) {
                try {
                    spdxOut.close();
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Error closing SPDX output file", (Throwable)e);
                }
            }
        }
    }

    private void addDependencyInformation(SpdxDependencyInformation dependencyInformation) throws SpdxBuilderException {
        List<SpdxDependencyInformation.FromRelationship> fromRelationships;
        List<Relationship> packageRelationships = dependencyInformation.getToRelationships();
        if (packageRelationships != null) {
            for (Relationship relationship : packageRelationships) {
                try {
                    this.projectPackage.addRelationship(relationship);
                }
                catch (InvalidSPDXAnalysisException e) {
                    this.log.error((CharSequence)("Unable to set package dependencies: " + e.getMessage()));
                    throw new SpdxBuilderException("Unable to set package dependencies", e);
                }
            }
        }
        if ((fromRelationships = dependencyInformation.getFromRelationships()) != null) {
            for (SpdxDependencyInformation.FromRelationship fromRelationship : fromRelationships) {
                try {
                    Relationship rel = fromRelationship.createAndAddRelationship(this.projectPackage);
                    this.log.debug((CharSequence)("Created relationship of type " + rel.getRelationshipType().toString() + " from " + fromRelationship.getFromPackage().getName()));
                }
                catch (InvalidSPDXAnalysisException e) {
                    this.log.error((CharSequence)("Unable to dependency to package: " + e.getMessage()));
                    throw new SpdxBuilderException("Unable to set dependency to package", e);
                }
            }
        }
    }

    private void fillSpdxDocumentInformation(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        try {
            if (projectInformation.getDocumentComment() != null && !projectInformation.getDocumentComment().isEmpty()) {
                this.spdxDoc.setComment(projectInformation.getDocumentComment());
            }
            this.fillCreatorInfo(projectInformation);
            SpdxListedLicense dataLicense = LicenseInfoFactory.getListedLicenseById((String)"CC0-1.0");
            this.spdxDoc.setDataLicense((AnyLicenseInfo)dataLicense);
            if (projectInformation.getDocumentAnnotations() != null && projectInformation.getDocumentAnnotations().length > 0) {
                this.spdxDoc.setAnnotations(this.toSpdxAnnotations(projectInformation.getDocumentAnnotations()));
            }
            this.spdxDoc.setName(projectInformation.getName());
            this.projectPackage = this.createSpdxPackage(projectInformation);
            Relationship documentContainsRelationship = this.spdxDoc.createRelationship((SpdxElement)this.projectPackage, RelationshipType.DESCRIBES, "");
            this.spdxDoc.addRelationship(documentContainsRelationship);
        }
        catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"SPDX error filling SPDX information", e);
            throw new SpdxBuilderException("Error adding package information to SPDX document: " + e.getMessage(), e);
        }
    }

    private Collection<org.spdx.library.model.Annotation> toSpdxAnnotations(Annotation[] annotations) throws MojoExecutionException {
        ArrayList<org.spdx.library.model.Annotation> retval = new ArrayList<org.spdx.library.model.Annotation>();
        for (int i = 0; i < annotations.length; ++i) {
            retval.add(annotations[i].toSpdxAnnotation(this.spdxDoc));
        }
        return retval;
    }

    private SpdxPackage createSpdxPackage(SpdxProjectInformation projectInformation) throws SpdxBuilderException {
        List<ExternalReference> externalRefs;
        SpdxPackage pkg;
        SpdxPackageVerificationCode nullPackageVerificationCode;
        String copyrightText = projectInformation.getCopyrightText();
        if (copyrightText == null) {
            copyrightText = UNSPECIFIED;
        }
        String downloadUrl = null;
        if (SpdxVerificationHelper.isValidUri((String)projectInformation.getDownloadUrl())) {
            downloadUrl = projectInformation.getDownloadUrl();
        } else {
            this.log.warn((CharSequence)("Invalid download location in POM file: " + projectInformation.getDownloadUrl()));
        }
        if (downloadUrl == null) {
            downloadUrl = UNSPECIFIED;
        }
        try {
            nullPackageVerificationCode = this.spdxDoc.createPackageVerificationCode(NULL_SHA1, new ArrayList());
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error creating null package verification code", (Throwable)e);
            throw new SpdxBuilderException("Error creating null package verification code: " + e.getMessage(), e);
        }
        try {
            pkg = this.spdxDoc.createPackage(this.spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, this.spdxDoc.getDocumentUri()), projectInformation.getName(), projectInformation.getConcludedLicense(), copyrightText, projectInformation.getDeclaredLicense()).setDownloadLocation(downloadUrl).setPackageVerificationCode(nullPackageVerificationCode).setPrimaryPurpose(projectInformation.getPrimaryPurpose()).build();
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error creating initial package", (Throwable)e);
            throw new SpdxBuilderException("Error creating initial package: " + e.getMessage(), e);
        }
        if (projectInformation.getPackageAnnotations() != null && projectInformation.getPackageAnnotations().length > 0) {
            try {
                pkg.setAnnotations(this.toSpdxAnnotations(projectInformation.getPackageAnnotations()));
            }
            catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                this.getLog().error((CharSequence)"Invalid package annotation", e);
                throw new SpdxBuilderException("Error adding package annotations to SPDX document: " + e.getMessage(), e);
            }
        }
        try {
            if (projectInformation.getDescription() != null) {
                pkg.setDescription(projectInformation.getDescription());
            }
            if (projectInformation.getDownloadUrl() != null) {
                pkg.setDownloadLocation(projectInformation.getDownloadUrl());
            }
            if (projectInformation.getPackageArchiveFileName() != null) {
                pkg.setPackageFileName(projectInformation.getPackageArchiveFileName());
            }
            if (projectInformation.getHomePage() != null) {
                try {
                    pkg.setHomepage(projectInformation.getHomePage());
                }
                catch (InvalidSPDXAnalysisException ex) {
                    this.log.warn((CharSequence)("Invalid URL in project POM file: " + projectInformation.getHomePage()));
                }
            }
            if (projectInformation.getSourceInfo() != null) {
                pkg.setSourceInfo(projectInformation.getSourceInfo());
            }
            if (projectInformation.getLicenseComment() != null) {
                pkg.setLicenseComments(projectInformation.getLicenseComment());
            }
            if (projectInformation.getOriginator() != null) {
                pkg.setOriginator(projectInformation.getOriginator());
            }
            if (projectInformation.getShortDescription() != null) {
                pkg.setSummary(projectInformation.getShortDescription());
            }
            if (projectInformation.getSupplier() != null) {
                pkg.setSupplier(projectInformation.getSupplier());
            }
            if (projectInformation.getVersionInfo() != null) {
                pkg.setVersionInfo(projectInformation.getVersionInfo());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"Error adding package properties", (Throwable)e);
            throw new SpdxBuilderException("Error adding package properties: " + e.getMessage(), e);
        }
        if (projectInformation.getChecksums() != null) {
            try {
                pkg.getChecksums().addAll(projectInformation.getChecksums());
            }
            catch (InvalidSPDXAnalysisException e) {
                this.getLog().error((CharSequence)"Invalid checksum value for package", (Throwable)e);
                throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid checksum provided: " + e.getMessage(), e);
            }
        }
        if ((externalRefs = projectInformation.getExternalRefs()) != null && externalRefs.size() > 0) {
            ExternalRef[] externalRefAr = new ExternalRef[externalRefs.size()];
            for (int i = 0; i < externalRefAr.length; ++i) {
                try {
                    pkg.getExternalRefs().add(externalRefs.get(i).getExternalRef(this.spdxDoc));
                    continue;
                }
                catch (MojoExecutionException | InvalidSPDXAnalysisException e) {
                    this.getLog().error((CharSequence)"Invalid external refs", e);
                    throw new SpdxBuilderException("Error adding package information to SPDX document - Invalid external refs provided: " + e.getMessage(), e);
                }
            }
        }
        return pkg;
    }

    private void fillCreatorInfo(SpdxProjectInformation projectInformation) throws InvalidSPDXAnalysisException {
        String[] parameterCreators;
        ArrayList<String> creators = new ArrayList<String>();
        for (String parameterCreator : parameterCreators = projectInformation.getCreators()) {
            String verify = SpdxVerificationHelper.verifyCreator((String)parameterCreator);
            if (verify == null) {
                creators.add(parameterCreator);
                continue;
            }
            this.getLog().warn((CharSequence)("Invalid creator string ( " + verify + " ), " + parameterCreator + " will be skipped."));
        }
        SpdxCreatorInformation spdxCreator = this.spdxDoc.createCreationInfo(creators, this.format.format(new Date()));
        spdxCreator.setComment(projectInformation.getCreatorComment());
        spdxCreator.setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        this.spdxDoc.setCreationInfo(spdxCreator);
    }

    private void collectSpdxFileInformation(FileSet[] includedSourceDirectories, FileSet[] includedTestDirectories, FileSet[] includedResourceDirectories, String baseDir, SpdxDefaultFileInformation defaultFileInformation, String spdxFileName, Map<String, SpdxDefaultFileInformation> pathSpecificInformation, Set<ChecksumAlgorithm> algorithms) throws InvalidSPDXAnalysisException, SpdxBuilderException {
        SpdxFileCollector fileCollector = new SpdxFileCollector(this.getLog());
        fileCollector.setLog(this.getLog());
        try {
            fileCollector.collectFiles(includedSourceDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.GENERATES, this.spdxDoc, algorithms);
            fileCollector.collectFiles(includedTestDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.TEST_CASE_OF, this.spdxDoc, algorithms);
            fileCollector.collectFiles(includedResourceDirectories, baseDir, defaultFileInformation, pathSpecificInformation, this.projectPackage, RelationshipType.CONTAINED_BY, this.spdxDoc, algorithms);
        }
        catch (SpdxCollectionException e) {
            this.getLog().error((CharSequence)"SPDX error collecting file information", (Throwable)e);
            throw new SpdxBuilderException("Error collecting SPDX file information: " + e.getMessage());
        }
        this.projectPackage.getFiles().addAll(fileCollector.getFiles());
        this.projectPackage.getLicenseInfoFromFiles().addAll(fileCollector.getLicenseInfoFromFiles());
        try {
            this.projectPackage.setPackageVerificationCode(fileCollector.getVerificationCode(spdxFileName, this.spdxDoc));
        }
        catch (NoSuchAlgorithmException e) {
            this.getLog().error((CharSequence)"Error calculating verification code", (Throwable)e);
            throw new SpdxBuilderException("Unable to calculate verification code");
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)"SPDX Error updating verification code", (Throwable)e);
            throw new SpdxBuilderException("Unable to update verification code");
        }
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }
}

