/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.LicenseManager;
import org.spdx.maven.LicenseManagerException;
import org.spdx.maven.LicenseMapperException;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.PathSpecificSpdxInfo;
import org.spdx.maven.SpdxBuilderException;
import org.spdx.maven.SpdxCollectionException;
import org.spdx.maven.SpdxDefaultFileInformation;
import org.spdx.maven.SpdxDependencyInformation;
import org.spdx.maven.SpdxDocumentBuilder;
import org.spdx.maven.SpdxFileCollector;
import org.spdx.maven.SpdxProjectInformation;
import org.spdx.storage.IModelStore;

@Mojo(name="createSPDX", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class CreateSpdxMojo
extends AbstractMojo {
    static final String INCLUDE_ALL = "**/*";
    public static final String CREATOR_TOOL_MAVEN_PLUGIN = "Tool: spdx-maven-plugin";
    public static final String SPDX_RDF_ARTIFACT_TYPE = "spdx.rdf.xml";
    public static final String SPDX_JSON_ARTIFACT_TYPE = "spdx.json";
    public static final String JSON_OUTPUT_FORMAT = "JSON";
    public static final String RDF_OUTPUT_FORMAT = "RDF/XML";
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/${project.groupId}_${project.artifactId}-${project.version}.spdx.json", property="spdxFileName", required=true)
    private File spdxFile;
    @Parameter(defaultValue="http://spdx.org/spdxpackages/${project.groupId}_${project.artifactId}-${project.version}", property="spdxDocumentNamespace", required=true)
    private String spdxDocumentNamespace;
    @Parameter(defaultValue="${project.basedir}", property="componentName")
    private String componentName;
    @Parameter
    private NonStandardLicense[] nonStandardLicenses;
    @Parameter(defaultValue="true")
    private boolean matchLicensesOnCrossReferenceUrls;
    @Parameter
    private String documentComment;
    @Parameter
    private Annotation[] documentAnnotations;
    @Parameter
    private Annotation[] packageAnnotations;
    @Parameter
    private String defaultFileComment;
    @Parameter
    private String[] defaultFileContributors;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileCopyright;
    @Parameter
    private String defaultFileLicenseComment;
    @Parameter
    private String defaultFileNotice;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileConcludedLicense;
    @Parameter(required=false)
    private String defaultLicenseInformationInFile;
    @Parameter
    private String licenseDeclared;
    @Parameter
    private String licenseConcluded;
    @Parameter
    private String creatorComment;
    @Parameter
    private String[] creators;
    @Parameter
    private String licenseComments;
    @Parameter
    private String originator;
    @Parameter
    private String sourceInfo;
    @Parameter(defaultValue="NOASSERTION")
    private String copyrightText;
    @Parameter
    private boolean onlyUseLocalLicenses;
    @Parameter
    private String[] checksumAlgorithms;
    @Parameter(required=false)
    private List<PathSpecificSpdxInfo> pathsWithSpecificSpdxInfo;
    @Parameter(required=false)
    private List<ExternalReference> externalReferences;
    @Parameter(required=false)
    private String outputFormat;
    @Parameter(defaultValue="true")
    private boolean createExternalRefs;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    private String artifactType;

    public void execute() throws MojoExecutionException {
        SpdxProjectInformation projectInformation;
        SpdxDocumentBuilder builder;
        String spdxFileName;
        this.dependencies = this.includeTransitiveDependencies ? this.mavenProject.getArtifacts() : this.mavenProject.getDependencyArtifacts();
        if (this.getLog() == null) {
            throw new MojoExecutionException("Null log for Mojo");
        }
        if (this.spdxFile == null) {
            throw new MojoExecutionException("No SPDX file referenced.  Specify a configuration parameter spdxFile to resolve.");
        }
        File outputDir = this.spdxFile.getParentFile();
        if (outputDir == null) {
            throw new MojoExecutionException("Invalid path for SPDX output file.  Specify a configuration parameter spdxFile with a valid directory path to resolve.");
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (this.onlyUseLocalLicenses) {
            System.setProperty("SPDXParser.OnlyUseLocalLicenses", "true");
        }
        if (this.defaultLicenseInformationInFile == null) {
            this.defaultLicenseInformationInFile = this.defaultFileConcludedLicense;
        }
        this.outputFormat = this.outputFormat == null ? ((spdxFileName = this.spdxFile.getName().toLowerCase()).endsWith(".rdf.xml") ? RDF_OUTPUT_FORMAT : JSON_OUTPUT_FORMAT) : this.outputFormat.toUpperCase();
        if (!RDF_OUTPUT_FORMAT.equals(this.outputFormat) && !JSON_OUTPUT_FORMAT.equals(this.outputFormat)) {
            this.getLog().warn((CharSequence)("Invalid SPDX output format: " + this.outputFormat + ".  Defaulting to JSON format."));
            this.outputFormat = JSON_OUTPUT_FORMAT;
        }
        this.artifactType = RDF_OUTPUT_FORMAT.equals(this.outputFormat) ? SPDX_RDF_ARTIFACT_TYPE : SPDX_JSON_ARTIFACT_TYPE;
        this.getLog().info((CharSequence)("Creating SPDX File " + this.spdxFile.getPath()));
        try {
            URL namespaceUrl = new URL(this.spdxDocumentNamespace);
            URI uri = new URI(namespaceUrl.getProtocol(), namespaceUrl.getUserInfo(), namespaceUrl.getHost(), namespaceUrl.getPort(), namespaceUrl.getPath(), namespaceUrl.getQuery(), namespaceUrl.getRef());
            namespaceUrl = uri.toURL();
            builder = new SpdxDocumentBuilder(this.getLog(), this.spdxFile, namespaceUrl, this.matchLicensesOnCrossReferenceUrls, this.outputFormat);
        }
        catch (SpdxBuilderException e) {
            this.getLog().error((CharSequence)("Error creating SPDX Document Builder: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error creating SPDX Document Builder: " + e.getMessage(), (Exception)e);
        }
        catch (LicenseMapperException e) {
            this.getLog().error((CharSequence)("License mapping error creating SPDX Document Builder: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("License mapping error creating SPDX Document Builder: " + e.getMessage(), (Exception)e);
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.getLog().error((CharSequence)("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace), (Throwable)e);
            throw new MojoExecutionException("Invalid SPDX document namespace - not a valid URL: " + this.spdxDocumentNamespace, e);
        }
        if (this.nonStandardLicenses != null) {
            try {
                builder.addNonStandardLicenses(this.nonStandardLicenses);
            }
            catch (SpdxBuilderException e) {
                this.getLog().error((CharSequence)("Error adding non standard licenses: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Error adding non standard licenses: " + e.getMessage(), (Exception)e);
            }
        }
        SpdxDocument spdxDoc = builder.getSpdxDoc();
        FileSet[] includedSourceDirectories = this.getSourceDirectories();
        FileSet[] includedResourceDirectories = this.getResourceDirectories();
        FileSet[] includedTestDirectories = this.getTestDirectories();
        try {
            projectInformation = this.getSpdxProjectInfoFromParameters(builder.getLicenseManager(), spdxDoc);
        }
        catch (InvalidSPDXAnalysisException e2) {
            this.getLog().error((CharSequence)("Error getting project information from parameters: " + e2.getMessage()), (Throwable)e2);
            throw new MojoExecutionException("Error getting project information from parameters: " + e2.getMessage(), (Exception)((Object)e2));
        }
        SpdxDefaultFileInformation defaultFileInformation = this.getDefaultFileInfoFromParameters(spdxDoc);
        HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation = this.getPathSpecificInfoFromParameters(defaultFileInformation, spdxDoc);
        SpdxDependencyInformation dependencyInformation = null;
        try {
            dependencyInformation = this.getSpdxDependencyInformation(this.dependencies, builder.getLicenseManager(), spdxDoc);
        }
        catch (LicenseMapperException e1) {
            this.getLog().error((CharSequence)("Error mapping licenses for dependencies: " + e1.getMessage()), (Throwable)e1);
            throw new MojoExecutionException("Error mapping licenses for dependencies: " + e1.getMessage(), (Exception)e1);
        }
        catch (InvalidSPDXAnalysisException e) {
            this.getLog().error((CharSequence)("SPDX analysis error processing dependencies: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("SPDX analysis error processing dependencies: " + e.getMessage(), (Exception)((Object)e));
        }
        this.logIncludedDirectories(includedSourceDirectories);
        this.logIncludedDirectories(includedTestDirectories);
        this.logIncludedDirectories(includedResourceDirectories);
        this.logNonStandardLicenses(this.nonStandardLicenses);
        projectInformation.logInfo(this.getLog(), spdxDoc);
        defaultFileInformation.logInfo(this.getLog());
        this.logFileSpecificInfo(pathSpecificInformation);
        this.logDependencies(this.dependencies);
        try {
            builder.buildDocumentFromFiles(includedSourceDirectories, includedTestDirectories, includedResourceDirectories, this.mavenProject.getBasedir().getAbsolutePath(), projectInformation, defaultFileInformation, pathSpecificInformation, dependencyInformation, this.getChecksumAlgorithms(), spdxDoc.getDocumentUri());
        }
        catch (SpdxBuilderException e) {
            this.getLog().error((CharSequence)("Error building SPDX document from project files: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error building SPDX document from project files: " + e.getMessage(), (Exception)e);
        }
        this.getLog().debug((CharSequence)("Project Helper: " + this.projectHelper));
        if (this.projectHelper != null) {
            this.projectHelper.attachArtifact(this.mavenProject, this.artifactType, this.spdxFile);
        } else {
            this.getLog().warn((CharSequence)"Unable to attach SPDX artifact file - no ProjectHelper exists");
        }
        List spdxErrors = builder.getSpdxDoc().verify();
        if (spdxErrors != null && spdxErrors.size() > 0) {
            StringBuilder sb = new StringBuilder("The following errors were found in the SPDX file:\n ");
            sb.append((String)spdxErrors.get(0));
            for (String spdxError : spdxErrors) {
                sb.append("\n ");
                sb.append(spdxError);
            }
            this.getLog().warn((CharSequence)sb.toString());
        }
    }

    private SpdxDependencyInformation getSpdxDependencyInformation(Set<Artifact> dependencies, LicenseManager licenseManager, SpdxDocument spdxDoc) throws LicenseMapperException, InvalidSPDXAnalysisException {
        SpdxDependencyInformation retval = new SpdxDependencyInformation(this.getLog(), licenseManager, spdxDoc, this.createExternalRefs);
        if (dependencies != null) {
            for (Artifact dependency : dependencies) {
                retval.addMavenDependency(dependency, this.mavenProjectBuilder, this.session);
            }
        }
        return retval;
    }

    private void logDependencies(Set<Artifact> dependencies) {
        this.getLog().debug((CharSequence)"Dependencies:");
        if (dependencies == null) {
            this.getLog().debug((CharSequence)"\tNull dependencies");
            return;
        }
        if (dependencies.isEmpty()) {
            this.getLog().debug((CharSequence)"\tZero dependencies");
            return;
        }
        for (Artifact dependency : dependencies) {
            String filePath = dependency.getFile() != null ? dependency.getFile().getAbsolutePath() : "[NONE]";
            String scope = dependency.getScope() != null ? dependency.getScope() : "[NONE]";
            this.getLog().debug((CharSequence)("ArtifactId: " + dependency.getArtifactId() + ", file path: " + filePath + ", Scope: " + scope));
        }
    }

    private void logFileSpecificInfo(HashMap<String, SpdxDefaultFileInformation> fileSpecificInformation) {
        for (Map.Entry<String, SpdxDefaultFileInformation> entry : fileSpecificInformation.entrySet()) {
            this.getLog().debug((CharSequence)("File Specific Information for " + entry.getKey()));
            entry.getValue().logInfo(this.getLog());
        }
    }

    private HashMap<String, SpdxDefaultFileInformation> getPathSpecificInfoFromParameters(SpdxDefaultFileInformation projectDefault, SpdxDocument spdxDoc) throws MojoExecutionException {
        HashMap<String, SpdxDefaultFileInformation> retval = new HashMap<String, SpdxDefaultFileInformation>();
        if (this.pathsWithSpecificSpdxInfo != null) {
            for (PathSpecificSpdxInfo spdxInfo : this.pathsWithSpecificSpdxInfo) {
                SpdxDefaultFileInformation value = null;
                try {
                    value = spdxInfo.getDefaultFileInformation(projectDefault, spdxDoc);
                }
                catch (InvalidSPDXAnalysisException e) {
                    this.getLog().error((CharSequence)("Invalid license string used in the path specific SPDX information for file " + spdxInfo.getPath()), (Throwable)e);
                    throw new MojoExecutionException("Invalid license string used in the path specific SPDX information for file " + spdxInfo.getPath(), (Exception)((Object)e));
                }
                if (retval.containsKey(spdxInfo.getPath())) {
                    this.getLog().warn((CharSequence)("Multiple file path specific SPDX data for " + spdxInfo.getPath()));
                }
                retval.put(spdxInfo.getPath(), value);
            }
        }
        return retval;
    }

    private void logNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) {
        if (nonStandardLicenses == null) {
            return;
        }
        for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
            this.getLog().debug((CharSequence)("Non standard license ID: " + nonStandardLicense.getLicenseId()));
            this.getLog().debug((CharSequence)("Non standard license Text: " + nonStandardLicense.getExtractedText()));
            this.getLog().debug((CharSequence)("Non standard license Comment: " + nonStandardLicense.getComment()));
            this.getLog().debug((CharSequence)("Non standard license Name: " + nonStandardLicense.getName()));
            String[] crossReferences = nonStandardLicense.getCrossReference();
            if (crossReferences == null) continue;
            for (String crossReference : crossReferences) {
                this.getLog().debug((CharSequence)("Non standard license cross reference: " + crossReference));
            }
        }
    }

    private void logIncludedDirectories(FileSet[] includedDirectories) {
        if (includedDirectories == null) {
            return;
        }
        this.getLog().debug((CharSequence)("Logging " + includedDirectories.length + " filesets."));
        for (FileSet includedDirectory : includedDirectories) {
            List excludes;
            StringBuilder sb = new StringBuilder("Included Directory: " + includedDirectory.getDirectory());
            List includes = includedDirectory.getIncludes();
            if (includes != null && includes.size() > 0) {
                sb.append("; Included=");
                sb.append((String)includes.get(0));
                for (int j = 1; j < includes.size(); ++j) {
                    sb.append(",");
                    sb.append((String)includes.get(j));
                }
            }
            if ((excludes = includedDirectory.getExcludes()) != null && excludes.size() > 0) {
                sb.append("; Excluded=");
                sb.append((String)excludes.get(0));
                for (int j = 1; j < excludes.size(); ++j) {
                    sb.append(",");
                    sb.append((String)excludes.get(j));
                }
            }
            this.getLog().debug((CharSequence)sb.toString());
        }
    }

    private SpdxDefaultFileInformation getDefaultFileInfoFromParameters(SpdxDocument spdxDoc) throws MojoExecutionException {
        SpdxDefaultFileInformation retval;
        try {
            retval = new SpdxDefaultFileInformation();
        }
        catch (InvalidSPDXAnalysisException e1) {
            this.getLog().error((CharSequence)("Error getting default file information: " + e1.getMessage()), (Throwable)e1);
            throw new MojoExecutionException("Error getting default file information: " + e1.getMessage(), (Exception)((Object)e1));
        }
        retval.setComment(this.defaultFileComment);
        AnyLicenseInfo concludedLicense = null;
        try {
            concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultFileConcludedLicense.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
        }
        catch (InvalidLicenseStringException e) {
            this.getLog().error((CharSequence)("Invalid default file concluded license: " + e.getMessage()));
            throw new MojoExecutionException("Invalid default file concluded license: " + e.getMessage());
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setContributors(this.defaultFileContributors);
        retval.setCopyright(this.defaultFileCopyright);
        AnyLicenseInfo declaredLicense = null;
        try {
            declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultLicenseInformationInFile.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
        }
        catch (InvalidLicenseStringException e) {
            this.getLog().error((CharSequence)("Invalid default file declared license: " + e.getMessage()));
            throw new MojoExecutionException("Invalid default file declared license: " + e.getMessage());
        }
        retval.setDeclaredLicense(declaredLicense);
        retval.setLicenseComment(this.defaultFileLicenseComment);
        retval.setNotice(this.defaultFileNotice);
        return retval;
    }

    private SpdxProjectInformation getSpdxProjectInfoFromParameters(LicenseManager licenseManager, SpdxDocument spdxDoc) throws MojoExecutionException, InvalidSPDXAnalysisException {
        Object supplier;
        SpdxProjectInformation retval;
        try {
            retval = new SpdxProjectInformation();
        }
        catch (InvalidSPDXAnalysisException e1) {
            this.getLog().error((CharSequence)("Unable to get SPDX project information: " + e1.getMessage()));
            throw new MojoExecutionException("Unable to get SPDX project information: " + e1.getMessage());
        }
        if (this.documentComment != null) {
            retval.setDocumentComment(this.documentComment);
        }
        AnyLicenseInfo declaredLicense = null;
        if (this.licenseDeclared == null) {
            List mavenLicenses = this.mavenProject.getLicenses();
            try {
                declaredLicense = licenseManager.mavenLicenseListToSpdxLicense(mavenLicenses);
            }
            catch (LicenseManagerException e) {
                this.getLog().warn((CharSequence)"Unable to map maven licenses to a declared license.  Using NOASSERTION");
                declaredLicense = new SpdxNoAssertionLicense();
            }
        } else {
            try {
                declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseDeclared.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
            }
            catch (InvalidLicenseStringException e) {
                this.getLog().error((CharSequence)("Invalid declared license: " + e.getMessage()));
                throw new MojoExecutionException("Invalid declared license: " + e.getMessage());
            }
        }
        AnyLicenseInfo concludedLicense = null;
        if (this.licenseConcluded == null) {
            concludedLicense = declaredLicense;
        } else {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseConcluded.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
            }
            catch (InvalidLicenseStringException e) {
                this.getLog().error((CharSequence)("Invalid concluded license: " + e.getMessage()));
                throw new MojoExecutionException("Invalid concluded license: " + e.getMessage());
            }
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setCreatorComment(this.creatorComment);
        if (this.creators == null) {
            this.creators = new String[0];
        }
        String[] allCreators = Arrays.copyOf(this.creators, this.creators.length + 1);
        allCreators[allCreators.length - 1] = CREATOR_TOOL_MAVEN_PLUGIN;
        retval.setCreators(allCreators);
        retval.setCopyrightText(this.copyrightText);
        retval.setDeclaredLicense(declaredLicense);
        String projectName = this.mavenProject.getName();
        if (projectName == null || projectName.isEmpty()) {
            projectName = this.getDefaultProjectName();
        }
        retval.setName(projectName);
        retval.setDescription(this.mavenProject.getDescription());
        String downloadUrl = "NOASSERTION";
        DistributionManagement distributionManager = this.mavenProject.getDistributionManagement();
        if (distributionManager != null && distributionManager.getDownloadUrl() != null && !distributionManager.getDownloadUrl().isEmpty()) {
            downloadUrl = distributionManager.getDownloadUrl();
        }
        retval.setDownloadUrl(downloadUrl);
        retval.setHomePage(this.mavenProject.getUrl());
        retval.setLicenseComment(this.licenseComments);
        if (this.originator == null && this.mavenProject.getOrganization() != null && this.mavenProject.getOrganization().getName() != null && !this.mavenProject.getOrganization().getName().isEmpty()) {
            this.originator = "Organization:" + this.mavenProject.getOrganization().getName();
        }
        retval.setOriginator(this.originator);
        Object packageFileName = null;
        File packageFile = null;
        Artifact mainArtifact = this.mavenProject.getArtifact();
        if (mainArtifact != null && mainArtifact.getFile() != null) {
            packageFileName = mainArtifact.getArtifactId() + "-" + mainArtifact.getVersion() + "." + mainArtifact.getType();
            packageFile = new File(mainArtifact.getFile().getParent() + File.separator + (String)packageFileName);
        }
        Set<Checksum> checksums = null;
        if (packageFile != null && packageFile.exists()) {
            try {
                this.getLog().debug((CharSequence)("Generating checksum for file " + packageFile.getAbsolutePath()));
                Set<ChecksumAlgorithm> algorithms = this.getChecksumAlgorithms();
                checksums = SpdxFileCollector.generateChecksum(packageFile, algorithms, spdxDoc);
            }
            catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
                this.getLog().warn((CharSequence)("Unable to compute checksum for " + packageFile.getName() + ":" + e.getMessage()));
                this.getLog().debug((CharSequence)"Exception information for checksum error", e);
            }
        } else {
            this.getLog().warn((CharSequence)(packageFile == null ? "Null package file" : "Package file " + packageFile.getAbsolutePath() + "does not exit"));
            packageFileName = "NOASSERTION";
        }
        retval.setPackageArchiveFileName((String)packageFileName);
        retval.setChecksums(checksums);
        retval.setShortDescription(this.mavenProject.getDescription());
        if (this.mavenProject.getOrganization() != null && (supplier = this.mavenProject.getOrganization().getName()) != null && !((String)supplier).isEmpty()) {
            supplier = "Organization: " + (String)supplier;
            retval.setSupplier((String)supplier);
        }
        retval.setSourceInfo(this.sourceInfo);
        retval.setVersionInfo(this.mavenProject.getVersion());
        retval.setDocumentAnnotations(this.documentAnnotations);
        retval.setPackageAnnotations(this.packageAnnotations);
        retval.setExternalRefs(this.externalReferences);
        String packaging = this.mavenProject.getPackaging();
        if ("pom".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.INSTALL);
        } else if ("ejb".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.LIBRARY);
        } else if ("jar".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.LIBRARY);
        } else if ("maven-plugin".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.LIBRARY);
        } else if ("war".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.APPLICATION);
        } else if ("ear".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.APPLICATION);
        } else if ("rar".equals(packaging)) {
            retval.setPrimaryPurpose(Purpose.OTHER);
        } else {
            retval.setPrimaryPurpose(Purpose.LIBRARY);
        }
        return retval;
    }

    private String getDefaultProjectName() {
        return this.mavenProject.getArtifactId();
    }

    private FileSet[] getSourceDirectories() {
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getCompileSourceRoots();
        if (sourceRoots != null) {
            for (String sourceRoot : sourceRoots) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File(sourceRoot);
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding sourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        return result.toArray(new FileSet[0]);
    }

    private FileSet[] getResourceDirectories() {
        List resourceList;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getCompileSourceRoots();
        if (sourceRoots != null) {
            for (String sourceRoot : sourceRoots) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File(sourceRoot);
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding sourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        if ((resourceList = this.mavenProject.getResources()) != null) {
            for (Resource resource : resourceList) {
                FileSet resourceFileSet = new FileSet();
                File resourceDir = new File(resource.getDirectory());
                resourceFileSet.setDirectory(resourceDir.getAbsolutePath());
                resourceFileSet.setExcludes(resource.getExcludes());
                resourceFileSet.setIncludes(resource.getIncludes());
                result.add(resourceFileSet);
                this.getLog().debug((CharSequence)("Adding resource directory " + resource.getDirectory()));
            }
        }
        this.getLog().debug((CharSequence)("Number of filesets: " + result.size()));
        return result.toArray(new FileSet[0]);
    }

    private FileSet[] getTestDirectories() {
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        List sourceRoots = this.mavenProject.getTestCompileSourceRoots();
        if (sourceRoots != null) {
            for (String sourceRoot : sourceRoots) {
                FileSet srcFileSet = new FileSet();
                File sourceDir = new File(sourceRoot);
                srcFileSet.setDirectory(sourceDir.getAbsolutePath());
                srcFileSet.addInclude(INCLUDE_ALL);
                result.add(srcFileSet);
                this.getLog().debug((CharSequence)("Adding TestSourceRoot directory " + srcFileSet.getDirectory()));
            }
        }
        return result.toArray(new FileSet[0]);
    }

    private Set<ChecksumAlgorithm> getChecksumAlgorithms() {
        HashSet<ChecksumAlgorithm> algorithms = new HashSet<ChecksumAlgorithm>();
        algorithms.add(ChecksumAlgorithm.SHA1);
        if (this.checksumAlgorithms != null) {
            block22: for (String checksumAlgorithm : this.checksumAlgorithms) {
                switch (checksumAlgorithm.toUpperCase()) {
                    case "SHA1": {
                        algorithms.add(ChecksumAlgorithm.SHA1);
                        continue block22;
                    }
                    case "SHA224": {
                        algorithms.add(ChecksumAlgorithm.SHA224);
                        continue block22;
                    }
                    case "SHA256": {
                        algorithms.add(ChecksumAlgorithm.SHA256);
                        continue block22;
                    }
                    case "SHA384": {
                        algorithms.add(ChecksumAlgorithm.SHA384);
                        continue block22;
                    }
                    case "SHA512": {
                        algorithms.add(ChecksumAlgorithm.SHA512);
                        continue block22;
                    }
                    case "MD2": {
                        algorithms.add(ChecksumAlgorithm.MD2);
                        continue block22;
                    }
                    case "MD4": {
                        algorithms.add(ChecksumAlgorithm.MD4);
                        continue block22;
                    }
                    case "MD5": {
                        algorithms.add(ChecksumAlgorithm.MD5);
                        continue block22;
                    }
                    case "MD6": {
                        algorithms.add(ChecksumAlgorithm.MD6);
                        continue block22;
                    }
                    default: {
                        this.getLog().warn((CharSequence)("Ignoring unsupported checksum algorithm: " + checksumAlgorithm));
                    }
                }
            }
        }
        return algorithms;
    }
}

