/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;

public enum OutputFormat {
    RDF_XML("RDF/XML", "spdx.rdf.xml", ".rdf.xml"),
    JSON("JSON", "spdx.json", ".json");

    private final String value;
    private final String artifactType;
    private final String fileType;

    private OutputFormat(String value, String artifactType, String fileType) {
        this.value = value;
        this.artifactType = artifactType;
        this.fileType = fileType;
    }

    public static OutputFormat getOutputFormat(String format, File file) throws IllegalArgumentException {
        if (format == null) {
            if (file != null) {
                return file.getName().toLowerCase().endsWith(".rdf.xml") ? RDF_XML : JSON;
            }
            throw new IllegalArgumentException("Could not determine output file");
        }
        String upperCaseFormat = format.toUpperCase();
        if (OutputFormat.RDF_XML.value.equals(upperCaseFormat)) {
            return RDF_XML;
        }
        if (OutputFormat.JSON.value.equals(upperCaseFormat)) {
            return JSON;
        }
        throw new IllegalArgumentException("Invalid SPDX output format: " + format);
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public String getFileType() {
        return this.fileType;
    }
}

