/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.License;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.maven.utils.LicenseManager;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.storage.listedlicense.LicenseJsonTOC;

public class MavenToSpdxLicenseMapper {
    private static final Logger LOG = LoggerFactory.getLogger(MavenToSpdxLicenseMapper.class);
    private static final String SPDX_LICENSE_URL_PREFIX = "https://spdx.org/licenses/";
    private static final String LISTED_LICENSE_JSON_URL = "https://spdx.org/licenses/licenses.json";
    private static final String LISTED_LICENSE_JSON_PATH = "resources/licenses.json";
    static MavenToSpdxLicenseMapper instance;
    private Map<String, String> urlStringToSpdxLicenseId;

    private MavenToSpdxLicenseMapper() throws LicenseMapperException {
        InputStream is = null;
        if (!"true".equals(System.getProperty("SPDXParser.OnlyUseLocalLicenses"))) {
            try {
                URL listedLicenseJsonUrl = new URL(LISTED_LICENSE_JSON_URL);
                is = listedLicenseJsonUrl.openStream();
            }
            catch (MalformedURLException e) {
                LOG.warn("Invalid JSON URL for SPDX listed licenses.  Using cached version");
            }
            catch (IOException e) {
                LOG.warn("IO Exception opening web page for JSON for SPDX listed licenses.  Using cached version");
            }
        }
        if (is == null) {
            is = LicenseManager.class.getClassLoader().getResourceAsStream(LISTED_LICENSE_JSON_PATH);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));){
            this.initializeUrlMap(reader);
        }
        catch (IOException e) {
            LOG.warn("IO error closing listed license reader", (Throwable)e);
        }
    }

    public static MavenToSpdxLicenseMapper getInstance() throws LicenseMapperException {
        if (instance == null) {
            instance = new MavenToSpdxLicenseMapper();
        }
        return instance;
    }

    public String urlToSpdxId(String url) {
        return this.urlStringToSpdxLicenseId.get(url);
    }

    private void initializeUrlMap(BufferedReader jsonReader) throws LicenseMapperException {
        LicenseJsonTOC jsonToc;
        try {
            String line;
            Gson gson = new Gson();
            StringBuilder tocJsonStr = new StringBuilder();
            while ((line = jsonReader.readLine()) != null) {
                tocJsonStr.append(line);
            }
            jsonToc = (LicenseJsonTOC)gson.fromJson(tocJsonStr.toString(), LicenseJsonTOC.class);
        }
        catch (IOException e1) {
            throw new LicenseMapperException("I/O Error parsing listed licenses", e1);
        }
        this.urlStringToSpdxLicenseId = new HashMap<String, String>();
        ArrayList<String> urlsWithMultipleIds = new ArrayList<String>();
        for (LicenseJsonTOC.LicenseJson licenseJson : jsonToc.getLicenses()) {
            String licenseId = licenseJson.getLicenseId();
            this.urlStringToSpdxLicenseId.put(SPDX_LICENSE_URL_PREFIX + licenseId, licenseId);
            if (licenseJson.getSeeAlso() == null) continue;
            for (String url : licenseJson.getSeeAlso()) {
                if (this.urlStringToSpdxLicenseId.containsKey(url = url.replaceAll("https", "http"))) {
                    urlsWithMultipleIds.add(url);
                    continue;
                }
                this.urlStringToSpdxLicenseId.put(url, licenseId);
            }
        }
        for (String redundantUrl : urlsWithMultipleIds) {
            this.urlStringToSpdxLicenseId.remove(redundantUrl);
        }
        this.addManualMappings();
    }

    private void addManualMappings() {
        this.urlStringToSpdxLicenseId.put("http://www.apache.org/licenses/LICENSE-2.0.txt", "Apache-2.0");
        this.urlStringToSpdxLicenseId.put("http://www.opensource.org/licenses/cpl1.0.txt", "CPL-1.0");
        this.urlStringToSpdxLicenseId.put("http://www.opensource.org/licenses/mit-license.php", "MIT");
        this.urlStringToSpdxLicenseId.put("http://www.mozilla.org/MPL/MPL-1.0.txt", "MPL-1.0");
    }

    public AnyLicenseInfo mavenLicenseListToSpdxLicense(List<License> licenseList, SpdxDocument spdxDoc) throws InvalidSPDXAnalysisException {
        if (licenseList == null) {
            return new SpdxNoAssertionLicense();
        }
        ArrayList<SpdxListedLicense> spdxLicenses = new ArrayList<SpdxListedLicense>();
        for (License license : licenseList) {
            SpdxListedLicense listedLicense = this.mavenLicenseToSpdxListedLicense(license);
            if (listedLicense == null) continue;
            spdxLicenses.add(listedLicense);
        }
        if (spdxLicenses.size() < 1) {
            return new SpdxNoAssertionLicense();
        }
        if (spdxLicenses.size() == 1) {
            return (AnyLicenseInfo)spdxLicenses.get(0);
        }
        ConjunctiveLicenseSet conjunctiveLicense = spdxDoc.createConjunctiveLicenseSet(spdxLicenses);
        return conjunctiveLicense;
    }

    private SpdxListedLicense mavenLicenseToSpdxListedLicense(License license) {
        if (license == null) {
            return null;
        }
        if (license.getUrl() == null || license.getUrl().isEmpty()) {
            return null;
        }
        String spdxId = this.urlStringToSpdxLicenseId.get(license.getUrl().replaceAll("https", "http"));
        if (spdxId == null) {
            return null;
        }
        try {
            return LicenseInfoFactory.getListedLicenseById((String)spdxId);
        }
        catch (InvalidSPDXAnalysisException e) {
            return null;
        }
    }

    public Map<String, String> getMap() {
        return this.urlStringToSpdxLicenseId;
    }
}

