/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.maven.Annotation;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.Packaging;
import org.spdx.maven.PathSpecificSpdxInfo;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxDependencyInformation;
import org.spdx.maven.utils.SpdxDocumentBuilder;
import org.spdx.maven.utils.SpdxFileCollector;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.storage.IModelStore;

@Mojo(name="createSPDX", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class CreateSpdxMojo
extends AbstractMojo {
    public static final String INCLUDE_ALL = "**/*";
    public static final String CREATOR_TOOL_MAVEN_PLUGIN = "Tool: spdx-maven-plugin";
    public static final String SPDX_RDF_ARTIFACT_TYPE = "spdx.rdf.xml";
    public static final String SPDX_JSON_ARTIFACT_TYPE = "spdx.json";
    public static final String JSON_OUTPUT_FORMAT = "JSON";
    public static final String RDF_OUTPUT_FORMAT = "RDF/XML";
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ProjectBuilder mavenProjectBuilder;
    @Component
    private MavenSession session;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/${project.groupId}_${project.artifactId}-${project.version}.spdx", property="spdxFileName")
    private File spdxFile;
    @Parameter(defaultValue="http://spdx.org/spdxpackages/${project.groupId}_${project.artifactId}-${project.version}")
    private String spdxDocumentNamespace;
    @Parameter(defaultValue="${project.basedir}")
    private String componentName;
    @Parameter
    private NonStandardLicense[] nonStandardLicenses;
    @Parameter(defaultValue="true")
    private boolean matchLicensesOnCrossReferenceUrls;
    @Parameter
    private String documentComment;
    @Parameter
    private Annotation[] documentAnnotations;
    @Parameter
    private Annotation[] packageAnnotations;
    @Parameter
    private String defaultFileComment;
    @Parameter
    private String[] defaultFileContributors;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileCopyright;
    @Parameter
    private String defaultFileLicenseComment;
    @Parameter
    private String defaultFileNotice;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileConcludedLicense;
    @Parameter(required=false)
    private String defaultLicenseInformationInFile;
    @Parameter
    private String licenseDeclared;
    @Parameter
    private String licenseConcluded;
    @Parameter
    private String creatorComment;
    @Parameter
    private String[] creators;
    @Parameter
    private String licenseComments;
    @Parameter
    private String originator;
    @Parameter
    private String sourceInfo;
    @Parameter(defaultValue="NOASSERTION")
    private String copyrightText;
    @Parameter
    private boolean onlyUseLocalLicenses;
    @Parameter
    private String[] checksumAlgorithms;
    @Parameter
    private PathSpecificSpdxInfo[] pathsWithSpecificSpdxInfo;
    @Parameter
    private ExternalReference[] externalReferences;
    @Parameter(defaultValue="JSON")
    private String outputFormat;
    @Parameter(defaultValue="true")
    private boolean createExternalRefs;
    @Parameter(defaultValue="true")
    private boolean includeTransitiveDependencies;
    @Parameter(property="spdx.skip")
    private boolean skip = false;
    @Parameter(property="spdx.useArtifactID")
    private boolean useArtifactID;
    @Parameter(property="spdx.generatePurls")
    private boolean generatePurls = true;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping SPDX");
            return;
        }
        OutputFormat outputFormatEnum = this.prepareOutput();
        String artifactType = outputFormatEnum.getArtifactType();
        this.getLog().info((CharSequence)("Creating SPDX File " + this.spdxFile.getPath()));
        SpdxDocumentBuilder builder = this.initSpdxDocumentBuilder(outputFormatEnum);
        SpdxDocument spdxDoc = builder.getSpdxDoc();
        try {
            SpdxProjectInformation projectInformation = this.getSpdxProjectInfoFromParameters(builder);
            projectInformation.logInfo(spdxDoc);
            builder.fillSpdxDocumentInformation(projectInformation);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new MojoExecutionException("Error getting project information from parameters", (Exception)((Object)e2));
        }
        SpdxDefaultFileInformation defaultFileInformation = this.getDefaultFileInfoFromParameters(spdxDoc);
        HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation = this.getPathSpecificInfoFromParameters(defaultFileInformation, spdxDoc);
        List<FileSet> sources = CreateSpdxMojo.toFileSet(this.mavenProject.getCompileSourceRoots(), this.mavenProject.getResources());
        sources.addAll(CreateSpdxMojo.toFileSet(this.mavenProject.getTestCompileSourceRoots(), null));
        if (this.getLog().isDebugEnabled()) {
            this.logIncludedDirectories(sources);
            this.logNonStandardLicenses(this.nonStandardLicenses);
            defaultFileInformation.logInfo();
            this.logFileSpecificInfo(pathSpecificInformation);
        }
        builder.collectSpdxFileInformation(sources, this.mavenProject.getBasedir().getAbsolutePath(), defaultFileInformation, pathSpecificInformation, this.getChecksumAlgorithms());
        try {
            SpdxDependencyInformation dependencyInformation = this.getSpdxDependencyInformation(builder);
            builder.addDependencyInformation(dependencyInformation);
        }
        catch (LicenseMapperException e1) {
            throw new MojoExecutionException("Error mapping licenses for dependencies", (Exception)e1);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("SPDX analysis error processing dependencies", (Exception)((Object)e));
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("SPDX analysis error getting the dependencies", (Exception)((Object)e));
        }
        builder.saveSpdxDocumentToFile();
        this.projectHelper.attachArtifact(this.mavenProject, artifactType, this.spdxFile);
        List spdxErrors = builder.getSpdxDoc().verify();
        if (spdxErrors != null && spdxErrors.size() > 0) {
            this.getLog().warn((CharSequence)("The following errors were found in the SPDX file:\n " + String.join((CharSequence)"\n ", spdxErrors)));
        }
    }

    private OutputFormat prepareOutput() throws MojoExecutionException {
        File outputDir;
        OutputFormat outputFormatEnum = OutputFormat.JSON;
        try {
            outputFormatEnum = OutputFormat.getOutputFormat(this.outputFormat, this.spdxFile);
        }
        catch (IllegalArgumentException iae) {
            this.getLog().warn((CharSequence)"Invalid SPDX output format, defaulting to JSON format.");
        }
        if (this.spdxFile.getName().endsWith(".spdx")) {
            String spdxFileType = outputFormatEnum.getFileType();
            this.getLog().info((CharSequence)("spdx file type = " + spdxFileType));
            this.spdxFile = new File(this.spdxFile.getAbsolutePath() + spdxFileType);
        }
        if ((outputDir = this.spdxFile.getParentFile()) == null) {
            throw new MojoExecutionException("Invalid path for SPDX output file.  Specify a configuration parameter spdxFile with a valid directory path to resolve.");
        }
        outputDir.mkdirs();
        return outputFormatEnum;
    }

    private SpdxDocumentBuilder initSpdxDocumentBuilder(OutputFormat outputFormatEnum) throws MojoExecutionException {
        SpdxDocumentBuilder builder;
        if (this.onlyUseLocalLicenses) {
            System.setProperty("SPDXParser.OnlyUseLocalLicenses", "true");
        }
        if (this.defaultLicenseInformationInFile == null) {
            this.defaultLicenseInformationInFile = this.defaultFileConcludedLicense;
        }
        try {
            if (this.spdxDocumentNamespace.startsWith("http://spdx.org/spdxpackages/")) {
                this.spdxDocumentNamespace = this.spdxDocumentNamespace.replace(" ", "%20");
            }
            URI namespaceUri = new URI(this.spdxDocumentNamespace);
            builder = new SpdxDocumentBuilder(this.mavenProject, this.generatePurls, this.spdxFile, namespaceUri, this.matchLicensesOnCrossReferenceUrls, outputFormatEnum);
        }
        catch (SpdxBuilderException e) {
            throw new MojoExecutionException("Error creating SPDX Document Builder", (Exception)((Object)e));
        }
        catch (LicenseMapperException e) {
            throw new MojoExecutionException("License mapping error creating SPDX Document Builder", (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid SPDX document namespace - not a valid URI: " + this.spdxDocumentNamespace, (Exception)e);
        }
        if (this.nonStandardLicenses != null) {
            try {
                builder.addNonStandardLicenses(this.nonStandardLicenses);
            }
            catch (SpdxBuilderException e) {
                throw new MojoExecutionException("Error adding non standard licenses", (Exception)((Object)e));
            }
        }
        return builder;
    }

    private SpdxDependencyInformation getSpdxDependencyInformation(SpdxDocumentBuilder builder) throws LicenseMapperException, InvalidSPDXAnalysisException, DependencyGraphBuilderException {
        SpdxDependencyInformation retval = new SpdxDependencyInformation(builder.getLicenseManager(), builder.getSpdxDoc(), this.createExternalRefs, this.generatePurls, this.useArtifactID, this.includeTransitiveDependencies);
        if (this.session != null) {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            request.setProject(this.mavenProject);
            DependencyNode parentNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, null);
            retval.addMavenDependencies(this.mavenProjectBuilder, this.session, this.mavenProject, parentNode, (SpdxElement)builder.getProjectPackage());
        }
        return retval;
    }

    private void logFileSpecificInfo(HashMap<String, SpdxDefaultFileInformation> fileSpecificInformation) {
        if (!this.getLog().isDebugEnabled()) {
            return;
        }
        for (Map.Entry<String, SpdxDefaultFileInformation> entry : fileSpecificInformation.entrySet()) {
            this.getLog().debug((CharSequence)("File Specific Information for " + entry.getKey()));
            entry.getValue().logInfo();
        }
    }

    private HashMap<String, SpdxDefaultFileInformation> getPathSpecificInfoFromParameters(SpdxDefaultFileInformation projectDefault, SpdxDocument spdxDoc) throws MojoExecutionException {
        HashMap<String, SpdxDefaultFileInformation> retval = new HashMap<String, SpdxDefaultFileInformation>();
        if (this.pathsWithSpecificSpdxInfo != null) {
            for (PathSpecificSpdxInfo spdxInfo : this.pathsWithSpecificSpdxInfo) {
                SpdxDefaultFileInformation value = null;
                try {
                    value = spdxInfo.getDefaultFileInformation(projectDefault, spdxDoc);
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new MojoExecutionException("Invalid license string used in the path specific SPDX information for file " + spdxInfo.getPath(), (Exception)((Object)e));
                }
                if (retval.containsKey(spdxInfo.getPath())) {
                    this.getLog().warn((CharSequence)("Multiple file path specific SPDX data for " + spdxInfo.getPath()));
                }
                retval.put(spdxInfo.getPath(), value);
            }
        }
        return retval;
    }

    private void logNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) {
        if (nonStandardLicenses == null || !this.getLog().isDebugEnabled()) {
            return;
        }
        for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
            this.getLog().debug((CharSequence)("Non standard license ID: " + nonStandardLicense.getLicenseId()));
            this.getLog().debug((CharSequence)("Non standard license Text: " + nonStandardLicense.getExtractedText()));
            this.getLog().debug((CharSequence)("Non standard license Comment: " + nonStandardLicense.getComment()));
            this.getLog().debug((CharSequence)("Non standard license Name: " + nonStandardLicense.getName()));
            String[] crossReferences = nonStandardLicense.getCrossReference();
            if (crossReferences == null) continue;
            for (String crossReference : crossReferences) {
                this.getLog().debug((CharSequence)("Non standard license cross reference: " + crossReference));
            }
        }
    }

    private void logIncludedDirectories(List<FileSet> includedDirectories) {
        if (includedDirectories == null || !this.getLog().isDebugEnabled()) {
            return;
        }
        this.getLog().debug((CharSequence)("Logging " + includedDirectories.size() + " filesets."));
        for (FileSet includedDirectory : includedDirectories) {
            List excludes;
            StringBuilder sb = new StringBuilder("Included Directory: " + includedDirectory.getDirectory());
            List includes = includedDirectory.getIncludes();
            if (!includes.isEmpty()) {
                sb.append("; Included=");
                sb.append(String.join((CharSequence)",", includes));
            }
            if (!(excludes = includedDirectory.getExcludes()).isEmpty()) {
                sb.append("; Excluded=");
                sb.append(String.join((CharSequence)",", excludes));
            }
            this.getLog().debug((CharSequence)sb.toString());
        }
    }

    private SpdxDefaultFileInformation getDefaultFileInfoFromParameters(SpdxDocument spdxDoc) throws MojoExecutionException {
        SpdxDefaultFileInformation retval;
        try {
            retval = new SpdxDefaultFileInformation();
        }
        catch (InvalidSPDXAnalysisException e1) {
            throw new MojoExecutionException("Error getting default file information", (Exception)((Object)e1));
        }
        retval.setComment(this.defaultFileComment);
        AnyLicenseInfo concludedLicense = null;
        try {
            concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultFileConcludedLicense.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
        }
        catch (InvalidLicenseStringException e) {
            throw new MojoExecutionException("Invalid default file concluded license", (Exception)((Object)e));
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setContributors(this.defaultFileContributors);
        retval.setCopyright(this.defaultFileCopyright);
        AnyLicenseInfo declaredLicense = null;
        try {
            declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.defaultLicenseInformationInFile.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
        }
        catch (InvalidLicenseStringException e) {
            throw new MojoExecutionException("Invalid default file declared license", (Exception)((Object)e));
        }
        retval.setDeclaredLicense(declaredLicense);
        retval.setLicenseComment(this.defaultFileLicenseComment);
        retval.setNotice(this.defaultFileNotice);
        return retval;
    }

    private SpdxProjectInformation getSpdxProjectInfoFromParameters(SpdxDocumentBuilder builder) throws MojoExecutionException, InvalidSPDXAnalysisException {
        Object supplier;
        SpdxDocument spdxDoc = builder.getSpdxDoc();
        SpdxProjectInformation retval = new SpdxProjectInformation();
        if (this.documentComment != null) {
            retval.setDocumentComment(this.documentComment);
        }
        AnyLicenseInfo declaredLicense = null;
        if (this.licenseDeclared == null) {
            List mavenLicenses = this.mavenProject.getLicenses();
            try {
                declaredLicense = builder.getLicenseManager().mavenLicenseListToSpdxLicense(mavenLicenses);
            }
            catch (LicenseManagerException e) {
                this.getLog().warn((CharSequence)"Unable to map maven licenses to a declared license.  Using NOASSERTION");
                declaredLicense = new SpdxNoAssertionLicense();
            }
        } else {
            try {
                declaredLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseDeclared.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
            }
            catch (InvalidLicenseStringException e) {
                throw new MojoExecutionException("Invalid declared license: " + this.licenseDeclared.trim(), (Exception)((Object)e));
            }
        }
        AnyLicenseInfo concludedLicense = null;
        if (this.licenseConcluded == null) {
            concludedLicense = declaredLicense;
        } else {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseConcluded.trim(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
            }
            catch (InvalidLicenseStringException e) {
                throw new MojoExecutionException("Invalid concluded license: " + this.licenseConcluded.trim(), (Exception)((Object)e));
            }
        }
        retval.setConcludedLicense(concludedLicense);
        retval.setCreatorComment(this.creatorComment);
        if (this.creators == null) {
            this.creators = new String[0];
        }
        String[] allCreators = Arrays.copyOf(this.creators, this.creators.length + 1);
        allCreators[allCreators.length - 1] = CREATOR_TOOL_MAVEN_PLUGIN;
        retval.setCreators(allCreators);
        retval.setCopyrightText(this.copyrightText);
        retval.setDeclaredLicense(declaredLicense);
        String projectName = this.mavenProject.getName();
        if (projectName == null || projectName.isEmpty() || this.useArtifactID) {
            projectName = this.getDefaultProjectName();
        }
        retval.setName(projectName);
        retval.setDescription(this.mavenProject.getDescription());
        String downloadUrl = "NOASSERTION";
        DistributionManagement distributionManager = this.mavenProject.getDistributionManagement();
        if (distributionManager != null && distributionManager.getDownloadUrl() != null && !distributionManager.getDownloadUrl().isEmpty()) {
            downloadUrl = distributionManager.getDownloadUrl();
        }
        retval.setDownloadUrl(downloadUrl);
        retval.setHomePage(this.mavenProject.getUrl());
        retval.setLicenseComment(this.licenseComments);
        if (this.originator == null && this.mavenProject.getOrganization() != null && this.mavenProject.getOrganization().getName() != null && !this.mavenProject.getOrganization().getName().isEmpty()) {
            this.originator = "Organization:" + this.mavenProject.getOrganization().getName();
        }
        retval.setOriginator(this.originator);
        Object packageFileName = null;
        File packageFile = null;
        Artifact mainArtifact = this.mavenProject.getArtifact();
        if (mainArtifact != null && mainArtifact.getFile() != null) {
            packageFileName = mainArtifact.getArtifactId() + "-" + mainArtifact.getVersion() + "." + mainArtifact.getType();
            packageFile = new File(mainArtifact.getFile().getParent() + File.separator + (String)packageFileName);
        }
        Set<Checksum> checksums = null;
        if (packageFile != null && packageFile.exists()) {
            try {
                this.getLog().debug((CharSequence)("Generating checksum for file " + packageFile.getAbsolutePath()));
                Set<ChecksumAlgorithm> algorithms = this.getChecksumAlgorithms();
                checksums = SpdxFileCollector.generateChecksum(packageFile, algorithms, spdxDoc);
            }
            catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
                this.getLog().warn((CharSequence)("Unable to compute checksum for " + packageFile.getName() + ":" + e.getMessage()));
                this.getLog().debug((CharSequence)"Exception information for checksum error", e);
            }
        } else {
            this.getLog().warn((CharSequence)(packageFile == null ? "Null package file" : "Package file " + packageFile.getAbsolutePath() + " does not exist"));
            packageFileName = "NOASSERTION";
        }
        retval.setPackageArchiveFileName((String)packageFileName);
        retval.setChecksums(checksums);
        retval.setShortDescription(this.mavenProject.getDescription());
        if (this.mavenProject.getOrganization() != null && (supplier = this.mavenProject.getOrganization().getName()) != null && !((String)supplier).isEmpty()) {
            supplier = "Organization: " + (String)supplier;
            retval.setSupplier((String)supplier);
        }
        retval.setSourceInfo(this.sourceInfo);
        retval.setVersionInfo(this.mavenProject.getVersion());
        retval.setDocumentAnnotations(this.documentAnnotations);
        retval.setPackageAnnotations(this.packageAnnotations);
        retval.setExternalRefs(this.externalReferences);
        Packaging packaging = Packaging.valueOfPackaging(this.mavenProject.getPackaging());
        retval.setPrimaryPurpose(packaging != null ? packaging.getPurpose() : Purpose.LIBRARY);
        return retval;
    }

    private String getDefaultProjectName() {
        return this.mavenProject.getGroupId() + ":" + this.mavenProject.getArtifactId();
    }

    private static List<FileSet> toFileSet(List<String> roots, List<Resource> resources) {
        File dir;
        FileSet fileSet;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        if (roots != null) {
            for (String root : roots) {
                fileSet = new FileSet();
                dir = new File(root);
                fileSet.setDirectory(dir.getAbsolutePath());
                fileSet.addInclude(INCLUDE_ALL);
                result.add(fileSet);
            }
        }
        if (resources != null) {
            for (Resource resource : resources) {
                fileSet = new FileSet();
                dir = new File(resource.getDirectory());
                fileSet.setDirectory(dir.getAbsolutePath());
                fileSet.setExcludes(resource.getExcludes());
                fileSet.setIncludes(resource.getIncludes());
                result.add(fileSet);
            }
        }
        return result;
    }

    private Set<ChecksumAlgorithm> getChecksumAlgorithms() {
        HashSet<ChecksumAlgorithm> algorithms = new HashSet<ChecksumAlgorithm>();
        algorithms.add(ChecksumAlgorithm.SHA1);
        if (this.checksumAlgorithms != null) {
            for (String checksumAlgorithm : this.checksumAlgorithms) {
                try {
                    algorithms.add(ChecksumAlgorithm.valueOf((String)checksumAlgorithm.toUpperCase()));
                }
                catch (IllegalArgumentException iae) {
                    this.getLog().warn((CharSequence)("Ignoring unsupported checksum algorithm: " + checksumAlgorithm));
                }
            }
        }
        return algorithms;
    }
}

