/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.SpdxCoreConstants;
import org.spdx.library.LicenseInfoFactory;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.InvalidLicenseStringException;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.maven.Annotation;
import org.spdx.maven.Checksum;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.LicenseOverwrite;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.Packaging;
import org.spdx.maven.PathSpecificSpdxInfo;
import org.spdx.maven.utils.AbstractDependencyBuilder;
import org.spdx.maven.utils.AbstractDocumentBuilder;
import org.spdx.maven.utils.AbstractFileCollector;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.LicenseMapperException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxCollectionException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.maven.utils.SpdxV2DependencyBuilder;
import org.spdx.maven.utils.SpdxV2DocumentBuilder;
import org.spdx.maven.utils.SpdxV3DependencyBuilder;
import org.spdx.maven.utils.SpdxV3DocumentBuilder;
import org.spdx.storage.IModelStore;

@Mojo(name="createSPDX", defaultPhase=LifecyclePhase.VERIFY, requiresOnline=true, threadSafe=true)
public class CreateSpdxMojo
extends AbstractMojo {
    public static final String INCLUDE_ALL = "**/*";
    public static final String CREATOR_TOOL_MAVEN_PLUGIN = "Tool: spdx-maven-plugin";
    public static final String SPDX_RDF_ARTIFACT_TYPE = "spdx.rdf.xml";
    public static final String SPDX_JSON_ARTIFACT_TYPE = "spdx.json";
    public static final String JSON_OUTPUT_FORMAT = "JSON";
    public static final String RDF_OUTPUT_FORMAT = "RDF/XML";
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    protected ProjectBuilder mavenProjectBuilder;
    @Component
    protected MavenSession session;
    @Component(hint="default")
    protected DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/${project.groupId}_${project.artifactId}-${project.version}.spdx", property="spdxFileName")
    private File spdxFile;
    @Parameter(defaultValue="http://spdx.org/spdxpackages/${project.groupId}_${project.artifactId}-${project.version}")
    private String spdxDocumentNamespace;
    @Parameter(defaultValue="${project.basedir}")
    private String componentName;
    @Parameter
    private NonStandardLicense[] nonStandardLicenses;
    @Parameter
    private LicenseOverwrite[] licenseOverwrites;
    @Parameter(defaultValue="true")
    private boolean matchLicensesOnCrossReferenceUrls;
    @Parameter
    private String documentComment;
    @Parameter
    private Annotation[] documentAnnotations;
    @Parameter
    private Annotation[] packageAnnotations;
    @Parameter
    private String defaultFileComment;
    @Parameter
    private String[] defaultFileContributors;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileCopyright;
    @Parameter
    private String defaultFileLicenseComment;
    @Parameter
    private String defaultFileNotice;
    @Parameter(defaultValue="NOASSERTION")
    private String defaultFileConcludedLicense;
    @Parameter(required=false)
    private String defaultLicenseInformationInFile;
    @Parameter
    private String licenseDeclared;
    @Parameter
    private String licenseConcluded;
    @Parameter
    private String creatorComment;
    @Parameter
    private String[] creators;
    @Parameter
    private String licenseComments;
    @Parameter
    private String originator;
    @Parameter
    private String sourceInfo;
    @Parameter(defaultValue="NOASSERTION")
    private String copyrightText;
    @Parameter
    private boolean onlyUseLocalLicenses;
    @Parameter
    private String[] checksumAlgorithms;
    @Parameter
    private PathSpecificSpdxInfo[] pathsWithSpecificSpdxInfo;
    @Parameter
    private ExternalReference[] externalReferences;
    @Parameter(defaultValue="JSON")
    private String outputFormat;
    @Parameter(defaultValue="consolidated")
    private String sbomType;
    @Parameter(defaultValue="true")
    protected boolean createExternalRefs;
    @Parameter(defaultValue="true")
    protected boolean includeTransitiveDependencies;
    @Parameter(property="spdx.skip")
    private boolean skip = false;
    @Parameter(property="spdx.useArtifactID")
    protected boolean useArtifactID;
    @Parameter(property="spdx.generatePurls")
    protected boolean generatePurls = true;
    @Parameter(defaultValue="true")
    private boolean includeSystemScope;
    @Parameter(defaultValue="true")
    private boolean includeTestScope;
    @Parameter(defaultValue="true")
    private boolean includeRuntimeScope;
    @Parameter(defaultValue="true")
    private boolean includeProvidedScope;
    @Parameter(defaultValue="true")
    private boolean includeCompileScope;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String created;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping SPDX");
            return;
        }
        OutputFormat outputFormatEnum = this.prepareOutput();
        String artifactType = outputFormatEnum.getArtifactType();
        this.getLog().info((CharSequence)("Creating SPDX File " + this.spdxFile.getPath()));
        AbstractDocumentBuilder builder = this.initSpdxDocumentBuilder(outputFormatEnum);
        try {
            SpdxProjectInformation projectInformation = this.getSpdxProjectInfoFromParameters(builder);
            projectInformation.logInfo();
            builder.fillSpdxDocumentInformation(projectInformation);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new MojoExecutionException("Error getting project information from parameters", (Exception)((Object)e2));
        }
        SpdxDefaultFileInformation defaultFileInformation = this.getDefaultFileInfoFromParameters();
        HashMap<String, SpdxDefaultFileInformation> pathSpecificInformation = this.getPathSpecificInfoFromParameters(defaultFileInformation);
        List<FileSet> sources = CreateSpdxMojo.toFileSet(this.mavenProject.getCompileSourceRoots(), this.mavenProject.getResources());
        sources.addAll(CreateSpdxMojo.toFileSet(this.mavenProject.getTestCompileSourceRoots(), null));
        if (this.getLog().isDebugEnabled()) {
            this.logIncludedDirectories(sources);
            this.logNonStandardLicenses(this.nonStandardLicenses);
            defaultFileInformation.logInfo();
            this.logFileSpecificInfo(pathSpecificInformation);
        }
        if (!"build".equals(this.sbomType)) {
            builder.collectSpdxFileInformation(sources, this.mavenProject.getBasedir().getAbsolutePath(), defaultFileInformation, pathSpecificInformation, this.getChecksumAlgorithms());
        }
        try {
            this.buildSpdxDependencyInformation(builder, outputFormatEnum);
        }
        catch (LicenseMapperException e1) {
            throw new MojoExecutionException("Error mapping licenses for dependencies", (Exception)e1);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new MojoExecutionException("SPDX analysis error processing dependencies", (Exception)((Object)e));
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("SPDX analysis error getting the dependencies", (Exception)((Object)e));
        }
        builder.saveSpdxDocumentToFile();
        this.projectHelper.attachArtifact(this.mavenProject, artifactType, this.spdxFile);
        List<String> spdxErrors = builder.verify();
        if (spdxErrors != null && !spdxErrors.isEmpty()) {
            this.getLog().warn((CharSequence)("The following errors were found in the SPDX file:\n " + String.join((CharSequence)"\n ", spdxErrors)));
        }
    }

    private OutputFormat prepareOutput() throws MojoExecutionException {
        File outputDir;
        OutputFormat outputFormatEnum = OutputFormat.JSON;
        try {
            outputFormatEnum = OutputFormat.getOutputFormat(this.outputFormat, this.spdxFile);
        }
        catch (IllegalArgumentException iae) {
            this.getLog().warn((CharSequence)"Invalid SPDX output format, defaulting to JSON format.");
        }
        if (this.spdxFile.getName().endsWith(".spdx")) {
            String spdxFileType = outputFormatEnum.getFileType();
            this.getLog().info((CharSequence)("spdx file type = " + spdxFileType));
            this.spdxFile = new File(this.spdxFile.getAbsolutePath() + spdxFileType);
        }
        if ((outputDir = this.spdxFile.getParentFile()) == null) {
            throw new MojoExecutionException("Invalid path for SPDX output file.  Specify a configuration parameter spdxFile with a valid directory path to resolve.");
        }
        outputDir.mkdirs();
        return outputFormatEnum;
    }

    private AbstractDocumentBuilder initSpdxDocumentBuilder(OutputFormat outputFormatEnum) throws MojoExecutionException {
        AbstractDocumentBuilder builder;
        if (this.onlyUseLocalLicenses) {
            System.setProperty("SPDXParser.OnlyUseLocalLicenses", "true");
        }
        if (this.defaultLicenseInformationInFile == null) {
            this.defaultLicenseInformationInFile = this.defaultFileConcludedLicense;
        }
        try {
            if (this.spdxDocumentNamespace.startsWith("http://spdx.org/spdxpackages/")) {
                this.spdxDocumentNamespace = this.spdxDocumentNamespace.replace(" ", "%20");
            }
            URI namespaceUri = new URI(this.spdxDocumentNamespace);
            builder = SpdxCoreConstants.SpdxMajorVersion.VERSION_3.equals((Object)outputFormatEnum.getSpecVersion()) ? new SpdxV3DocumentBuilder(this.mavenProject, this.generatePurls, this.spdxFile, namespaceUri, outputFormatEnum) : new SpdxV2DocumentBuilder(this.mavenProject, this.generatePurls, this.spdxFile, namespaceUri, outputFormatEnum);
        }
        catch (SpdxBuilderException e) {
            throw new MojoExecutionException("Error creating SPDX Document Builder", (Exception)((Object)e));
        }
        catch (LicenseMapperException e) {
            throw new MojoExecutionException("License mapping error creating SPDX Document Builder", (Exception)e);
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException("Invalid SPDX document namespace - not a valid URI: " + this.spdxDocumentNamespace, (Exception)e);
        }
        if (this.nonStandardLicenses != null) {
            try {
                builder.addNonStandardLicenses(this.nonStandardLicenses);
            }
            catch (SpdxBuilderException e) {
                throw new MojoExecutionException("Error adding non standard licenses", (Exception)((Object)e));
            }
        }
        return builder;
    }

    protected void buildSpdxDependencyInformation(AbstractDocumentBuilder builder, OutputFormat outputFormatEnum) throws LicenseMapperException, InvalidSPDXAnalysisException, DependencyGraphBuilderException {
        AbstractDependencyBuilder dependencyBuilder;
        SpdxDocument spdxDoc;
        AbstractDocumentBuilder documentBuilder;
        if (builder instanceof SpdxV3DocumentBuilder) {
            documentBuilder = (SpdxV3DocumentBuilder)builder;
            SpdxV3DependencyBuilder dependencyBuilderV3 = new SpdxV3DependencyBuilder((SpdxV3DocumentBuilder)documentBuilder, this.createExternalRefs, this.generatePurls, this.useArtifactID, this.includeTransitiveDependencies);
            if (this.licenseOverwrites != null) {
                spdxDoc = ((SpdxV3DocumentBuilder)documentBuilder).getSpdxDoc();
                for (LicenseOverwrite licenseOverwrite : this.licenseOverwrites) {
                    org.spdx.library.model.v3_0_1.simplelicensing.AnyLicenseInfo parsedLicense;
                    try {
                        parsedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)licenseOverwrite.getLicenseString(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getIdPrefix(), (IModelCopyManager)spdxDoc.getCopyManager(), null);
                    }
                    catch (InvalidLicenseStringException e) {
                        throw new InvalidLicenseStringException("Invalid license overwrite configuration for " + licenseOverwrite, (Throwable)e);
                    }
                    dependencyBuilderV3.addLicenseOverwrite(licenseOverwrite, parsedLicense);
                }
            }
            dependencyBuilder = dependencyBuilderV3;
        } else {
            documentBuilder = (SpdxV2DocumentBuilder)builder;
            SpdxV2DependencyBuilder dependencyBuilderV2 = new SpdxV2DependencyBuilder((SpdxV2DocumentBuilder)documentBuilder, this.createExternalRefs, this.generatePurls, this.useArtifactID, this.includeTransitiveDependencies);
            if (this.licenseOverwrites != null) {
                spdxDoc = ((SpdxV2DocumentBuilder)documentBuilder).getSpdxDoc();
                for (LicenseOverwrite licenseOverwrite : this.licenseOverwrites) {
                    AnyLicenseInfo parsedLicense;
                    try {
                        parsedLicense = LicenseInfoFactory.parseSPDXLicenseStringCompatV2((String)licenseOverwrite.getLicenseString(), (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (IModelCopyManager)spdxDoc.getCopyManager());
                    }
                    catch (InvalidLicenseStringException e) {
                        throw new InvalidLicenseStringException("Invalid license overwrite configuration for " + licenseOverwrite, (Throwable)e);
                    }
                    dependencyBuilderV2.addLicenseOverwrite(licenseOverwrite, parsedLicense);
                }
            }
            dependencyBuilder = dependencyBuilderV2;
        }
        if (this.session != null) {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            request.setProject(this.mavenProject);
            ArtifactFilter artifactFilter = this.getArtifactFilter();
            DependencyNode parentNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)request, artifactFilter);
            dependencyBuilder.addMavenDependencies(this.mavenProjectBuilder, this.session, this.mavenProject, parentNode, builder.getProjectPackage());
        }
    }

    private void logFileSpecificInfo(HashMap<String, SpdxDefaultFileInformation> fileSpecificInformation) {
        if (!this.getLog().isDebugEnabled()) {
            return;
        }
        for (Map.Entry<String, SpdxDefaultFileInformation> entry : fileSpecificInformation.entrySet()) {
            this.getLog().debug((CharSequence)("File Specific Information for " + entry.getKey()));
            entry.getValue().logInfo();
        }
    }

    private HashMap<String, SpdxDefaultFileInformation> getPathSpecificInfoFromParameters(SpdxDefaultFileInformation projectDefault) {
        HashMap<String, SpdxDefaultFileInformation> retval = new HashMap<String, SpdxDefaultFileInformation>();
        if (this.pathsWithSpecificSpdxInfo != null) {
            for (PathSpecificSpdxInfo spdxInfo : this.pathsWithSpecificSpdxInfo) {
                SpdxDefaultFileInformation value = spdxInfo.getDefaultFileInformation(projectDefault);
                if (retval.containsKey(spdxInfo.getPath())) {
                    this.getLog().warn((CharSequence)("Multiple file path specific SPDX data for " + spdxInfo.getPath()));
                }
                retval.put(spdxInfo.getPath(), value);
            }
        }
        return retval;
    }

    private void logNonStandardLicenses(NonStandardLicense[] nonStandardLicenses) {
        if (nonStandardLicenses == null || !this.getLog().isDebugEnabled()) {
            return;
        }
        for (NonStandardLicense nonStandardLicense : nonStandardLicenses) {
            this.getLog().debug((CharSequence)("Non standard license ID: " + nonStandardLicense.getLicenseId()));
            this.getLog().debug((CharSequence)("Non standard license Text: " + nonStandardLicense.getExtractedText()));
            this.getLog().debug((CharSequence)("Non standard license Comment: " + nonStandardLicense.getComment()));
            this.getLog().debug((CharSequence)("Non standard license Name: " + nonStandardLicense.getName()));
            String[] crossReferences = nonStandardLicense.getCrossReference();
            if (crossReferences == null) continue;
            for (String crossReference : crossReferences) {
                this.getLog().debug((CharSequence)("Non standard license cross reference: " + crossReference));
            }
        }
    }

    private void logIncludedDirectories(List<FileSet> includedDirectories) {
        if (includedDirectories == null || !this.getLog().isDebugEnabled()) {
            return;
        }
        this.getLog().debug((CharSequence)("Logging " + includedDirectories.size() + " filesets."));
        for (FileSet includedDirectory : includedDirectories) {
            List excludes;
            StringBuilder sb = new StringBuilder("Included Directory: " + includedDirectory.getDirectory());
            List includes = includedDirectory.getIncludes();
            if (!includes.isEmpty()) {
                sb.append("; Included=");
                sb.append(String.join((CharSequence)",", includes));
            }
            if (!(excludes = includedDirectory.getExcludes()).isEmpty()) {
                sb.append("; Excluded=");
                sb.append(String.join((CharSequence)",", excludes));
            }
            this.getLog().debug((CharSequence)sb.toString());
        }
    }

    private SpdxDefaultFileInformation getDefaultFileInfoFromParameters() {
        SpdxDefaultFileInformation retval = new SpdxDefaultFileInformation();
        retval.setComment(this.defaultFileComment);
        retval.setConcludedLicense(this.defaultFileConcludedLicense.trim());
        retval.setContributors(this.defaultFileContributors);
        retval.setCopyright(this.defaultFileCopyright);
        retval.setDeclaredLicense(this.defaultLicenseInformationInFile.trim());
        retval.setLicenseComment(this.defaultFileLicenseComment);
        retval.setNotice(this.defaultFileNotice);
        return retval;
    }

    private SpdxProjectInformation getSpdxProjectInfoFromParameters(AbstractDocumentBuilder builder) throws InvalidSPDXAnalysisException {
        Date createdDate;
        Object supplier;
        String declaredLicense;
        SpdxProjectInformation retval = new SpdxProjectInformation();
        if (this.documentComment != null) {
            retval.setDocumentComment(this.documentComment);
        }
        if (this.licenseDeclared == null) {
            List mavenLicenses = this.mavenProject.getLicenses();
            try {
                declaredLicense = builder.mavenLicenseListToSpdxLicenseExpression(mavenLicenses);
            }
            catch (LicenseManagerException e) {
                this.getLog().warn((CharSequence)"Unable to map maven licenses to a declared license.  Using NOASSERTION");
                declaredLicense = "NOASSERTION";
            }
        } else {
            declaredLicense = this.licenseDeclared.trim();
        }
        String concludedLicense = this.licenseConcluded == null ? declaredLicense : this.licenseConcluded.trim();
        retval.setConcludedLicense(concludedLicense);
        retval.setCreatorComment(this.creatorComment);
        if (this.creators == null) {
            this.creators = new String[0];
        }
        String[] allCreators = Arrays.copyOf(this.creators, this.creators.length + 1);
        allCreators[allCreators.length - 1] = CREATOR_TOOL_MAVEN_PLUGIN;
        retval.setCreators(allCreators);
        retval.setCopyrightText(this.copyrightText);
        retval.setDeclaredLicense(declaredLicense);
        String projectName = this.mavenProject.getName();
        if (projectName == null || projectName.isEmpty() || this.useArtifactID) {
            projectName = this.getDefaultProjectName();
        }
        retval.setName(projectName);
        retval.setDescription(this.mavenProject.getDescription());
        String downloadUrl = "NOASSERTION";
        DistributionManagement distributionManager = this.mavenProject.getDistributionManagement();
        if (distributionManager != null && distributionManager.getDownloadUrl() != null && !distributionManager.getDownloadUrl().isEmpty()) {
            downloadUrl = distributionManager.getDownloadUrl();
        }
        retval.setDownloadUrl(downloadUrl);
        retval.setHomePage(this.mavenProject.getUrl());
        retval.setLicenseComment(this.licenseComments);
        if (this.originator == null && this.mavenProject.getOrganization() != null && this.mavenProject.getOrganization().getName() != null && !this.mavenProject.getOrganization().getName().isEmpty()) {
            this.originator = "Organization:" + this.mavenProject.getOrganization().getName();
        }
        retval.setOriginator(this.originator);
        Object packageFileName = null;
        File packageFile = null;
        Artifact mainArtifact = this.mavenProject.getArtifact();
        if (mainArtifact != null && mainArtifact.getFile() != null) {
            packageFileName = mainArtifact.getArtifactId() + "-" + mainArtifact.getVersion() + "." + mainArtifact.getType();
            packageFile = new File(mainArtifact.getFile().getParent() + File.separator + (String)packageFileName);
        }
        Set<Checksum> checksums = null;
        if (packageFile != null && packageFile.exists()) {
            try {
                this.getLog().debug((CharSequence)("Generating checksum for file " + packageFile.getAbsolutePath()));
                Set<String> algorithms = this.getChecksumAlgorithms();
                checksums = AbstractFileCollector.generateChecksum(packageFile, algorithms);
            }
            catch (InvalidSPDXAnalysisException | SpdxCollectionException e) {
                this.getLog().warn((CharSequence)("Unable to compute checksum for " + packageFile.getName() + ":" + e.getMessage()));
                this.getLog().debug((CharSequence)"Exception information for checksum error", e);
            }
        } else {
            this.getLog().warn((CharSequence)(packageFile == null ? "Null package file" : "Package file " + packageFile.getAbsolutePath() + " does not exist"));
            packageFileName = "NOASSERTION";
        }
        retval.setPackageArchiveFileName((String)packageFileName);
        retval.setChecksums(checksums);
        retval.setShortDescription(this.mavenProject.getDescription());
        if (this.mavenProject.getOrganization() != null && (supplier = this.mavenProject.getOrganization().getName()) != null && !((String)supplier).isEmpty()) {
            supplier = "Organization: " + (String)supplier;
            retval.setSupplier((String)supplier);
        }
        retval.setSourceInfo(this.sourceInfo);
        retval.setVersionInfo(this.mavenProject.getVersion());
        retval.setDocumentAnnotations(this.documentAnnotations);
        retval.setPackageAnnotations(this.packageAnnotations);
        retval.setExternalRefs(this.externalReferences);
        Packaging packaging = Packaging.valueOfPackaging(this.mavenProject.getPackaging());
        retval.setPackaging(packaging != null ? packaging : Packaging.JAR);
        if (this.created == null || this.created.isEmpty()) {
            this.created = this.mavenProject.getModel().getProperties().getProperty("project.build.outputTimestamp");
        }
        if (this.created == null || this.created.isEmpty()) {
            createdDate = new Date();
        } else if (this.created.matches("\\d+")) {
            createdDate = new Date(Long.parseLong(this.created) * 1000L);
        } else {
            try {
                createdDate = Date.from(Instant.parse(this.created));
            }
            catch (DateTimeParseException ex) {
                this.getLog().warn((CharSequence)("Invalid created date " + this.created + ".  Using current date-time"));
                createdDate = new Date();
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        retval.setCreated(dateFormat.format(createdDate));
        return retval;
    }

    private String getDefaultProjectName() {
        return this.mavenProject.getGroupId() + ":" + this.mavenProject.getArtifactId();
    }

    private static List<FileSet> toFileSet(List<String> roots, List<Resource> resources) {
        File dir;
        FileSet fileSet;
        ArrayList<FileSet> result = new ArrayList<FileSet>();
        if (roots != null) {
            for (String root : roots) {
                fileSet = new FileSet();
                dir = new File(root);
                fileSet.setDirectory(dir.getAbsolutePath());
                fileSet.addInclude(INCLUDE_ALL);
                result.add(fileSet);
            }
        }
        if (resources != null) {
            for (Resource resource : resources) {
                fileSet = new FileSet();
                dir = new File(resource.getDirectory());
                fileSet.setDirectory(dir.getAbsolutePath());
                fileSet.setExcludes(resource.getExcludes());
                fileSet.setIncludes(resource.getIncludes());
                result.add(fileSet);
            }
        }
        return result;
    }

    private Set<String> getChecksumAlgorithms() {
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.add("SHA1");
        if (this.checksumAlgorithms != null) {
            Collections.addAll(algorithms, this.checksumAlgorithms);
        }
        return algorithms;
    }

    private ArtifactFilter getArtifactFilter() {
        this.getLog().debug((CharSequence)"Creating Artifact filter");
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.includeCompileScope) {
            scopes.add("compile");
        }
        if (this.includeProvidedScope) {
            scopes.add("provided");
        }
        if (this.includeRuntimeScope) {
            scopes.add("runtime");
        }
        if (this.includeSystemScope) {
            scopes.add("system");
        }
        if (this.includeTestScope) {
            scopes.add("test");
        }
        this.getLog().debug((CharSequence)((Object)scopes).toString());
        return new CumulativeScopeArtifactFilter(scopes);
    }

    static {
        SpdxModelFactory.init();
    }
}

