/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.spdx.core.CoreModelObject;
import org.spdx.library.ModelCopyManager;
import org.spdx.maven.NonStandardLicense;
import org.spdx.maven.OutputFormat;
import org.spdx.maven.utils.LicenseManagerException;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.maven.utils.SpdxDefaultFileInformation;
import org.spdx.maven.utils.SpdxProjectInformation;
import org.spdx.storage.ISerializableModelStore;

public abstract class AbstractDocumentBuilder {
    protected static final String UNSPECIFIED = "UNSPECIFIED";
    public static final String NULL_SHA1 = "cf23df2207d99a74fbe169e3eba035e633b65d94";
    protected MavenProject project;
    protected boolean generatePurls;
    protected File spdxFile;
    protected OutputFormat outputFormatEnum;
    protected ISerializableModelStore modelStore;
    protected ModelCopyManager copyManager;
    protected DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public AbstractDocumentBuilder(MavenProject project, boolean generatePurls, File spdxFile, OutputFormat outputFormatEnum) throws SpdxBuilderException {
        this.project = project;
        this.generatePurls = generatePurls;
        this.spdxFile = spdxFile;
        this.outputFormatEnum = outputFormatEnum;
        this.copyManager = new ModelCopyManager();
        if (!spdxFile.exists()) {
            File parentDir = spdxFile.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                throw new SpdxBuilderException("Unable to create directories for SPDX file");
            }
            try {
                if (!spdxFile.createNewFile()) {
                    throw new SpdxBuilderException("Unable to create the SPDX file");
                }
            }
            catch (IOException e) {
                throw new SpdxBuilderException("IO error creating the SPDX file", e);
            }
        }
        if (!spdxFile.canWrite()) {
            throw new SpdxBuilderException("Unable to write to SPDX file - check permissions: " + spdxFile.getPath());
        }
    }

    public abstract void fillSpdxDocumentInformation(SpdxProjectInformation var1) throws SpdxBuilderException;

    public abstract void collectSpdxFileInformation(List<FileSet> var1, String var2, SpdxDefaultFileInformation var3, HashMap<String, SpdxDefaultFileInformation> var4, Set<String> var5) throws SpdxBuilderException;

    public abstract void saveSpdxDocumentToFile() throws SpdxBuilderException;

    public abstract void addNonStandardLicenses(NonStandardLicense[] var1) throws SpdxBuilderException;

    public abstract CoreModelObject getProjectPackage();

    public abstract String mavenLicenseListToSpdxLicenseExpression(List<License> var1) throws LicenseManagerException;

    public abstract List<String> verify();
}

