/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.maven.Annotation;
import org.spdx.maven.Checksum;
import org.spdx.maven.ExternalReference;
import org.spdx.maven.Packaging;

public class SpdxProjectInformation {
    private static final Logger LOG = LoggerFactory.getLogger(SpdxProjectInformation.class);
    private String[] creators = new String[0];
    private String creatorComment = "";
    private String concludedLicense = "NOASSERTION";
    private String declaredLicense = "NOASSERTION";
    private String description;
    private String downloadUrl;
    private String homePage;
    private String shortDescription;
    private String originator;
    private String supplier;
    private String packageArchiveFileName;
    private String versionInfo;
    private String licenseComment;
    private String name;
    private String sourceInfo;
    private String copyrightText;
    private String documentComment;
    private Annotation[] packageAnnotations;
    private Annotation[] documentAnnotations;
    private ExternalReference[] externalRefs;
    private Set<Checksum> checksums;
    private Packaging packaging;
    private String created;

    public Packaging getPackaging() {
        return this.packaging;
    }

    public void setPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    public String getDocumentComment() {
        return this.documentComment;
    }

    public void setDocumentComment(String documentComment) {
        this.documentComment = documentComment;
    }

    public Set<Checksum> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(Set<Checksum> checksums) {
        this.checksums = checksums;
    }

    public String getConcludedLicense() {
        return this.concludedLicense;
    }

    public void setConcludedLicense(String concludedLicense) {
        this.concludedLicense = concludedLicense;
    }

    public String getDeclaredLicense() {
        return this.declaredLicense;
    }

    public void setDeclaredLicense(String declaredLicense) {
        this.declaredLicense = declaredLicense;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getPackageArchiveFileName() {
        return this.packageArchiveFileName;
    }

    public void setPackageArchiveFileName(String packageArchiveFileName) {
        this.packageArchiveFileName = packageArchiveFileName;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }

    public String getLicenseComment() {
        return this.licenseComment;
    }

    public void setLicenseComment(String licenseComment) {
        this.licenseComment = licenseComment;
    }

    public String[] getCreators() {
        return this.creators;
    }

    public void setCreators(String[] creators) {
        this.creators = creators;
    }

    public String getCreatorComment() {
        return this.creatorComment;
    }

    public void setCreatorComment(String creatorComment) {
        this.creatorComment = creatorComment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void logInfo() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("SPDX Project Name: {}", (Object)this.getName());
        LOG.debug("SPDX Document comment: {}", (Object)this.getDocumentComment());
        LOG.debug("SPDX Creator comment: {}", (Object)this.getCreatorComment());
        LOG.debug("SPDX Description: {}", (Object)this.getDescription());
        LOG.debug("SPDX License comment: {}", (Object)this.getLicenseComment());
        LOG.debug("SPDX Originator: {}", (Object)this.getOriginator());
        LOG.debug("SPDX PackageArchiveFileName: {}", (Object)this.getPackageArchiveFileName());
        LOG.debug("SPDX Short description: {}", (Object)this.getShortDescription());
        LOG.debug("SPDX Supplier: {}", (Object)this.getSupplier());
        LOG.debug("SPDX Source Info:  {}", (Object)this.getSourceInfo());
        LOG.debug("SPDX Version info: {}", (Object)this.getVersionInfo());
        LOG.debug("SPDX Concluded license: {}", (Object)this.getConcludedLicense());
        LOG.debug("SPDX Declared license: {}", (Object)this.getDeclaredLicense());
        LOG.debug("SPDX Download URL: {}", (Object)this.getDownloadUrl());
        LOG.debug("SPDX Home page: {}", (Object)this.getHomePage());
        LOG.debug("SPDX Created: {}", (Object)this.getCreated());
        if (this.documentAnnotations != null && this.documentAnnotations.length > 0) {
            LOG.debug("Document annotations: ");
            for (Annotation annotation : this.documentAnnotations) {
                annotation.logInfo();
            }
        }
        if (this.packageAnnotations != null && this.packageAnnotations.length > 0) {
            LOG.debug("Package annotations: ");
            for (Annotation annotation : this.packageAnnotations) {
                annotation.logInfo();
            }
        }
        if (this.creators != null) {
            for (String string : this.creators) {
                LOG.debug("SPDX Creator: {}", (Object)string);
            }
        }
        if (this.externalRefs != null) {
            for (ExternalReference externalReference : this.externalRefs) {
                LOG.debug("External Ref: {} {} {}", new Object[]{externalReference.getCategory(), externalReference.getType(), externalReference.getLocator()});
            }
        }
        if (this.checksums != null && !this.checksums.isEmpty()) {
            for (Checksum checksum : this.checksums) {
                LOG.debug("SPDX {}: {}", (Object)checksum.getAlgorithm(), (Object)checksum.getValue());
            }
        }
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInformation) {
        this.sourceInfo = sourceInformation;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public void setPackageAnnotations(Annotation[] packageAnnotations) {
        this.packageAnnotations = packageAnnotations;
    }

    public Annotation[] getPackageAnnotations() {
        return this.packageAnnotations;
    }

    public void setDocumentAnnotations(Annotation[] documentAnnotations) {
        this.documentAnnotations = documentAnnotations;
    }

    public Annotation[] getDocumentAnnotations() {
        return this.documentAnnotations;
    }

    public void setExternalRefs(ExternalReference[] externalReferences) {
        this.externalRefs = externalReferences;
    }

    public ExternalReference[] getExternalRefs() {
        return this.externalRefs;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getCreated() {
        return this.created;
    }
}

