/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.listeners.StatementListener;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelChangedListener;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.SpdxInvalidIdException;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.enumerations.SpdxEnumFactory;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.spdxRdfStore.MissingDataTypeAndClassRestriction;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.spdxRdfStore.SpdxOwlOntology;
import org.spdx.spdxRdfStore.SpdxRdfException;
import org.spdx.spdxRdfStore.SpdxResourceFactory;
import org.spdx.storage.IModelStore;

public class RdfSpdxDocumentModelManager
implements IModelStore.IModelStoreLock {
    static final Logger logger = LoggerFactory.getLogger((String)RdfSpdxDocumentModelManager.class.getName());
    static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    static final Set<String> LISTED_LICENSE_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(SpdxConstants.LISTED_LICENSE_URI_CLASSES)));
    private static final String HTTPS_LISTED_LICENSE_NAMESPACE_PREFIX = "http://spdx.org/licenses/".replaceAll("http:", "https:");
    private static final CharSequence SPDX_LISTED_LICENSE_SUBPREFIX = "://spdx.org/licenses/";
    private ReadWriteLock counterLock = new ReentrantReadWriteLock();
    private NextIdListener nextIdListener = new NextIdListener();
    private String documentUri;
    private Model model;
    private Map<String, String> idCaseSensitiveMap = new HashMap<String, String>();
    private int nextNextSpdxId = 1;
    private int nextNextDocumentId = 1;
    private int nextNextLicenseId = 1;
    private Property typeProperty;
    private String documentNamespace;

    public RdfSpdxDocumentModelManager(String documentUri, Model model) {
        Objects.requireNonNull(documentUri, "Missing required document URI");
        Objects.requireNonNull(model, "Missing required model");
        this.documentUri = documentUri;
        this.documentNamespace = documentUri + "#";
        this.model = model;
        this.typeProperty = model.createProperty(RDF_TYPE);
        model.register((ModelChangedListener)this.nextIdListener);
        this.updateCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkUpdateNextSpdxId(Matcher spdxRefMatcher) {
        this.counterLock.writeLock().lock();
        try {
            String strNum = spdxRefMatcher.group(1);
            int num = Integer.parseInt(strNum);
            if (num >= this.nextNextSpdxId) {
                this.nextNextSpdxId = num + 1;
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    private int getNextSpdxId() {
        this.counterLock.writeLock().lock();
        try {
            int n = this.nextNextSpdxId++;
            return n;
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkUpdateNextDocumentId(Matcher documentRefMatcher) {
        this.counterLock.writeLock().lock();
        try {
            String strNum = documentRefMatcher.group(1);
            int num = Integer.parseInt(strNum);
            if (num >= this.nextNextDocumentId) {
                this.nextNextDocumentId = num + 1;
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    private int getNextDocumentId() {
        this.counterLock.writeLock().lock();
        try {
            int n = this.nextNextDocumentId++;
            return n;
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkUpdateLicenseId(Matcher licenseRefMatcher) {
        this.counterLock.writeLock().lock();
        try {
            String strNum = licenseRefMatcher.group(1);
            int num = Integer.parseInt(strNum);
            if (num >= this.nextNextLicenseId) {
                this.nextNextLicenseId = num + 1;
            }
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    private int getNextLicenseId() {
        this.counterLock.writeLock().lock();
        try {
            int n = this.nextNextLicenseId++;
            return n;
        }
        finally {
            this.counterLock.writeLock().unlock();
        }
    }

    private synchronized void checkRemoveId(RDFNode node) {
        String id;
        Objects.requireNonNull(node);
        if (node.isResource() && !this.model.containsResource(node) && !node.isAnon() && ((id = node.asResource().getLocalName()).startsWith(SpdxConstants.EXTERNAL_DOC_REF_PRENUM) || id.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM) || id.startsWith(SpdxConstants.SPDX_ELEMENT_REF_PRENUM))) {
            this.idCaseSensitiveMap.remove(id.toLowerCase());
        }
    }

    private void checkAddNewId(RDFNode node) {
        Objects.requireNonNull(node);
        if (node.isResource()) {
            Matcher licenseRefMatcher;
            String previous;
            if (node.isAnon()) {
                return;
            }
            String id = node.asResource().getLocalName();
            if (Objects.isNull(id)) {
                return;
            }
            if ((id.startsWith(SpdxConstants.EXTERNAL_DOC_REF_PRENUM) || id.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM) || id.startsWith(SpdxConstants.SPDX_ELEMENT_REF_PRENUM)) && Objects.nonNull(previous = this.idCaseSensitiveMap.put(id.toLowerCase(), id))) {
                logger.warn("Possibly ambiguous ID being introduced.  " + previous + " is being replaced by " + id);
            }
            if ((licenseRefMatcher = SpdxConstants.LICENSE_ID_PATTERN_NUMERIC.matcher(id)).matches()) {
                this.checkUpdateLicenseId(licenseRefMatcher);
                return;
            }
            Matcher documentIdMatcher = RdfStore.DOCUMENT_ID_PATTERN_NUMERIC.matcher(id);
            if (documentIdMatcher.matches()) {
                this.checkUpdateNextDocumentId(documentIdMatcher);
                return;
            }
            Matcher spdxIdMatcher = RdfStore.SPDX_ID_PATTERN_NUMERIC.matcher(id);
            if (spdxIdMatcher.matches()) {
                this.checkUpdateNextSpdxId(spdxIdMatcher);
                return;
            }
        }
    }

    private void updateCounters() {
        this.model.enterCriticalSection(true);
        try {
            ResIterator iter = this.model.listSubjects();
            while (iter.hasNext()) {
                this.checkAddNewId((RDFNode)iter.next());
            }
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String id) {
        Objects.requireNonNull(id, "Missing required ID");
        this.model.enterCriticalSection(true);
        try {
            Resource resource;
            if (this.isAnonId(id)) {
                try {
                    resource = this.model.createResource(this.idToAnonId(id));
                }
                catch (SpdxInvalidIdException e) {
                    logger.error("Error getting anonymous ID", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                resource = ResourceFactory.createResource((String)this.idToUriInDocument(id));
                if (!this.model.containsResource((RDFNode)resource)) {
                    resource = ResourceFactory.createResource((String)("http://spdx.org/licenses/" + id));
                }
                if (!this.model.containsResource((RDFNode)resource)) {
                    resource = ResourceFactory.createResource((String)(HTTPS_LISTED_LICENSE_NAMESPACE_PREFIX + id));
                }
            }
            Statement statement = this.model.getProperty(resource.asResource(), this.typeProperty);
            boolean bl = Objects.nonNull(statement) && Objects.nonNull(statement.getObject());
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private Resource idToResource(String id) throws SpdxInvalidIdException {
        Resource resource;
        Objects.requireNonNull(id, "Missing required ID");
        Optional<Object> existingType = Optional.empty();
        if (this.isAnonId(id)) {
            resource = this.model.createResource(this.idToAnonId(id));
        } else {
            resource = this.model.createResource(this.idToUriInDocument(id));
            if (this.model.containsResource((RDFNode)resource)) {
                Statement statement = this.model.getProperty(resource, this.typeProperty);
                if (statement == null || !statement.getObject().isResource()) {
                    logger.error("ID " + id + " does not have a type.");
                    throw new SpdxInvalidIdException("ID " + id + " does not have a type.");
                }
                existingType = SpdxResourceFactory.resourceToSpdxType(statement.getObject().asResource());
                if (!existingType.isPresent()) {
                    logger.error("ID " + id + " does not have a type.");
                    throw new SpdxInvalidIdException("ID " + id + " does not have a type.");
                }
            } else {
                resource = this.model.createResource("http://spdx.org/licenses/" + id);
                if (!this.model.containsResource((RDFNode)resource)) {
                    resource = this.model.createResource(HTTPS_LISTED_LICENSE_NAMESPACE_PREFIX + id);
                }
                if (!(this.model.containsResource((RDFNode)resource) || ListedLicenses.getListedLicenses().isSpdxListedExceptionId(id) || ListedLicenses.getListedLicenses().isSpdxListedLicenseId(id))) {
                    try {
                        if (!ListedReferenceTypes.getListedReferenceTypes().isListedReferenceType(new URI("http://spdx.org/rdf/references/" + id))) {
                            logger.error("ID " + id + " does not exist in the model.");
                            throw new SpdxInvalidIdException("ID " + id + " does not exist in the model.");
                        }
                    }
                    catch (URISyntaxException e) {
                        logger.error("ID " + id + " does not exist in the model.");
                        throw new SpdxInvalidIdException("ID " + id + " does not exist in the model.");
                    }
                }
            }
        }
        return resource;
    }

    private String idToUriInDocument(String id) {
        try {
            return this.documentUri + "#" + URLEncoder.encode(id, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return this.documentUri + "#" + id;
        }
    }

    private AnonId idToAnonId(String id) throws SpdxInvalidIdException {
        Matcher matcher = RdfStore.ANON_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            logger.error(id + " is not a valid Anonymous ID");
            throw new SpdxInvalidIdException(id + " is not a valid Anonymous ID");
        }
        String anon = matcher.group(1);
        return new AnonId(anon);
    }

    private boolean isAnonId(String id) {
        return RdfStore.ANON_ID_PATTERN.matcher(id).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource getOrCreate(String id, String type) throws SpdxInvalidIdException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(type, "Missing required type");
        Resource rdfType = SpdxResourceFactory.typeToResource(type);
        this.model.enterCriticalSection(false);
        try {
            if (LISTED_LICENSE_CLASSES.contains(type)) {
                Resource resource = this.model.createResource("http://spdx.org/licenses/" + id, rdfType);
                return resource;
            }
            if (this.isAnonId(id)) {
                Resource retval = this.model.createResource(this.idToAnonId(id));
                retval.addProperty(this.typeProperty, (RDFNode)rdfType);
                Resource resource = retval;
                return resource;
            }
            Resource resource = this.model.createResource(this.idToUriInDocument(id), rdfType);
            return resource;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPropertyValueNames(String id) throws SpdxInvalidIdException {
        Objects.requireNonNull(id, "Missing required ID");
        HashSet retval = new HashSet();
        this.model.enterCriticalSection(true);
        try {
            Resource idResource = this.idToResource(id);
            idResource.listProperties().forEachRemaining(action -> {
                try {
                    if (Objects.nonNull(action.getPredicate()) && !RDF_TYPE.equals(action.getPredicate().getURI())) {
                        retval.add(RdfSpdxDocumentModelManager.resourceToPropertyName((RDFNode)action.getPredicate()));
                    }
                }
                catch (SpdxRdfException e) {
                    logger.warn("Skipping invalid property " + action.getObject().toString(), (Throwable)((Object)e));
                }
            });
            List<String> list = Collections.unmodifiableList(new ArrayList(retval));
            return list;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    protected static String resourceToPropertyName(RDFNode node) throws SpdxRdfException {
        Objects.requireNonNull(node, "Missing required node");
        if (node.isAnon()) {
            logger.error("Attempting to convert an anonymous node to a property name");
            throw new SpdxRdfException("Can not convert an anonymous node into a property name.");
        }
        if (node.isLiteral()) {
            logger.error("Attempting to convert an literal node to a property name: " + node.toString());
            throw new SpdxRdfException("Can not convert a literal node into a property name.");
        }
        String localName = node.asResource().getLocalName();
        if (SpdxOwlOntology.OWL_PROPERTY_TO_RENAMED_PROPERTY.containsKey(localName)) {
            return SpdxOwlOntology.OWL_PROPERTY_TO_RENAMED_PROPERTY.get(localName);
        }
        return node.asResource().getLocalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Missing required value");
        this.model.enterCriticalSection(false);
        try {
            if ("documentNamespace".equals(propertyName)) {
                this.setDefaultNsPrefix(value);
            } else {
                Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
                Resource idResource = this.idToResource(id);
                idResource.removeAll(property);
                idResource.addProperty(property, this.valueToNode(value));
            }
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private void setDefaultNsPrefix(Object oUri) throws SpdxRdfException {
        Objects.requireNonNull(oUri, "Can not set NS prefix to null");
        if (oUri instanceof URI) {
            this.model.setNsPrefix("", ((URI)oUri).toString());
        } else if (oUri instanceof String) {
            try {
                URI uri = new URI((String)oUri);
                this.model.setNsPrefix("", uri.toString());
            }
            catch (Exception ex) {
                logger.error("Invalid URI provided for model default namespace.", (Throwable)ex);
                throw new SpdxRdfException("Invalid URI provided for model default namespace.", ex);
            }
        } else {
            logger.error("Invalid type for URI provided for model default namespace: " + oUri.getClass().toString());
            throw new SpdxRdfException("Invalid type for URI provided for model default namespace: " + oUri.getClass().toString());
        }
    }

    private RDFNode valueToNode(Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(value, "Missing required value");
        if (value instanceof Boolean || value instanceof String || value instanceof Integer) {
            return this.model.createTypedLiteral(value);
        }
        if (value instanceof TypedValue) {
            TypedValue tv = (TypedValue)value;
            return this.getOrCreate(tv.getId(), tv.getType());
        }
        if (value instanceof IndividualUriValue) {
            return this.model.createResource(((IndividualUriValue)value).getIndividualURI());
        }
        logger.error("Value type " + value.getClass().getName() + " not supported.");
        throw new SpdxInvalidTypeException("Value type " + value.getClass().getName() + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object> getPropertyValue(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        this.model.enterCriticalSection(true);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            NodeIterator iter = this.model.listObjectsOfProperty(idResource, property);
            if (!iter.hasNext()) {
                Optional<Object> optional = Optional.empty();
                return optional;
            }
            Optional<Object> result = this.valueNodeToObject(iter.next(), property);
            if (iter.hasNext()) {
                logger.error("Error getting single value.  Multiple values for property " + propertyName + " ID " + id + ".");
                throw new SpdxRdfException("Error getting single value.  Multiple values for property " + propertyName + " ID " + id + ".");
            }
            Optional<Object> optional = result;
            return optional;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private Optional<Object> valueNodeToObject(RDFNode propertyValue, Property property) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(propertyValue)) {
            return Optional.empty();
        }
        if (propertyValue.isLiteral()) {
            return this.literalNodeToObject(propertyValue.asLiteral().getValue(), property);
        }
        Resource valueType = propertyValue.asResource().getPropertyResourceValue(RDF.type);
        Optional<Object> sValueType = Objects.nonNull(valueType) ? SpdxResourceFactory.resourceToSpdxType(valueType) : Optional.empty();
        if (sValueType.isPresent()) {
            if (propertyValue.isURIResource() && ("ReferenceType".equals(sValueType.get()) || !this.documentNamespace.equals(propertyValue.asResource().getNameSpace()) && SpdxConstants.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(propertyValue.asResource().getURI()).matches())) {
                return Optional.of(new SimpleUriValue(propertyValue.asResource().getURI()));
            }
            if ("License".equals(sValueType.get())) {
                sValueType = Optional.of("ListedLicense");
            }
            return Optional.of(new TypedValue(this.resourceToId(propertyValue.asResource()), (String)sValueType.get()));
        }
        if (propertyValue.isURIResource()) {
            final String propertyUri = propertyValue.asResource().getURI();
            if (propertyUri.contains(SPDX_LISTED_LICENSE_SUBPREFIX) && !propertyUri.endsWith(SpdxConstants.NONE_VALUE) && !propertyUri.endsWith(SpdxConstants.NOASSERTION_VALUE)) {
                return Optional.of(new TypedValue(this.resourceToId(propertyValue.asResource()), "ListedLicense"));
            }
            IndividualUriValue iv = new IndividualUriValue(){

                public String getIndividualURI() {
                    return propertyUri;
                }
            };
            return Optional.of(iv);
        }
        logger.error("Invalid resource type for value.  Must be a typed value, literal value or a URI Resource");
        throw new SpdxRdfException("Invalid resource type for value.  Must be a typed value, literal value or a URI Resource");
    }

    private Optional<Object> literalNodeToObject(Object literalValue, Property property) throws InvalidSPDXAnalysisException {
        if (literalValue instanceof String) {
            Optional<Class<? extends Object>> propertyClass = SpdxOwlOntology.getSpdxOwlOntology().getPropertyClass(property);
            if (propertyClass.isPresent()) {
                if (Integer.class.equals(propertyClass.get())) {
                    try {
                        return Optional.of(Integer.parseInt((String)literalValue));
                    }
                    catch (NumberFormatException ex) {
                        throw new InvalidSPDXAnalysisException("Invalid integer format for property " + property.toString(), (Throwable)ex);
                    }
                }
                if (Boolean.class.equals(propertyClass.get())) {
                    try {
                        return Optional.of(Boolean.valueOf((String)literalValue));
                    }
                    catch (Exception ex) {
                        throw new InvalidSPDXAnalysisException("Invalid boolean format for property " + property.toString(), (Throwable)ex);
                    }
                }
                return Optional.of(literalValue);
            }
            return Optional.of(literalValue);
        }
        return Optional.of(literalValue);
    }

    private String resourceToId(Resource resource) throws SpdxRdfException {
        Objects.requireNonNull(resource, "Mising required resource");
        if (resource.isAnon()) {
            return "__anon__" + resource.getId();
        }
        if (resource.isURIResource()) {
            String retval = resource.getURI().contains("%") ? (resource.getURI().contains("#") ? resource.getURI().substring(resource.getURI().lastIndexOf(35) + 1) : resource.getURI().substring(resource.getURI().lastIndexOf(47) + 1)) : resource.getLocalName();
            try {
                retval = URLDecoder.decode(retval, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unexpected URL decoding error for: " + resource.toString());
                throw new SpdxRdfException("Unexpected URL decoding error");
            }
            return retval;
        }
        logger.error("Attempting to convert unsupported resource type to an ID: " + resource.toString());
        throw new SpdxRdfException("Only anonymous and URI resources can be converted to an ID");
    }

    public String getNextId(IModelStore.IdType idType) throws InvalidSPDXAnalysisException {
        switch (idType) {
            case Anonymous: {
                return "__anon__" + String.valueOf(this.model.createResource().getId());
            }
            case LicenseRef: {
                return SpdxConstants.NON_STD_LICENSE_ID_PRENUM + String.valueOf(this.getNextLicenseId());
            }
            case DocumentRef: {
                return SpdxConstants.EXTERNAL_DOC_REF_PRENUM + String.valueOf(this.getNextDocumentId());
            }
            case SpdxId: {
                return SpdxConstants.SPDX_ELEMENT_REF_PRENUM + String.valueOf(this.getNextSpdxId());
            }
            case ListedLicense: {
                logger.error("Can not generate a license ID for a Listed License");
                throw new InvalidSPDXAnalysisException("Can not generate a license ID for a Listed License");
            }
            case Literal: {
                logger.error("Can not generate a license ID for a Literal");
                throw new InvalidSPDXAnalysisException("Can not generate a license ID for a Literal");
            }
        }
        logger.error("Unknown ID type for next ID: " + idType.toString());
        throw new InvalidSPDXAnalysisException("Unknown ID type for next ID: " + idType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing require ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            this.model.removeAll(idResource, property, null);
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public Stream<TypedValue> getAllItems(@Nullable String typeFilter) {
        String query = "SELECT ?s ?type  WHERE { ?s  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>  ?type }";
        QueryExecution qe = QueryExecutionFactory.create((String)query, (Model)this.model);
        ResultSet result = qe.execSelect();
        Stream<QuerySolution> querySolutionStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 272), false).filter(qs -> {
            Optional<String> sType;
            RDFNode subject = qs.get("s");
            RDFNode type = qs.get("type");
            if (type.isResource() && subject.isResource() && (!subject.isURIResource() || subject.asResource().getURI().startsWith(this.documentNamespace)) && (sType = SpdxResourceFactory.resourceToSpdxType(type.asResource())).isPresent()) {
                if (Objects.isNull(typeFilter)) {
                    return true;
                }
                return typeFilter.equals(sType.get());
            }
            return false;
        });
        return (Stream)querySolutionStream.map(qs -> {
            RDFNode subject = qs.get("s");
            RDFNode type = qs.get("type");
            try {
                return new TypedValue(this.resourceToId(subject.asResource()), SpdxResourceFactory.resourceToSpdxType(type.asResource()).get());
            }
            catch (Exception e) {
                logger.error("Unexpected exception converting to type");
                throw new RuntimeException(e);
            }
        }).onClose(() -> qe.close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValueFromCollection(String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Mising required value");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            RDFNode rdfValue = this.valueToNode(value);
            if (this.model.contains(idResource, property, rdfValue)) {
                this.model.removeAll(idResource, property, rdfValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int collectionSize(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        this.model.enterCriticalSection(true);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            int n = this.model.listObjectsOfProperty(idResource, property).toList().size();
            return n;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectionContains(String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Missing required value");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            RDFNode rdfValue = this.valueToNode(value);
            boolean bl = this.model.contains(idResource, property, rdfValue);
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearValueCollection(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        this.model.enterCriticalSection(true);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            this.model.removeAll(idResource, property, null);
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValueToCollection(String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(value, "Missing required value");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            RDFNode nodeValue = this.valueToNode(value);
            if (this.model.contains(idResource, property, nodeValue)) {
                boolean bl = false;
                return bl;
            }
            this.model.add(idResource, property, nodeValue);
            boolean bl = true;
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    public Iterator<Object> getValueList(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Resource idResource = this.idToResource(id);
        Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
        return new RdfListIterator(idResource, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAssignableTo(String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(clazz, "Missing required class parameter");
        this.model.enterCriticalSection(false);
        try {
            List<String> dataUriRestrictions;
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            Resource idClass = this.idToClass(idResource);
            List<String> classUriRestrictions = SpdxOwlOntology.getSpdxOwlOntology().getClassUriRestrictions(idClass.getURI(), property.getURI());
            if (!classUriRestrictions.isEmpty()) {
                for (String classUriRestriction : classUriRestrictions) {
                    if (clazz.isAssignableFrom(SpdxModelFactory.classUriToClass((String)classUriRestriction))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            if (!(dataUriRestrictions = SpdxOwlOntology.getSpdxOwlOntology().getDataUriRestrictions(idClass.getURI(), property.getURI())).isEmpty()) {
                for (String dataUriRestriction : dataUriRestrictions) {
                    Class<?> javaClass = this.dataUriToClass(dataUriRestriction);
                    if (!Objects.isNull(javaClass) && clazz.isAssignableFrom(this.dataUriToClass(dataUriRestriction))) continue;
                    if (URI.class.equals(javaClass)) {
                        boolean bl = clazz.isAssignableFrom(String.class);
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (dataUriRestrictions.isEmpty() && classUriRestrictions.isEmpty()) {
                throw new MissingDataTypeAndClassRestriction("Missing datatype and class restrictions for class " + idClass.getURI() + " and property " + property.getURI());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private Class<?> dataUriToClass(String dataUri) throws SpdxRdfException {
        Objects.requireNonNull(dataUri, "Missing required data URI restriction");
        int poundIndex = dataUri.lastIndexOf(35);
        if (poundIndex < 1) {
            throw new SpdxRdfException("Invalid data URI " + dataUri);
        }
        RDFDatatype dataType = TypeMapper.getInstance().getTypeByName(dataUri);
        return dataType.getJavaClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionMembersAssignableTo(String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        Objects.requireNonNull(clazz, "Missing required class parameter");
        try {
            return this.isAssignableTo(id, propertyName, clazz);
        }
        catch (MissingDataTypeAndClassRestriction ex) {
            logger.warn("Error determining assingability by OWL ontology.  Checking actual properties.", (Throwable)((Object)ex));
            this.model.enterCriticalSection(false);
            try {
                Resource idResource = this.idToResource(id);
                Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
                NodeIterator iter = this.model.listObjectsOfProperty(idResource, property);
                while (iter.hasNext()) {
                    RDFNode node = iter.next();
                    Optional<Object> value = this.valueNodeToObject(node, property);
                    if (!value.isPresent() || clazz.isAssignableFrom(value.get().getClass())) continue;
                    if (value.get() instanceof TypedValue) {
                        try {
                            if (clazz.isAssignableFrom(SpdxModelFactory.typeToClass((String)((TypedValue)value.get()).getType()))) continue;
                            boolean bl = false;
                            return bl;
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            logger.error("Error converting typed value to class", (Throwable)e);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (value.get() instanceof IndividualUriValue) {
                        String uri = ((IndividualUriValue)value.get()).getIndividualURI();
                        Enum spdxEnum = (Enum)SpdxEnumFactory.uriToEnum.get(uri);
                        if (Objects.nonNull(spdxEnum)) {
                            if (clazz.isAssignableFrom(spdxEnum.getClass())) continue;
                            boolean bl = false;
                            return bl;
                        }
                        if ("http://spdx.org/rdf/terms#noassertion".equals(uri) || "http://spdx.org/rdf/terms#none".equals(uri)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.model.leaveCriticalSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isPropertyValueAssignableTo(String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        try {
            return this.isAssignableTo(id, propertyName, clazz);
        }
        catch (MissingDataTypeAndClassRestriction ex) {
            logger.warn("Error determining assingability by OWL ontology.  Checking actual properties.", (Throwable)((Object)ex));
            this.model.enterCriticalSection(false);
            try {
                Resource idResource = this.idToResource(id);
                Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
                NodeIterator iter = this.model.listObjectsOfProperty(idResource, property);
                if (!iter.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                Optional<Object> objectValue = this.valueNodeToObject(iter.next(), property);
                if (iter.hasNext()) {
                    logger.error("Error getting single value.  Multiple values for property " + propertyName + " ID " + id + ".");
                    throw new SpdxRdfException("Error getting single value.  Multiple values for property " + propertyName + " ID " + id + ".");
                }
                if (objectValue.isPresent()) {
                    if (clazz.isAssignableFrom(objectValue.get().getClass())) {
                        boolean bl = true;
                        return bl;
                    }
                    if (objectValue.get() instanceof TypedValue) {
                        try {
                            boolean bl = clazz.isAssignableFrom(SpdxModelFactory.typeToClass((String)((TypedValue)objectValue.get()).getType()));
                            return bl;
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            logger.error("Error converting typed value to class", (Throwable)e);
                            boolean bl = false;
                            this.model.leaveCriticalSection();
                            return bl;
                        }
                    }
                    if (objectValue.get() instanceof IndividualUriValue) {
                        String uri = ((IndividualUriValue)objectValue.get()).getIndividualURI();
                        if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                            boolean bl = true;
                            return bl;
                        }
                        if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                            boolean bl = true;
                            return bl;
                        }
                        Enum spdxEnum = (Enum)SpdxEnumFactory.uriToEnum.get(uri);
                        if (Objects.nonNull(spdxEnum)) {
                            boolean bl = clazz.isAssignableFrom(spdxEnum.getClass());
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.model.leaveCriticalSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionProperty(String id, String propertyName) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        Objects.requireNonNull(propertyName, "Missing required property name");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Property property = this.model.createProperty(SpdxResourceFactory.propertyNameToUri(propertyName));
            Resource idClass = this.idToClass(idResource);
            boolean bl = SpdxOwlOntology.getSpdxOwlOntology().isList(idClass.getURI(), property.getURI());
            return bl;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    private Resource idToClass(Resource idResource) throws SpdxInvalidIdException {
        Statement statement = this.model.getProperty(idResource, this.typeProperty);
        if (statement == null || !statement.getObject().isResource()) {
            if (idResource.isURIResource() && idResource.getURI().contains(SPDX_LISTED_LICENSE_SUBPREFIX)) {
                String licenseOrExceptionId = idResource.getURI().substring(idResource.getURI().lastIndexOf(47) + 1);
                if (ListedLicenses.getListedLicenses().isSpdxListedLicenseId(licenseOrExceptionId)) {
                    return this.model.createResource("http://spdx.org/rdf/terms#ListedLicense");
                }
                if (ListedLicenses.getListedLicenses().isSpdxListedExceptionId(licenseOrExceptionId)) {
                    return this.model.createResource("http://spdx.org/rdf/terms#ListedLicenseException");
                }
            }
            logger.error("ID " + idResource + " does not have a type.");
            throw new SpdxInvalidIdException("ID " + idResource + " does not have a type.");
        }
        return statement.getObject().asResource();
    }

    public void close() {
        this.model.unregister((ModelChangedListener)this.nextIdListener);
    }

    public IModelStore.IModelStoreLock enterCriticalSection(boolean readLockRequested) {
        this.model.enterCriticalSection(readLockRequested);
        return this;
    }

    public void unlock() {
        this.model.leaveCriticalSection();
    }

    public void serialize(OutputStream stream, OutputFormat outputFormat) {
        this.model.write(stream, outputFormat.getType());
    }

    public Optional<String> getCasesensitiveId(String caseInsensisitiveId) {
        return Optional.ofNullable(this.idCaseSensitiveMap.get(caseInsensisitiveId.toLowerCase()));
    }

    public void delete(String id) throws SpdxInvalidIdException {
        Resource idResource = this.idToResource(id);
        this.model.removeAll(idResource, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TypedValue> getTypedValue(String id) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(id, "Missing required ID");
        this.model.enterCriticalSection(false);
        try {
            Resource idResource = this.idToResource(id);
            Resource idClass = this.idToClass(idResource);
            if (Objects.isNull(idClass)) {
                Optional<TypedValue> optional = Optional.empty();
                return optional;
            }
            Class clazz = SpdxModelFactory.classUriToClass((String)idClass.getURI());
            if (Objects.isNull(clazz)) {
                Optional<TypedValue> optional = Optional.empty();
                return optional;
            }
            String type = (String)SpdxModelFactory.SPDX_CLASS_TO_TYPE.get(clazz);
            if (Objects.isNull(type)) {
                Optional<TypedValue> optional = Optional.empty();
                return optional;
            }
            Optional<TypedValue> optional = Optional.of(new TypedValue(id, type));
            return optional;
        }
        catch (SpdxInvalidIdException ex) {
            Optional<TypedValue> optional = Optional.empty();
            return optional;
        }
        finally {
            this.model.leaveCriticalSection();
        }
    }

    class NextIdListener
    extends StatementListener {
        NextIdListener() {
        }

        public void addedStatement(Statement s) {
            StmtIterator iter;
            if (Objects.nonNull(s.getSubject()) && (iter = s.getModel().listStatements(s.getSubject(), null, (RDFNode)null)).hasNext()) {
                iter.next();
                if (!iter.hasNext()) {
                    RdfSpdxDocumentModelManager.this.checkAddNewId((RDFNode)s.getSubject());
                }
            }
        }

        public void removedStatement(Statement s) {
            StmtIterator iter;
            if (Objects.nonNull(s.getSubject()) && !(iter = s.getModel().listStatements(s.getSubject(), null, (RDFNode)null)).hasNext()) {
                RdfSpdxDocumentModelManager.this.checkRemoveId((RDFNode)s.getSubject());
            }
        }
    }

    public class RdfListIterator
    implements Iterator<Object> {
        NodeIterator listIterator;
        private Property property;

        public RdfListIterator(Resource idResource, Property property) {
            Objects.requireNonNull(idResource, "ID resource can not be null");
            Objects.requireNonNull(property, "Property resource can not be null");
            this.listIterator = RdfSpdxDocumentModelManager.this.model.listObjectsOfProperty(idResource, property);
            this.property = property;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Object next() {
            RDFNode node = this.listIterator.next();
            if (Objects.isNull(node)) {
                return null;
            }
            try {
                Optional value = RdfSpdxDocumentModelManager.this.valueNodeToObject(node, this.property);
                if (value.isPresent()) {
                    return value.get();
                }
                return null;
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

