/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.spdxRdfStore.MissingDataTypeAndClassRestriction;
import org.spdx.spdxRdfStore.SpdxRdfException;

public class SpdxOwlOntology {
    static final Logger logger = LoggerFactory.getLogger(SpdxOwlOntology.class);
    static SpdxOwlOntology myself = null;
    static final String ONTOLOGY_PATH = "/resources/spdx-2-2-revision-14-onotology.owl.xml";
    private OntModel model;
    Property PROP_MIN_CARDINALITY;
    Property PROP_MIN_QUAL_CARDINALITY;
    Property PROP_MAX_CARDINALITY;
    Property PROP_MAX_QUAL_CARDINALITY;
    Property PROP_CARDINALITY;
    Property PROP_QUAL_CARDINALITY;
    Property ON_PROPERTY_PROPERTY;
    Property RANGE_PROPERTY;
    Property ON_CLASS_PROPERTY;
    Property ON_DATA_RANGE_PROPERTY;
    static final Map<String, Class<? extends Object>> DATA_TYPE_TO_CLASS;
    public static final Map<String, String> RENAMED_PROPERTY_TO_OWL_PROPERTY;
    public static final Map<String, String> OWL_PROPERTY_TO_RENAMED_PROPERTY;

    public static synchronized SpdxOwlOntology getSpdxOwlOntology() {
        if (Objects.isNull(myself)) {
            myself = new SpdxOwlOntology();
        }
        return myself;
    }

    private SpdxOwlOntology() {
        try (InputStream is = SpdxOwlOntology.class.getResourceAsStream(ONTOLOGY_PATH);){
            if (Objects.isNull(is)) {
                throw new RuntimeException("Can not open SPDX OWL ontology file");
            }
            this.model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            this.model.read(is, "RDF/XML");
            this.PROP_MIN_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#minCardinality");
            this.PROP_MIN_QUAL_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#minQualifiedCardinality");
            this.PROP_MAX_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#maxCardinality");
            this.PROP_MAX_QUAL_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#maxQualifiedCardinality");
            this.PROP_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#cardinality");
            this.ON_PROPERTY_PROPERTY = this.model.createProperty("http://www.w3.org/2002/07/owl#onProperty");
            this.RANGE_PROPERTY = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#range");
            this.PROP_QUAL_CARDINALITY = this.model.getProperty("http://www.w3.org/2002/07/owl#qualifiedCardinality");
            this.ON_CLASS_PROPERTY = this.model.getProperty("http://www.w3.org/2002/07/owl#onClass");
            this.ON_DATA_RANGE_PROPERTY = this.model.getProperty("http://www.w3.org/2002/07/owl#onDataRange");
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error in the SPDX OWL ontology file", e);
        }
    }

    public static String checkGetOwlUriFromRenamed(String renamedPropertyUri) {
        if (renamedPropertyUri.startsWith("http://spdx.org/rdf/terms#") && RENAMED_PROPERTY_TO_OWL_PROPERTY.containsKey(renamedPropertyUri.substring("http://spdx.org/rdf/terms#".length()))) {
            return "http://spdx.org/rdf/terms#" + RENAMED_PROPERTY_TO_OWL_PROPERTY.get(renamedPropertyUri.substring("http://spdx.org/rdf/terms#".length()));
        }
        return renamedPropertyUri;
    }

    public static String checkGetRenamedUri(String owlPropertyUri) {
        if (owlPropertyUri.startsWith("http://spdx.org/rdf/terms#") && OWL_PROPERTY_TO_RENAMED_PROPERTY.containsKey(owlPropertyUri.substring("http://spdx.org/rdf/terms#".length()))) {
            return "http://spdx.org/rdf/terms#" + OWL_PROPERTY_TO_RENAMED_PROPERTY.get(owlPropertyUri.substring("http://spdx.org/rdf/terms#".length()));
        }
        return owlPropertyUri;
    }

    public Optional<Class<? extends Object>> getPropertyClass(Property p) {
        if (!p.isURIResource()) {
            return Optional.empty();
        }
        String propertyUri = SpdxOwlOntology.checkGetOwlUriFromRenamed(p.getURI());
        DatatypeProperty dataProperty = this.model.getDatatypeProperty(propertyUri);
        if (Objects.isNull(dataProperty)) {
            return Optional.empty();
        }
        ExtendedIterator rangeIter = dataProperty.listRange();
        while (rangeIter.hasNext()) {
            OntResource range = (OntResource)rangeIter.next();
            if (!range.isURIResource()) continue;
            Class<? extends Object> retval = DATA_TYPE_TO_CLASS.get(range.getURI());
            if (Objects.nonNull(retval)) {
                return Optional.of(retval);
            }
            logger.warn("Unknown data type: " + range.toString());
        }
        return Optional.empty();
    }

    public OntModel getModel() {
        return this.model;
    }

    public List<String> getClassUriRestrictions(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.error(classUri + " is not an SPDX class");
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.error(propertyUri + " is not an SPDX property");
            throw new MissingDataTypeAndClassRestriction(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        ArrayList<String> retval = new ArrayList<String>();
        for (Statement stmt : propertyRestrictions) {
            if (!stmt.getPredicate().equals(this.ON_CLASS_PROPERTY)) continue;
            retval.add(stmt.getObject().asResource().getURI());
        }
        return retval;
    }

    public List<String> getDataUriRestrictions(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.error(classUri + " is not an SPDX class");
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.error(propertyUri + " is not an SPDX property");
            throw new SpdxRdfException(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        ArrayList<String> retval = new ArrayList<String>();
        for (Statement stmt : propertyRestrictions) {
            if (!stmt.getPredicate().equals(this.ON_DATA_RANGE_PROPERTY)) continue;
            retval.add(stmt.getObject().asResource().getURI());
        }
        return retval;
    }

    public boolean isList(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.error(classUri + " is not an SPDX class");
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.error(propertyUri + " is not an SPDX property");
            throw new SpdxRdfException(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        if (propertyRestrictions.isEmpty()) {
            throw new SpdxRdfException(propertyUri + " was not found related to class " + classUri);
        }
        int minCardinality = -1;
        int maxCardinality = -1;
        int exactCardinality = -1;
        for (Statement stmt : propertyRestrictions) {
            if (stmt.getPredicate().equals(this.PROP_MIN_CARDINALITY) || stmt.getPredicate().equals(this.PROP_MIN_QUAL_CARDINALITY)) {
                if (stmt.getObject().asLiteral().getInt() <= minCardinality) continue;
                minCardinality = stmt.getObject().asLiteral().getInt();
                continue;
            }
            if (stmt.getPredicate().equals(this.PROP_MAX_CARDINALITY) || stmt.getPredicate().equals(this.PROP_MAX_QUAL_CARDINALITY)) {
                if (stmt.getObject().asLiteral().getInt() <= maxCardinality) continue;
                maxCardinality = stmt.getObject().asLiteral().getInt();
                continue;
            }
            if (!stmt.getPredicate().equals(this.PROP_CARDINALITY) && !stmt.getPredicate().equals(this.PROP_QUAL_CARDINALITY)) continue;
            exactCardinality = stmt.getObject().asLiteral().getInt();
        }
        return exactCardinality == -1 && maxCardinality == -1 || maxCardinality > 1 || exactCardinality > 1;
    }

    private void addPropertyRestrictions(OntClass ontClass, OntProperty property, List<Statement> propertyRestrictions) {
        if (ontClass.isRestriction()) {
            if (this.model.listStatements((Selector)new SimpleSelector((Resource)ontClass, this.ON_PROPERTY_PROPERTY, (RDFNode)property)).hasNext()) {
                ontClass.listProperties().forEachRemaining(stmt -> propertyRestrictions.add((Statement)stmt));
            }
        } else if (ontClass.isUnionClass()) {
            ontClass.asUnionClass().listOperands().forEachRemaining(operand -> this.addPropertyRestrictions((OntClass)operand, property, propertyRestrictions));
        } else {
            ontClass.listSuperClasses().forEachRemaining(superClass -> this.addPropertyRestrictions((OntClass)superClass, property, propertyRestrictions));
        }
    }

    static {
        HashMap<String, Class> dataTypeMap = new HashMap<String, Class>();
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#string", String.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#hexBinary", String.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#anyURI", String.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#dateTime", String.class);
        dataTypeMap.put("http://www.w3.org/2000/01/rdf-schema#Literal", String.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#int", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#integer", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#short", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#byte", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedShort", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedInt", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#unsignedByte", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#positiveInteger", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", Integer.class);
        dataTypeMap.put("http://www.w3.org/2001/XMLSchema#boolean", Boolean.class);
        DATA_TYPE_TO_CLASS = Collections.unmodifiableMap(dataTypeMap);
        HashMap<String, String> renamedToOwl = new HashMap<String, String>();
        HashMap<String, String> owlToRenamed = new HashMap<String, String>();
        renamedToOwl.put("spdxVersion", "specVersion");
        owlToRenamed.put("specVersion", "spdxVersion");
        RENAMED_PROPERTY_TO_OWL_PROPERTY = Collections.unmodifiableMap(renamedToOwl);
        OWL_PROPERTY_TO_RENAMED_PROPERTY = Collections.unmodifiableMap(owlToRenamed);
    }
}

