/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxRdfStore;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.spdxRdfStore.MissingDataTypeAndClassRestriction;
import org.spdx.spdxRdfStore.SpdxRdfException;

public class SpdxOwlOntology {
    static final Logger logger = LoggerFactory.getLogger(SpdxOwlOntology.class);
    static SpdxOwlOntology myself = null;
    static final String ONTOLOGY_PATH = "/resources/spdx-2-3-revision-2-ontology.owl.xml";
    private final OntModel model;
    Property PROP_MIN_CARDINALITY;
    Property PROP_MIN_QUAL_CARDINALITY;
    Property PROP_MAX_CARDINALITY;
    Property PROP_MAX_QUAL_CARDINALITY;
    Property PROP_CARDINALITY;
    Property PROP_QUAL_CARDINALITY;
    Property ON_PROPERTY_PROPERTY;
    Property RANGE_PROPERTY;
    Property ON_CLASS_PROPERTY;
    Property ON_DATA_RANGE_PROPERTY;
    static final Map<String, Class<?>> DATA_TYPE_TO_CLASS = Map.ofEntries(Map.entry("http://www.w3.org/2001/XMLSchema#string", String.class), Map.entry("http://www.w3.org/2001/XMLSchema#hexBinary", String.class), Map.entry("http://www.w3.org/2001/XMLSchema#anyURI", String.class), Map.entry("http://www.w3.org/2001/XMLSchema#dateTime", String.class), Map.entry("http://www.w3.org/2000/01/rdf-schema#Literal", String.class), Map.entry("http://www.w3.org/2001/XMLSchema#int", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#integer", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#short", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#byte", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#unsignedShort", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#unsignedInt", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#unsignedByte", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#positiveInteger", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", Integer.class), Map.entry("http://www.w3.org/2001/XMLSchema#boolean", Boolean.class));
    public static final Map<String, String> RENAMED_PROPERTY_TO_OWL_PROPERTY;
    public static final Map<String, String> OWL_PROPERTY_TO_RENAMED_PROPERTY;

    public static synchronized SpdxOwlOntology getSpdxOwlOntology() {
        if (Objects.isNull(myself)) {
            myself = new SpdxOwlOntology();
        }
        return myself;
    }

    private SpdxOwlOntology() {
        try (InputStream is = SpdxOwlOntology.class.getResourceAsStream(ONTOLOGY_PATH);){
            if (Objects.isNull(is)) {
                throw new RuntimeException("Can not open SPDX OWL ontology file");
            }
            this.model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
            this.model.read(is, "RDF/XML");
            this.PROP_MIN_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#minCardinality");
            this.PROP_MIN_QUAL_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#minQualifiedCardinality");
            this.PROP_MAX_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#maxCardinality");
            this.PROP_MAX_QUAL_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#maxQualifiedCardinality");
            this.PROP_CARDINALITY = this.model.createProperty("http://www.w3.org/2002/07/owl#cardinality");
            this.ON_PROPERTY_PROPERTY = this.model.createProperty("http://www.w3.org/2002/07/owl#onProperty");
            this.RANGE_PROPERTY = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#range");
            this.PROP_QUAL_CARDINALITY = this.model.getProperty("http://www.w3.org/2002/07/owl#qualifiedCardinality");
            this.ON_CLASS_PROPERTY = this.model.getProperty("http://www.w3.org/2002/07/owl#onClass");
            this.ON_DATA_RANGE_PROPERTY = this.model.getProperty("http://www.w3.org/2002/07/owl#onDataRange");
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error in the SPDX OWL ontology file", e);
        }
    }

    public static String checkGetOwlUriFromRenamed(String renamedPropertyUri) {
        if (renamedPropertyUri.startsWith("http://spdx.org/rdf/terms#") && RENAMED_PROPERTY_TO_OWL_PROPERTY.containsKey(renamedPropertyUri.substring("http://spdx.org/rdf/terms#".length()))) {
            return "http://spdx.org/rdf/terms#" + RENAMED_PROPERTY_TO_OWL_PROPERTY.get(renamedPropertyUri.substring("http://spdx.org/rdf/terms#".length()));
        }
        return renamedPropertyUri;
    }

    public static String checkGetRenamedUri(String owlPropertyUri) {
        if (owlPropertyUri.startsWith("http://spdx.org/rdf/terms#") && OWL_PROPERTY_TO_RENAMED_PROPERTY.containsKey(owlPropertyUri.substring("http://spdx.org/rdf/terms#".length()))) {
            return "http://spdx.org/rdf/terms#" + OWL_PROPERTY_TO_RENAMED_PROPERTY.get(owlPropertyUri.substring("http://spdx.org/rdf/terms#".length()));
        }
        return owlPropertyUri;
    }

    public Optional<Class<?>> getPropertyClass(Property p) {
        if (!p.isURIResource()) {
            return Optional.empty();
        }
        String propertyUri = SpdxOwlOntology.checkGetOwlUriFromRenamed(p.getURI());
        DatatypeProperty dataProperty = this.model.getDatatypeProperty(propertyUri);
        if (Objects.isNull(dataProperty)) {
            return Optional.empty();
        }
        ExtendedIterator rangeIter = dataProperty.listRange();
        while (rangeIter.hasNext()) {
            OntResource range = (OntResource)rangeIter.next();
            if (!range.isURIResource()) continue;
            Class<?> retval = DATA_TYPE_TO_CLASS.get(range.getURI());
            if (Objects.nonNull(retval)) {
                return Optional.of(retval);
            }
            logger.warn("Unknown data type: {}", (Object)range);
        }
        return Optional.empty();
    }

    public OntModel getModel() {
        return this.model;
    }

    public List<String> getClassUriRestrictions(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.warn("{} is not an SPDX class", (Object)classUri);
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.warn("{} is not an SPDX property", (Object)propertyUri);
            throw new MissingDataTypeAndClassRestriction(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        ArrayList<String> retval = new ArrayList<String>();
        for (Statement stmt : propertyRestrictions) {
            if (!stmt.getPredicate().equals((Object)this.ON_CLASS_PROPERTY) || !stmt.getObject().asResource().isURIResource()) continue;
            retval.add(stmt.getObject().asResource().getURI());
        }
        return retval;
    }

    public List<String> getDataUriRestrictions(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.warn("{} is not an SPDX class", (Object)classUri);
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.warn("{} is not an SPDX property", (Object)propertyUri);
            throw new SpdxRdfException(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        ArrayList<String> retval = new ArrayList<String>();
        for (Statement stmt : propertyRestrictions) {
            if (!stmt.getPredicate().equals((Object)this.ON_DATA_RANGE_PROPERTY) || !stmt.getObject().asResource().isURIResource()) continue;
            retval.add(stmt.getObject().asResource().getURI());
        }
        return retval;
    }

    public boolean isList(String classUri, String propertyUri) throws SpdxRdfException {
        OntProperty property;
        Objects.requireNonNull(classUri, "Missing class URI");
        Objects.requireNonNull(propertyUri, "Missing property URI");
        OntClass ontClass = this.model.getOntClass(classUri);
        if (Objects.isNull(ontClass)) {
            if (classUri.endsWith("GenericSpdxElement")) {
                ontClass = this.model.getOntClass("http://spdx.org/rdf/terms#SpdxElement");
            } else {
                logger.warn("{} is not an SPDX class", (Object)classUri);
                throw new SpdxRdfException(classUri + " is not an SPDX class");
            }
        }
        if (Objects.isNull(property = this.model.getOntProperty(SpdxOwlOntology.checkGetOwlUriFromRenamed(propertyUri)))) {
            logger.warn("{} is not an SPDX property", (Object)propertyUri);
            throw new SpdxRdfException(propertyUri + " is not an SPDX property");
        }
        ArrayList<Statement> propertyRestrictions = new ArrayList<Statement>();
        this.addPropertyRestrictions(ontClass, property, propertyRestrictions);
        if (propertyRestrictions.isEmpty()) {
            throw new SpdxRdfException(propertyUri + " was not found related to class " + classUri);
        }
        int minCardinality = -1;
        int maxCardinality = -1;
        int exactCardinality = -1;
        for (Statement stmt : propertyRestrictions) {
            if (stmt.getPredicate().equals((Object)this.PROP_MIN_CARDINALITY) || stmt.getPredicate().equals((Object)this.PROP_MIN_QUAL_CARDINALITY)) {
                if (stmt.getObject().asLiteral().getInt() <= minCardinality) continue;
                minCardinality = stmt.getObject().asLiteral().getInt();
                continue;
            }
            if (stmt.getPredicate().equals((Object)this.PROP_MAX_CARDINALITY) || stmt.getPredicate().equals((Object)this.PROP_MAX_QUAL_CARDINALITY)) {
                if (stmt.getObject().asLiteral().getInt() <= maxCardinality) continue;
                maxCardinality = stmt.getObject().asLiteral().getInt();
                continue;
            }
            if (!stmt.getPredicate().equals((Object)this.PROP_CARDINALITY) && !stmt.getPredicate().equals((Object)this.PROP_QUAL_CARDINALITY)) continue;
            exactCardinality = stmt.getObject().asLiteral().getInt();
        }
        return exactCardinality == -1 && maxCardinality == -1 || maxCardinality > 1 || exactCardinality > 1;
    }

    private void addPropertyRestrictions(OntClass ontClass, OntProperty property, List<Statement> propertyRestrictions) {
        if (ontClass.isRestriction()) {
            if (this.model.listStatements((Resource)ontClass, this.ON_PROPERTY_PROPERTY, (RDFNode)property).hasNext()) {
                ontClass.listProperties().forEachRemaining(propertyRestrictions::add);
            }
        } else if (ontClass.isUnionClass()) {
            ontClass.asUnionClass().listOperands().forEachRemaining(operand -> this.addPropertyRestrictions((OntClass)operand, property, propertyRestrictions));
        } else {
            ontClass.listSuperClasses().forEachRemaining(superClass -> this.addPropertyRestrictions((OntClass)superClass, property, propertyRestrictions));
        }
    }

    static {
        HashMap<String, String> renamedToOwl = new HashMap<String, String>();
        HashMap<String, String> owlToRenamed = new HashMap<String, String>();
        renamedToOwl.put(SpdxConstantsCompatV2.PROP_SPDX_SPEC_VERSION.getName(), SpdxConstantsCompatV2.PROP_SPDX_VERSION.getName());
        owlToRenamed.put(SpdxConstantsCompatV2.PROP_SPDX_VERSION.getName(), SpdxConstantsCompatV2.PROP_SPDX_SPEC_VERSION.getName());
        RENAMED_PROPERTY_TO_OWL_PROPERTY = Collections.unmodifiableMap(renamedToOwl);
        OWL_PROPERTY_TO_RENAMED_PROPERTY = Collections.unmodifiableMap(owlToRenamed);
    }
}

