/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PerFileSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class PerFileSheetV2d2
extends PerFileSheet {
    static final int NUM_COLS = 18;
    static final int FILE_NAME_COL = 0;
    static final int ID_COL = 1;
    static final int PACKAGE_ID_COL = 2;
    static final int FILE_TYPE_COL = 3;
    static final int CHECKSUMS_COL = 4;
    static final int CONCLUDED_LIC_COL = 5;
    static final int LIC_INFO_IN_FILE_COL = 6;
    static final int LIC_COMMENTS_COL = 7;
    static final int SEEN_COPYRIGHT_COL = 8;
    static final int NOTICE_TEXT_COL = 9;
    static final int ARTIFACT_OF_PROJECT_COL = 10;
    static final int ARTIFACT_OF_HOMEPAGE_COL = 11;
    static final int ARTIFACT_OF_PROJECT_URL_COL = 12;
    static final int CONTRIBUTORS_COL = 13;
    static final int COMMENT_COL = 14;
    static final int FILE_DEPENDENCIES_COL = 15;
    static final int ATTRIBUTION_COL = 16;
    static final int USER_DEFINED_COL = 17;
    static final boolean[] REQUIRED;
    static final String[] HEADER_TITLES;
    static final int[] COLUMN_WIDTHS;
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    Map<String, SpdxFile> fileCache = new HashMap<String, SpdxFile>();

    static {
        boolean[] blArray = new boolean[18];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        REQUIRED = blArray;
        HEADER_TITLES = new String[]{"File Name", "SPDX Identifier", "Package Identifier", "File Type(s)", "File Checksum(s)", "License Concluded", "License Info in File", "License Comments", "File Copyright Text", "Notice Text", "Artifact of Project", "Artifact of Homepage", "Artifact of URL", "Contributors", "File Comment", "File Dependencies", "Attribution Text", "User Defined Columns..."};
        COLUMN_WIDTHS = new int[]{60, 25, 25, 30, 85, 50, 50, 60, 70, 70, 35, 60, 60, 60, 60, 60, 60, 60};
        boolean[] blArray2 = new boolean[18];
        blArray2[0] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        blArray2[15] = true;
        blArray2[16] = true;
        blArray2[17] = true;
        LEFT_WRAP = blArray2;
        boolean[] blArray3 = new boolean[18];
        blArray3[1] = true;
        blArray3[2] = true;
        CENTER_NOWRAP = blArray3;
    }

    PerFileSheetV2d2(Workbook workbook, String sheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, version, modelStore, documentUri, copyManager);
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    @Override
    public void add(SpdxFile fileInfo, String pkgId) throws SpreadsheetException {
        Row row = this.addRow();
        if (fileInfo.getId() != null && !fileInfo.getId().isEmpty()) {
            row.createCell(1).setCellValue(fileInfo.getId());
        }
        if (pkgId != null && !pkgId.isEmpty()) {
            row.createCell(2).setCellValue(pkgId);
        }
        try {
            if (fileInfo.getLicenseConcluded() != null) {
                row.createCell(5).setCellValue(fileInfo.getLicenseConcluded().toString());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting concluded license from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional name = fileInfo.getName();
            if (name.isPresent()) {
                row.createCell(0).setCellValue((String)name.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file name from file ID " + fileInfo.getId(), e);
        }
        if (fileInfo.getChecksums().size() > 0) {
            try {
                row.createCell(4).setCellValue(this.checksumsToString(fileInfo.getChecksums()));
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting checksums from file ID " + fileInfo.getId(), e);
            }
        }
        try {
            row.createCell(3).setCellValue(PerFileSheetV2d2.fileTypesToString(fileInfo.getFileTypes()));
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file types from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional licenseComments = fileInfo.getLicenseComments();
            if (licenseComments.isPresent() && !((String)licenseComments.get()).isEmpty()) {
                row.createCell(7).setCellValue((String)licenseComments.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting license comment from file ID " + fileInfo.getId(), e);
        }
        try {
            if (fileInfo.getCopyrightText() != null && !fileInfo.getCopyrightText().isEmpty()) {
                row.createCell(8).setCellValue(fileInfo.getCopyrightText());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting copyright text from file ID " + fileInfo.getId(), e);
        }
        try {
            if (fileInfo.getLicenseInfoFromFiles() != null && fileInfo.getLicenseInfoFromFiles().size() > 0) {
                row.createCell(6).setCellValue(PerFileSheetV2d2.licensesToString(fileInfo.getLicenseInfoFromFiles()));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting license info from files from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional comment = fileInfo.getComment();
            if (comment.isPresent() && !((String)comment.get()).isEmpty()) {
                row.createCell(14).setCellValue((String)comment.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting comment file ID " + fileInfo.getId(), e);
        }
        if (fileInfo.getFileContributors() != null && fileInfo.getFileContributors().size() > 0) {
            row.createCell(13).setCellValue(PerFileSheetV2d2.stringsToCsv(fileInfo.getFileContributors()));
        }
        try {
            if (fileInfo.getAttributionText() != null && fileInfo.getAttributionText().size() > 0) {
                row.createCell(16).setCellValue(PerFileSheetV2d2.stringsToCsv(fileInfo.getAttributionText()));
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting attribution text from file ID " + fileInfo.getId(), e);
        }
        try {
            Optional noticeText = fileInfo.getNoticeText();
            if (noticeText.isPresent() && !((String)noticeText.get()).isEmpty()) {
                row.createCell(9).setCellValue((String)noticeText.get());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting file notice text from file ID " + fileInfo.getId(), e);
        }
    }

    @Override
    public SpdxFile getFileInfo(int rowNum) throws SpreadsheetException {
        Cell fileDependencyCells;
        SpdxFile retval;
        Cell commentCell;
        Cell noticeCell;
        Cell attributionCell;
        Cell contributorCell;
        Cell licCommentCell;
        Cell copyrightCell;
        AnyLicenseInfo anyLicenseInfo;
        String id;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String ver = this.validateRow(row);
        if (ver != null && !ver.isEmpty()) {
            throw new SpreadsheetException(ver);
        }
        String name = row.getCell(0).getStringCellValue();
        if (this.fileCache.containsKey(name)) {
            return this.fileCache.get(name);
        }
        Cell idCell = row.getCell(1);
        if (Objects.nonNull(idCell) && idCell.getStringCellValue() != null && !idCell.getStringCellValue().isEmpty()) {
            id = idCell.getStringCellValue().trim();
        } else {
            try {
                id = this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting element ID for file " + name, e);
            }
        }
        Cell checksumsCell = row.getCell(4);
        Collection<Object> checksums = new ArrayList();
        Checksum sha1 = null;
        if (Objects.nonNull(checksumsCell)) {
            try {
                checksums = this.strToChecksums(checksumsCell.getStringCellValue());
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                throw new SpreadsheetException("Error converting file checksums: " + invalidSPDXAnalysisException.getMessage(), invalidSPDXAnalysisException);
            }
        }
        for (Checksum checksum : checksums) {
            try {
                if (!ChecksumAlgorithm.SHA1.equals((Object)checksum.getAlgorithm())) continue;
                if (Objects.isNull(sha1)) {
                    sha1 = checksum;
                    continue;
                }
                throw new SpreadsheetException("Duplicate SHA1 for file " + name);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting checksum for file " + name, e);
            }
        }
        if (Objects.isNull(sha1)) {
            throw new SpreadsheetException("Missing SHA1 for file " + name);
        }
        Cell concludedLicenseCell = row.getCell(5);
        if (Objects.nonNull(concludedLicenseCell) && !concludedLicenseCell.getStringCellValue().isEmpty()) {
            try {
                anyLicenseInfo = LicenseInfoFactory.parseSPDXLicenseString((String)concludedLicenseCell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
            }
            catch (InvalidLicenseStringException e) {
                throw new SpreadsheetException("Error getting concluded license for file " + name, e);
            }
        } else {
            throw new SpreadsheetException("Missing concluded license for file " + name);
        }
        ArrayList<AnyLicenseInfo> licenseInfosFromFile = new ArrayList<AnyLicenseInfo>();
        Cell licenseInfoFromFileCell = row.getCell(6);
        if (Objects.nonNull(licenseInfoFromFileCell) && !licenseInfoFromFileCell.getStringCellValue().isEmpty()) {
            String[] licenseStrings = licenseInfoFromFileCell.getStringCellValue().split(",");
            int i = 0;
            while (i < licenseStrings.length) {
                try {
                    licenseInfosFromFile.add(LicenseInfoFactory.parseSPDXLicenseString((String)licenseStrings[i].trim(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager));
                }
                catch (InvalidLicenseStringException e) {
                    throw new SpreadsheetException("Error getting license infos from file for file " + name, e);
                }
                ++i;
            }
        }
        String copyrightText = Objects.nonNull(copyrightCell = row.getCell(8)) ? copyrightCell.getStringCellValue() : "";
        SpdxFile.SpdxFileBuilder fileBuilder = new SpdxFile.SpdxFileBuilder(this.modelStore, this.documentUri, id, this.copyManager, name, anyLicenseInfo, licenseInfosFromFile, copyrightText, sha1);
        for (Checksum checksum : checksums) {
            try {
                if (ChecksumAlgorithm.SHA1.equals((Object)checksum.getAlgorithm())) continue;
                fileBuilder.addChecksum(checksum);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error getting checksum value", e);
            }
        }
        String string = row.getCell(3).getStringCellValue();
        if (Objects.nonNull(string)) {
            try {
                fileBuilder.setFileTypes(PerFileSheetV2d2.parseFileTypeString(string));
            }
            catch (InvalidSPDXAnalysisException e1) {
                throw new SpreadsheetException("Error converting file types: " + e1.getMessage());
            }
        }
        if (Objects.nonNull(licCommentCell = row.getCell(7))) {
            fileBuilder.setLicenseComments(licCommentCell.getStringCellValue());
        }
        if (Objects.nonNull(contributorCell = row.getCell(13)) && !contributorCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setFileContributors(PerFileSheetV2d2.csvToStrings(contributorCell.getStringCellValue().trim()));
        }
        if (Objects.nonNull(attributionCell = row.getCell(16)) && !attributionCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setAttributionText(PerFileSheetV2d2.csvToStrings(attributionCell.getStringCellValue().trim()));
        }
        if (Objects.nonNull(noticeCell = row.getCell(9)) && !noticeCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setNoticeText(noticeCell.getStringCellValue().trim());
        }
        if (Objects.nonNull(commentCell = row.getCell(14)) && !commentCell.getStringCellValue().trim().isEmpty()) {
            fileBuilder.setComment(commentCell.getStringCellValue().trim());
        }
        try {
            retval = fileBuilder.build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error creating new SPDX file: " + e.getMessage());
        }
        Cell artifactOfNameCell = row.getCell(10);
        if (Objects.nonNull(artifactOfNameCell) && !artifactOfNameCell.getStringCellValue().isEmpty()) {
            SpdxNoAssertionLicense noAssertion;
            List<String> projectNames = PerFileSheetV2d2.csvToStrings(artifactOfNameCell.getStringCellValue());
            Cell artifactOfHomePageCell = row.getCell(11);
            List<Object> projectHomePages = Objects.nonNull(artifactOfHomePageCell) && !artifactOfHomePageCell.getStringCellValue().isEmpty() ? PerFileSheetV2d2.csvToStrings(artifactOfHomePageCell.getStringCellValue()) : new ArrayList();
            try {
                noAssertion = new SpdxNoAssertionLicense();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Error creating no assertion license for DOAP project for file " + name, e);
            }
            int i = 0;
            while (i < projectNames.size()) {
                SpdxPackage doapPackage;
                SpdxPackage.SpdxPackageBuilder pkgBuilder = new SpdxPackage.SpdxPackageBuilder(this.modelStore, this.documentUri, String.valueOf(SpdxConstants.SPDX_ELEMENT_REF_PRENUM) + "FromDoap-" + Integer.toString(i), this.copyManager, projectNames.get(i), (AnyLicenseInfo)noAssertion, SpdxConstants.NOASSERTION_VALUE, (AnyLicenseInfo)noAssertion).setFilesAnalyzed(false);
                if (projectHomePages.size() > i) {
                    pkgBuilder.setHomepage((String)projectHomePages.get(i));
                }
                pkgBuilder.setComment("This package was converted from a DOAP Project by the same name");
                try {
                    doapPackage = pkgBuilder.build();
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating package for DOAP project for file " + name, e);
                }
                try {
                    retval.addRelationship(retval.createRelationship((SpdxElement)doapPackage, RelationshipType.GENERATED_FROM, "This relationship replaces an ArtifactOf"));
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating relationships for DOAP project for file " + name, e);
                }
                ++i;
            }
        }
        if (Objects.nonNull(fileDependencyCells = row.getCell(15)) && !fileDependencyCells.getStringCellValue().isEmpty()) {
            for (String dependencyName : PerFileSheetV2d2.csvToStrings(fileDependencyCells.getStringCellValue())) {
                SpdxFile dependency = this.findFileByName(dependencyName.trim());
                try {
                    retval.addRelationship(retval.createRelationship((SpdxElement)dependency, RelationshipType.DEPENDS_ON, "This relationship replaced a file dependency property value"));
                }
                catch (InvalidSPDXAnalysisException e) {
                    throw new SpreadsheetException("Error creating relationship for file dependency for file " + name, e);
                }
            }
        }
        this.fileCache.put(name, retval);
        return retval;
    }

    public SpdxFile findFileByName(String fileName) throws SpreadsheetException {
        if (this.fileCache.containsKey(fileName)) {
            return this.fileCache.get(fileName);
        }
        int i = this.firstRowNum;
        while (i < this.lastRowNum + 1) {
            Cell fileNameCell = this.sheet.getRow(i).getCell(0);
            if (fileNameCell.getStringCellValue().trim().equals(fileName)) {
                return this.getFileInfo(i);
            }
            ++i;
        }
        throw new SpreadsheetException("Could not find dependant file in the spreadsheet: " + fileName);
    }

    @Override
    public List<String> getPackageIds(int row) {
        ArrayList<String> retval = new ArrayList<String>();
        Cell pkgIdCell = this.sheet.getRow(row).getCell(2);
        if (pkgIdCell == null || pkgIdCell.getStringCellValue() == null || pkgIdCell.getStringCellValue().isEmpty()) {
            return retval;
        }
        String[] stringArray = pkgIdCell.getStringCellValue().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgId = stringArray[n2];
            retval.add(pkgId.trim());
            ++n2;
        }
        return retval;
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for SPDX File does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 17) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for SPDX File worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX File work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 18) {
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (REQUIRED[i]) {
                    return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
                }
            } else if (i == 5) {
                try {
                    LicenseInfoFactory.parseSPDXLicenseString((String)cell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
                }
                catch (InvalidSPDXAnalysisException ex) {
                    return "Invalid asserted license string in row " + String.valueOf(row.getRowNum()) + " details: " + ex.getMessage();
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    protected String getFileId(int rowNum) {
        Cell idCell = this.sheet.getRow(rowNum).getCell(1);
        if (idCell == null || idCell.getStringCellValue().isEmpty()) {
            return "";
        }
        return idCell.getStringCellValue();
    }
}

