/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.ModelCopyManager;
import org.spdx.spreadsheetstore.AnnotationsSheet;
import org.spdx.spreadsheetstore.DocumentInfoSheet;
import org.spdx.spreadsheetstore.ExternalRefsSheet;
import org.spdx.spreadsheetstore.ExtractedLicenseInfoSheet;
import org.spdx.spreadsheetstore.PackageInfoSheet;
import org.spdx.spreadsheetstore.PerFileSheet;
import org.spdx.spreadsheetstore.RelationshipsSheet;
import org.spdx.spreadsheetstore.ReviewersSheet;
import org.spdx.spreadsheetstore.SnippetSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.spreadsheetstore.SpreadsheetStore;
import org.spdx.storage.IModelStore;

public class SpdxSpreadsheet {
    static final Logger logger = LoggerFactory.getLogger(SpdxSpreadsheet.class);
    public static final String CURRENT_VERSION = "2.3.0";
    public static final String VERSION_2_2_0 = "2.2.0";
    public static final String VERSION_2_1_0 = "2.1.0";
    public static final String VERSION_2_0_0 = "2.0.0";
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final String UNKNOWN_NAMESPACE = "http://spdx.unknown.namespace";
    public static final List<String> SUPPORTED_VERSIONS = Collections.unmodifiableList(Arrays.asList("2.3.0", "2.2.0", "2.1.0", "2.0.0"));
    Workbook workbook;
    private DocumentInfoSheet documentInfoSheet;
    static final String DOCUMENT_INFO_NAME = "Document Info";
    private PackageInfoSheet packageInfoSheet;
    static final String PACKAGE_INFO_SHEET_NAME = "Package Info";
    private ExtractedLicenseInfoSheet extractedLicenseInfoSheet;
    static final String NON_STANDARD_LICENSE_SHEET_NAME = "Extracted License Info";
    private PerFileSheet perFileSheet;
    static final String PER_FILE_SHEET_NAME = "Per File Info";
    private RelationshipsSheet relationshipsSheet;
    static final String RELATIONSHIPS_SHEET_NAME = "Relationships";
    private AnnotationsSheet annotationsSheet;
    static final String ANNOTATIONS_SHEET_NAME = "Annotations";
    private ReviewersSheet reviewersSheet;
    static final String REVIEWERS_SHEET_NAME = "Reviewers";
    private SnippetSheet snippetSheet;
    static final String SNIPPET_SHEET_NAME = "Snippets";
    private ExternalRefsSheet externalRefsSheet;
    static final String EXTERNAL_REFS_SHEET_NAME = "External Refs";
    private IModelStore modelStore;
    private String documentUri;
    private String version;
    private ModelCopyManager copyManager;

    public SpdxSpreadsheet(InputStream stream, IModelStore modelStore, ModelCopyManager copyManager) throws SpreadsheetException {
        Objects.requireNonNull(modelStore, "Missing required model store");
        Objects.requireNonNull(copyManager, "Missing required model copy manager");
        this.modelStore = modelStore;
        this.copyManager = copyManager;
        try {
            this.workbook = WorkbookFactory.create((InputStream)stream);
        }
        catch (EncryptedDocumentException e) {
            logger.error("Unable to read encrypted SPDX Spreadsheet", (Throwable)e);
            throw new SpreadsheetException("Unable to read encrypted SPDX Spreadsheet", e);
        }
        catch (IOException e) {
            logger.error("I/O error reading SPDX Spreadsheet", (Throwable)e);
            throw new SpreadsheetException("I/O error reading SPDX Spreadsheet", e);
        }
        this.version = this.readVersion(this.workbook, DOCUMENT_INFO_NAME);
        if (this.version.equals(UNKNOWN_VERSION)) {
            throw new SpreadsheetException("The version for the SPDX spreadsheet could not be read.");
        }
        this.documentInfoSheet = DocumentInfoSheet.openVersion(this.workbook, DOCUMENT_INFO_NAME, this.version, modelStore, copyManager);
        String verifyMsg = this.documentInfoSheet.verify();
        if (verifyMsg != null) {
            logger.error(verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
        this.documentUri = this.documentInfoSheet.getNamespace();
        this.packageInfoSheet = PackageInfoSheet.openVersion(this.workbook, PACKAGE_INFO_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.extractedLicenseInfoSheet = ExtractedLicenseInfoSheet.openVersion(this.workbook, NON_STANDARD_LICENSE_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.perFileSheet = PerFileSheet.openVersion(this.workbook, PER_FILE_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.relationshipsSheet = new RelationshipsSheet(this.workbook, RELATIONSHIPS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.annotationsSheet = new AnnotationsSheet(this.workbook, ANNOTATIONS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.reviewersSheet = new ReviewersSheet(this.workbook, REVIEWERS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.snippetSheet = new SnippetSheet(this.workbook, SNIPPET_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.externalRefsSheet = new ExternalRefsSheet(this.workbook, EXTERNAL_REFS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        verifyMsg = this.verifyWorkbook();
        if (verifyMsg != null) {
            logger.error(verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
    }

    public SpdxSpreadsheet(IModelStore modelStore, ModelCopyManager copyManager, String documentUri, SpreadsheetStore.SpreadsheetFormatType spreadsheetFormat) throws SpreadsheetException {
        Objects.requireNonNull(modelStore, "Missing required model store");
        Objects.requireNonNull(copyManager, "Missing required model copy manager");
        Objects.requireNonNull(spreadsheetFormat, "Missing required spreadsheet format");
        this.modelStore = modelStore;
        this.copyManager = copyManager;
        this.version = CURRENT_VERSION;
        if (SpreadsheetStore.SpreadsheetFormatType.XLSX.equals((Object)spreadsheetFormat)) {
            this.workbook = new XSSFWorkbook();
        } else if (SpreadsheetStore.SpreadsheetFormatType.XLS.equals((Object)spreadsheetFormat)) {
            this.workbook = new HSSFWorkbook();
        } else {
            throw new SpreadsheetException("Unsupported spreadsheet format: " + (Object)((Object)spreadsheetFormat));
        }
        this.documentUri = documentUri;
        this.create();
        this.documentInfoSheet = DocumentInfoSheet.openVersion(this.workbook, DOCUMENT_INFO_NAME, this.version, modelStore, copyManager);
        this.packageInfoSheet = PackageInfoSheet.openVersion(this.workbook, PACKAGE_INFO_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.extractedLicenseInfoSheet = ExtractedLicenseInfoSheet.openVersion(this.workbook, NON_STANDARD_LICENSE_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.perFileSheet = PerFileSheet.openVersion(this.workbook, PER_FILE_SHEET_NAME, this.version, modelStore, this.documentUri, copyManager);
        this.relationshipsSheet = new RelationshipsSheet(this.workbook, RELATIONSHIPS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.annotationsSheet = new AnnotationsSheet(this.workbook, ANNOTATIONS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.reviewersSheet = new ReviewersSheet(this.workbook, REVIEWERS_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.snippetSheet = new SnippetSheet(this.workbook, SNIPPET_SHEET_NAME, modelStore, this.documentUri, copyManager);
        this.externalRefsSheet = new ExternalRefsSheet(this.workbook, EXTERNAL_REFS_SHEET_NAME, modelStore, this.documentUri, copyManager);
    }

    private void create() throws SpreadsheetException {
        DocumentInfoSheet.create(this.workbook, DOCUMENT_INFO_NAME, this.documentUri);
        PackageInfoSheet.create(this.workbook, PACKAGE_INFO_SHEET_NAME);
        ExternalRefsSheet.create(this.workbook, EXTERNAL_REFS_SHEET_NAME);
        ExtractedLicenseInfoSheet.create(this.workbook, NON_STANDARD_LICENSE_SHEET_NAME);
        PerFileSheet.create(this.workbook, PER_FILE_SHEET_NAME);
        RelationshipsSheet.create(this.workbook, RELATIONSHIPS_SHEET_NAME);
        AnnotationsSheet.create(this.workbook, ANNOTATIONS_SHEET_NAME);
        SnippetSheet.create(this.workbook, SNIPPET_SHEET_NAME);
        ReviewersSheet.create(this.workbook, REVIEWERS_SHEET_NAME);
    }

    public void clear() {
        this.documentInfoSheet.clear();
        this.packageInfoSheet.clear();
        this.extractedLicenseInfoSheet.clear();
        this.perFileSheet.clear();
        this.relationshipsSheet.clear();
        this.annotationsSheet.clear();
        this.reviewersSheet.clear();
        this.snippetSheet.clear();
        this.externalRefsSheet.clear();
    }

    private String readVersion(Workbook workbook, String originSheetName) throws SpreadsheetException {
        Sheet sheet = workbook.getSheet(originSheetName);
        if (sheet == null) {
            throw new SpreadsheetException("Invalid SPDX spreadsheet.  Sheet " + originSheetName + " does not exist.");
        }
        int firstRowNum = sheet.getFirstRowNum();
        Row dataRow = sheet.getRow(firstRowNum + 1);
        if (dataRow == null) {
            return UNKNOWN_VERSION;
        }
        Cell versionCell = dataRow.getCell(0);
        if (versionCell == null) {
            return UNKNOWN_VERSION;
        }
        return versionCell.getStringCellValue();
    }

    public static boolean verifyVersion(String ver) {
        return SUPPORTED_VERSIONS.contains(ver);
    }

    public String verifyWorkbook() {
        String retval = this.documentInfoSheet.verify();
        if (retval == null || retval.isEmpty()) {
            retval = this.packageInfoSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.extractedLicenseInfoSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.perFileSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.reviewersSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.relationshipsSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.annotationsSheet.verify();
        }
        if ((retval == null || retval.isEmpty()) && VERSION_2_0_0.compareTo(this.version) < 0) {
            retval = this.snippetSheet.verify();
        }
        if ((retval == null || retval.isEmpty()) && VERSION_2_0_0.compareTo(this.version) < 0) {
            retval = this.externalRefsSheet.verify();
        }
        return retval;
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public DocumentInfoSheet getOriginsSheet() {
        return this.documentInfoSheet;
    }

    public void setOriginsSheet(DocumentInfoSheet originsSheet) {
        this.documentInfoSheet = originsSheet;
    }

    public PackageInfoSheet getPackageInfoSheet() {
        return this.packageInfoSheet;
    }

    public PerFileSheet getPerFileSheet() {
        return this.perFileSheet;
    }

    public ReviewersSheet getReviewersSheet() {
        return this.reviewersSheet;
    }

    public void setReviewersSheet(ReviewersSheet reviewersSheet) {
        this.reviewersSheet = reviewersSheet;
    }

    public RelationshipsSheet getRelationshipsSheet() {
        return this.relationshipsSheet;
    }

    public void setRelationshipsSheet(RelationshipsSheet relationshipsSheet) {
        this.relationshipsSheet = relationshipsSheet;
    }

    public AnnotationsSheet getAnnotationsSheet() {
        return this.annotationsSheet;
    }

    public void setAnnotationsSheet(AnnotationsSheet annotationsSheet) {
        this.annotationsSheet = annotationsSheet;
    }

    public void setPackageInfoSheet(PackageInfoSheet packageInfoSheet) {
        this.packageInfoSheet = packageInfoSheet;
    }

    public void setPerFileSheet(PerFileSheet perFileSheet) {
        this.perFileSheet = perFileSheet;
    }

    public SnippetSheet getSnippetSheet() {
        return this.snippetSheet;
    }

    public void setSnippetSheet(SnippetSheet snippetSheet) {
        this.snippetSheet = snippetSheet;
    }

    public ExternalRefsSheet getExternalRefsSheet() {
        return this.externalRefsSheet;
    }

    public void setExternaRefsSheet(ExternalRefsSheet externalRefsSheet) {
        this.externalRefsSheet = externalRefsSheet;
    }

    public DocumentInfoSheet getDocumentInfoSheet() {
        return this.documentInfoSheet;
    }

    public void setDocumentInfoSheet(DocumentInfoSheet documentInfoSheet) {
        this.documentInfoSheet = documentInfoSheet;
    }

    public ExtractedLicenseInfoSheet getExtractedLicenseInfoSheet() {
        return this.extractedLicenseInfoSheet;
    }

    public void setExtractedLicenseInfoSheet(ExtractedLicenseInfoSheet extractedLicenseInfoSheet) {
        this.extractedLicenseInfoSheet = extractedLicenseInfoSheet;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public IModelStore getModelStore() {
        return this.modelStore;
    }

    public String getVersion() {
        return this.version;
    }

    public ModelCopyManager getCopyManager() {
        return this.copyManager;
    }

    public void setExternalRefsSheet(ExternalRefsSheet externalRefsSheet) {
        this.externalRefsSheet = externalRefsSheet;
    }

    public void resizeRow() {
        this.extractedLicenseInfoSheet.resizeRows();
        this.packageInfoSheet.resizeRows();
        this.perFileSheet.resizeRows();
        this.relationshipsSheet.resizeRows();
        this.annotationsSheet.resizeRows();
        if (this.snippetSheet != null) {
            this.snippetSheet.resizeRows();
        }
        if (this.externalRefsSheet != null) {
            this.externalRefsSheet.resizeRows();
        }
    }

    public void write(OutputStream stream) throws IOException {
        this.workbook.write(stream);
    }
}

