/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class AnnotationsSheet
extends AbstractSheet {
    static final int ID_COL = 0;
    static final int COMMENT_COL = 1;
    static final int DATE_COL = 2;
    static final int ANNOTATOR_COL = 3;
    static final int TYPE_COL = 4;
    static final int USER_DEFINED_COL = 5;
    static final int NUM_COLS = 5;
    static final String[] HEADER_TITLES = new String[]{"SPDX Identifier being Annotated", "Annotation Comment", "Annotation Date", "Annotator", "Annotation Type", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{25, 70, 25, 60, 20, 50};
    static final boolean[] LEFT_WRAP = new boolean[]{false, true, false, true, false, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, false, true, false, true, false};
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, true, false};
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public AnnotationsSheet(Workbook workbook, String annotationsSheetName, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, annotationsSheetName, modelStore, documentUri, copyManager);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for Annotations does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 5; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for Annotation worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying Annotations worksheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 5; ++i) {
            Cell cell = row.getCell(i);
            if (REQUIRED[i] && cell == null) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum()) + " in annotation sheet";
            }
            if (i != 4 || cell.getStringCellValue() == null) continue;
            try {
                AnnotationType type = AnnotationType.valueOf((String)cell.getStringCellValue());
                if (type != null) continue;
                return "Invalid annotation type in row " + String.valueOf(row) + ": " + cell.getStringCellValue();
            }
            catch (Exception ex) {
                return "Invalid annotation type in row " + String.valueOf(row) + ": " + cell.getStringCellValue();
            }
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(Annotation annotation, String elementId) throws SpreadsheetException {
        Row row = this.addRow();
        if (elementId != null) {
            Cell idCell = row.createCell(0, CellType.STRING);
            idCell.setCellValue(elementId);
        }
        try {
            if (annotation.getComment() != null) {
                row.createCell(1).setCellValue(annotation.getComment());
            }
            if (annotation.getAnnotationDate() != null) {
                row.createCell(2).setCellValue(annotation.getAnnotationDate());
            }
            if (annotation.getAnnotator() != null) {
                row.createCell(3).setCellValue(annotation.getAnnotator());
            }
            if (annotation.getAnnotationType() != null) {
                row.createCell(4).setCellValue(annotation.getAnnotationType().toString());
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error getting annotation", e);
        }
    }

    public String getElmementId(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(0).getStringCellValue();
    }

    public Annotation getAnnotation(int rowNum) throws SpreadsheetException {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String comment = null;
        Cell commentCell = row.getCell(1);
        if (commentCell == null) {
            throw new SpreadsheetException("Missing required annotation comment");
        }
        comment = commentCell.getStringCellValue();
        String date = null;
        Cell dateCell = row.getCell(2);
        if (dateCell == null || dateCell.getCellType() == CellType.BLANK) {
            throw new SpreadsheetException("Missing required annotation date");
        }
        if (dateCell.getCellType() == CellType.STRING) {
            date = dateCell.getStringCellValue();
        } else if (dateCell.getCellType() == CellType.NUMERIC) {
            date = this.dateFormat.format(dateCell.getDateCellValue());
        }
        String annotator = null;
        Cell annotatorCell = row.getCell(3);
        if (annotatorCell == null) {
            throw new SpreadsheetException("Missing required annotator");
        }
        annotator = annotatorCell.getStringCellValue();
        AnnotationType type = null;
        Cell typeCell = row.getCell(4);
        if (typeCell != null) {
            try {
                type = AnnotationType.valueOf((String)typeCell.getStringCellValue().trim());
            }
            catch (Exception ex) {
                throw new SpreadsheetException("Invalid annotation type");
            }
        } else {
            throw new SpreadsheetException("Missing required spreadsheet type");
        }
        try {
            Annotation retval = new Annotation(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
            retval.setAnnotationDate(date);
            retval.setAnnotationType(type);
            retval.setAnnotator(annotator);
            retval.setComment(comment);
            return retval;
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error creating annotation", e);
        }
    }
}

