/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.PackageInfoSheet;
import org.spdx.spreadsheetstore.SpdxSpreadsheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class PackageInfoSheetV2d1
extends PackageInfoSheet {
    int NAME_COL = 0;
    int ID_COL = this.NAME_COL + 1;
    int VERSION_COL = this.ID_COL + 1;
    int MACHINE_NAME_COL = this.VERSION_COL + 1;
    int SUPPLIER_COL = this.MACHINE_NAME_COL + 1;
    int ORIGINATOR_COL = this.SUPPLIER_COL + 1;
    int HOME_PAGE_COL = this.ORIGINATOR_COL + 1;
    int DOWNLOAD_URL_COL = this.HOME_PAGE_COL + 1;
    int PACKAGE_CHECKSUMS_COL = this.DOWNLOAD_URL_COL + 1;
    int FILE_VERIFICATION_VALUE_COL = this.PACKAGE_CHECKSUMS_COL + 1;
    int VERIFICATION_EXCLUDED_FILES_COL = this.FILE_VERIFICATION_VALUE_COL + 1;
    int SOURCE_INFO_COL = this.VERIFICATION_EXCLUDED_FILES_COL + 1;
    int DECLARED_LICENSE_COL = this.SOURCE_INFO_COL + 1;
    int CONCLUDED_LICENSE_COL = this.DECLARED_LICENSE_COL + 1;
    int LICENSE_INFO_IN_FILES_COL = this.CONCLUDED_LICENSE_COL + 1;
    int LICENSE_COMMENT_COL = this.LICENSE_INFO_IN_FILES_COL + 1;
    int DECLARED_COPYRIGHT_COL = this.LICENSE_COMMENT_COL + 1;
    int SHORT_DESC_COL = this.DECLARED_COPYRIGHT_COL + 1;
    int FULL_DESC_COL = this.SHORT_DESC_COL + 1;
    int FILES_ANALYZED_COL = this.FULL_DESC_COL + 1;
    int USER_DEFINED_COL;
    int NUM_COLS = this.USER_DEFINED_COL = this.FILES_ANALYZED_COL + 1;
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, true, true, false, false, true, false, false, false, false, false};
    static final String[] HEADER_TITLES = new String[]{"Package Name", "SPDX Identifier", "Package Version", "Package FileName", "Package Supplier", "Package Originator", "Home Page", "Package Download Location", "Package Checksum", "Package Verification Code", "Verification Code Excluded Files", "Source Info", "License Declared", "License Concluded", "License Info From Files", "License Comments", "Package Copyright Text", "Summary", "Description", "Files Analyzed", "External Refs", "User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{30, 17, 17, 30, 30, 30, 50, 50, 75, 60, 40, 30, 40, 40, 90, 50, 50, 50, 80, 10, 50, 50};

    public PackageInfoSheetV2d1(Workbook workbook, String sheetName, String version, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, version, modelStore, documentUri, copyManager);
        this.version = version;
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Package Info does not exist";
            }
            if (!SpdxSpreadsheet.verifyVersion(this.version)) {
                return "Unsupported version " + this.version;
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < this.NUM_COLS - 1; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Package Info worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Unexpected error in verifying SPDX Package Info work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < this.NUM_COLS; ++i) {
            String filesAnalyzedStr;
            Cell filesAnalyzedCell;
            String error;
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum() + " in PackageInfo sheet.");
            }
            if (i == this.DECLARED_LICENSE_COL || i == this.CONCLUDED_LICENSE_COL) {
                try {
                    LicenseInfoFactory.parseSPDXLicenseString((String)cell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
                    continue;
                }
                catch (InvalidSPDXAnalysisException ex) {
                    if (i == this.DECLARED_LICENSE_COL) {
                        return "Invalid declared license in row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage() + " in PackageInfo sheet.";
                    }
                    return "Invalid seen license in row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage() + " in PackageInfo sheet.";
                }
            }
            if (i == this.LICENSE_INFO_IN_FILES_COL) {
                String[] licenses = row.getCell(this.LICENSE_INFO_IN_FILES_COL).getStringCellValue().split(",");
                if (licenses.length < 1) {
                    return "Missing licenss information in files in PackageInfo sheet.";
                }
                for (int j = 0; j < licenses.length; ++j) {
                    try {
                        LicenseInfoFactory.parseSPDXLicenseString((String)licenses[j], (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
                        continue;
                    }
                    catch (InvalidSPDXAnalysisException ex) {
                        return "Invalid license information in in files for license " + licenses[j] + " row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage() + " in PackageInfo sheet.";
                    }
                }
                continue;
            }
            if (i == this.ORIGINATOR_COL) {
                String originator;
                Cell origCell = row.getCell(this.ORIGINATOR_COL);
                if (origCell == null || (originator = origCell.getStringCellValue()) == null || originator.isEmpty() || (error = SpdxVerificationHelper.verifyOriginator((String)originator)) == null || error.isEmpty()) continue;
                return "Invalid originator in row " + String.valueOf(row.getRowNum()) + ": " + error + " in PackageInfo sheet.";
            }
            if (i == this.SUPPLIER_COL) {
                String supplier;
                Cell supplierCell = row.getCell(this.SUPPLIER_COL);
                if (supplierCell == null || (supplier = supplierCell.getStringCellValue()) == null || supplier.isEmpty() || (error = SpdxVerificationHelper.verifySupplier((String)supplier)) == null || error.isEmpty()) continue;
                return "Invalid supplier in row " + String.valueOf(row.getRowNum()) + ": " + error + " in PackageInfo sheet.";
            }
            if (i != this.FILES_ANALYZED_COL || (filesAnalyzedCell = row.getCell(this.FILES_ANALYZED_COL)) == null || filesAnalyzedCell.getStringCellValue() == null || (filesAnalyzedStr = filesAnalyzedCell.getStringCellValue().trim().toLowerCase()).equals("true") || filesAnalyzedStr.equals("false")) continue;
            return "Invalid value for files analyzed (expecting 'true' or 'false') in row " + String.valueOf(row.getRowNum()) + ":" + filesAnalyzedStr;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    @Override
    public void add(SpdxPackage pkgInfo) throws InvalidSPDXAnalysisException {
        Optional homepage;
        Optional supplier;
        Optional originator;
        Optional version;
        Optional sourceInfo;
        Optional summary;
        Optional licenseComments;
        Optional description;
        Row row = this.addRow();
        Cell nameCell = row.createCell(this.NAME_COL);
        Optional name = pkgInfo.getName();
        if (name.isPresent()) {
            nameCell.setCellValue((String)name.get());
        }
        Cell idCell = row.createCell(this.ID_COL);
        idCell.setCellValue(pkgInfo.getId());
        Cell copyrightCell = row.createCell(this.DECLARED_COPYRIGHT_COL);
        copyrightCell.setCellValue(pkgInfo.getCopyrightText());
        Cell DeclaredLicenseCol = row.createCell(this.DECLARED_LICENSE_COL);
        DeclaredLicenseCol.setCellValue(pkgInfo.getLicenseDeclared().toString());
        Cell concludedLicenseCol = row.createCell(this.CONCLUDED_LICENSE_COL);
        concludedLicenseCol.setCellValue(pkgInfo.getLicenseConcluded().toString());
        Cell fileChecksumCell = row.createCell(this.FILE_VERIFICATION_VALUE_COL);
        Optional verificationCode = pkgInfo.getPackageVerificationCode();
        if (verificationCode.isPresent()) {
            fileChecksumCell.setCellValue(((SpdxPackageVerificationCode)verificationCode.get()).getValue());
            Cell verificationExcludedFilesCell = row.createCell(this.VERIFICATION_EXCLUDED_FILES_COL);
            StringBuilder excFilesStr = new StringBuilder();
            Collection excludedFileCollection = ((SpdxPackageVerificationCode)verificationCode.get()).getExcludedFileNames();
            if (excludedFileCollection.size() > 0) {
                String[] excludedFiles = excludedFileCollection.toArray(new String[excludedFileCollection.size()]);
                excFilesStr.append(excludedFiles[0]);
                for (int i = 1; i < excludedFiles.length; ++i) {
                    excFilesStr.append(", ");
                    excFilesStr.append(excludedFiles[i]);
                }
            }
            verificationExcludedFilesCell.setCellValue(excFilesStr.toString());
        }
        if ((description = pkgInfo.getDescription()).isPresent()) {
            Cell descCell = row.createCell(this.FULL_DESC_COL);
            descCell.setCellValue((String)description.get());
        }
        Cell fileNameCell = row.createCell(this.MACHINE_NAME_COL);
        Optional packageFileName = pkgInfo.getPackageFileName();
        if (packageFileName.isPresent()) {
            fileNameCell.setCellValue((String)packageFileName.get());
        }
        Cell checksumsCell = row.createCell(this.PACKAGE_CHECKSUMS_COL);
        Collection checksums = pkgInfo.getChecksums();
        checksumsCell.setCellValue(this.checksumsToString(checksums));
        Collection licenseInfosInFilesCollection = pkgInfo.getLicenseInfoFromFiles();
        if (licenseInfosInFilesCollection != null && licenseInfosInFilesCollection.size() > 0) {
            AnyLicenseInfo[] licenseInfosInFiles = licenseInfosInFilesCollection.toArray(new AnyLicenseInfo[licenseInfosInFilesCollection.size()]);
            StringBuilder sb = new StringBuilder(licenseInfosInFiles[0].toString());
            for (int i = 1; i < licenseInfosInFiles.length; ++i) {
                sb.append(',');
                sb.append(licenseInfosInFiles[i].toString());
            }
            row.createCell(this.LICENSE_INFO_IN_FILES_COL).setCellValue(sb.toString());
        }
        if ((licenseComments = pkgInfo.getLicenseComments()).isPresent()) {
            row.createCell(this.LICENSE_COMMENT_COL).setCellValue((String)licenseComments.get());
        }
        if ((summary = pkgInfo.getSummary()).isPresent()) {
            Cell shortDescCell = row.createCell(this.SHORT_DESC_COL);
            shortDescCell.setCellValue((String)summary.get());
        }
        if ((sourceInfo = pkgInfo.getSourceInfo()).isPresent()) {
            Cell sourceInfoCell = row.createCell(this.SOURCE_INFO_COL);
            sourceInfoCell.setCellValue((String)sourceInfo.get());
        }
        Cell urlCell = row.createCell(this.DOWNLOAD_URL_COL);
        Optional downloadLocation = pkgInfo.getDownloadLocation();
        if (downloadLocation.isPresent()) {
            urlCell.setCellValue((String)downloadLocation.get());
        }
        if ((version = pkgInfo.getVersionInfo()).isPresent()) {
            Cell versionInfoCell = row.createCell(this.VERSION_COL);
            versionInfoCell.setCellValue((String)version.get());
        }
        if ((originator = pkgInfo.getOriginator()).isPresent()) {
            Cell originatorCell = row.createCell(this.ORIGINATOR_COL);
            originatorCell.setCellValue((String)originator.get());
        }
        if ((supplier = pkgInfo.getSupplier()).isPresent()) {
            Cell supplierCell = row.createCell(this.SUPPLIER_COL);
            supplierCell.setCellValue((String)supplier.get());
        }
        if ((homepage = pkgInfo.getHomepage()).isPresent()) {
            Cell homePageCell = row.createCell(this.HOME_PAGE_COL);
            homePageCell.setCellValue((String)homepage.get());
        }
        Cell filesAnalyzedCell = row.createCell(this.FILES_ANALYZED_COL);
        if (pkgInfo.isFilesAnalyzed()) {
            filesAnalyzedCell.setCellValue("true");
        } else {
            filesAnalyzedCell.setCellValue("false");
        }
    }

    @Override
    public List<SpdxPackage> getPackages() throws SpreadsheetException {
        ArrayList<SpdxPackage> retval = new ArrayList<SpdxPackage>();
        for (int i = 0; i < this.getNumDataRows(); ++i) {
            retval.add(this.getPackage(this.getFirstDataRow() + i));
        }
        return retval;
    }

    private SpdxPackage getPackage(int rowNum) throws SpreadsheetException {
        Cell filesAnalyzedCell;
        Cell homePageCell;
        Cell originatorCell;
        Cell supplierCell;
        Cell versionInfoCell;
        Cell packageVerificationCell;
        Cell downloadUrlCell;
        Cell descCell;
        Cell shortDescCell;
        Cell licenseCommentCell;
        Cell licenseInfoInFilesCell;
        Cell sourceInfocol;
        Collection<Checksum> checksums;
        AnyLicenseInfo declaredLicenses;
        SpdxNoneLicense concludedLicense;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell nameCell = row.getCell(this.NAME_COL);
        if (nameCell == null || nameCell.getStringCellValue().isEmpty()) {
            return null;
        }
        String error = this.validateRow(row);
        if (error != null && !error.isEmpty()) {
            throw new SpreadsheetException(error);
        }
        String declaredName = nameCell.getStringCellValue();
        String id = row.getCell(this.ID_COL).getStringCellValue();
        Cell concludedLicensesCell = row.getCell(this.CONCLUDED_LICENSE_COL);
        if (concludedLicensesCell != null && !concludedLicensesCell.getStringCellValue().isEmpty()) {
            try {
                concludedLicense = LicenseInfoFactory.parseSPDXLicenseString((String)concludedLicensesCell.getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
            }
            catch (InvalidLicenseStringException e) {
                throw new SpreadsheetException("Invalid concluded license file for package " + declaredName, e);
            }
        }
        try {
            concludedLicense = new SpdxNoneLicense();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Invalid license infos from file for package " + declaredName, e);
        }
        String declaredCopyright = row.getCell(this.DECLARED_COPYRIGHT_COL).getStringCellValue();
        try {
            declaredLicenses = LicenseInfoFactory.parseSPDXLicenseString((String)row.getCell(this.DECLARED_LICENSE_COL).getStringCellValue(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager);
        }
        catch (InvalidLicenseStringException e1) {
            throw new SpreadsheetException("Invalid declared license  for package " + declaredName, e1);
        }
        Cell checksumsCell = row.getCell(this.PACKAGE_CHECKSUMS_COL);
        if (Objects.isNull(checksumsCell)) {
            throw new SpreadsheetException("Missing required checksum for package");
        }
        try {
            checksums = this.strToChecksums(checksumsCell.getStringCellValue());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error converting file checksums: " + e.getMessage());
        }
        SpdxPackage.SpdxPackageBuilder retval = new SpdxPackage.SpdxPackageBuilder(this.modelStore, this.documentUri, id, this.copyManager, declaredName, (AnyLicenseInfo)concludedLicense, declaredCopyright, declaredLicenses).setChecksums(checksums);
        Cell machineNameCell = row.getCell(this.MACHINE_NAME_COL);
        if (Objects.nonNull(machineNameCell)) {
            retval.setPackageFileName(row.getCell(this.MACHINE_NAME_COL).getStringCellValue());
        }
        if (Objects.nonNull(sourceInfocol = row.getCell(this.SOURCE_INFO_COL))) {
            retval.setSourceInfo(sourceInfocol.getStringCellValue());
        }
        if (Objects.nonNull(licenseInfoInFilesCell = row.getCell(this.LICENSE_INFO_IN_FILES_COL))) {
            String[] licenseStrings = row.getCell(this.LICENSE_INFO_IN_FILES_COL).getStringCellValue().split(",");
            ArrayList<AnyLicenseInfo> licenseInfosFromFiles = new ArrayList<AnyLicenseInfo>();
            for (int i = 0; i < licenseStrings.length; ++i) {
                try {
                    licenseInfosFromFiles.add(LicenseInfoFactory.parseSPDXLicenseString((String)licenseStrings[i].trim(), (IModelStore)this.modelStore, (String)this.documentUri, (ModelCopyManager)this.copyManager));
                    continue;
                }
                catch (InvalidLicenseStringException e) {
                    throw new SpreadsheetException("Invalid license infos from file for package " + declaredName, e);
                }
            }
            retval.setLicenseInfosFromFile(licenseInfosFromFiles);
        }
        if (Objects.nonNull(licenseCommentCell = row.getCell(this.LICENSE_COMMENT_COL)) && !licenseCommentCell.getStringCellValue().isEmpty()) {
            retval.setLicenseComments(licenseCommentCell.getStringCellValue());
        }
        if (Objects.nonNull(shortDescCell = row.getCell(this.SHORT_DESC_COL)) && !shortDescCell.getStringCellValue().isEmpty()) {
            retval.setSummary(shortDescCell.getStringCellValue());
        }
        if (Objects.nonNull(descCell = row.getCell(this.FULL_DESC_COL)) && !descCell.getStringCellValue().isEmpty()) {
            retval.setDescription(descCell.getStringCellValue());
        }
        if ((downloadUrlCell = row.getCell(this.DOWNLOAD_URL_COL)) != null) {
            retval.setDownloadLocation(downloadUrlCell.getStringCellValue());
        }
        if (Objects.nonNull(packageVerificationCell = row.getCell(this.FILE_VERIFICATION_VALUE_COL))) {
            String packageVerificationValue = packageVerificationCell.getStringCellValue();
            ArrayList<String> excludedFiles = new ArrayList<String>();
            Cell excludedFilesCell = row.getCell(this.VERIFICATION_EXCLUDED_FILES_COL);
            String excludedFilesStr = null;
            if (excludedFilesCell != null) {
                excludedFilesStr = excludedFilesCell.getStringCellValue();
            }
            if (excludedFilesStr != null && !excludedFilesStr.isEmpty()) {
                for (String excludedFile : excludedFilesStr.split(",")) {
                    excludedFiles.add(excludedFile.trim());
                }
            }
            try {
                SpdxPackageVerificationCode verificationCode = new SpdxPackageVerificationCode(this.modelStore, this.documentUri, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentUri), this.copyManager, true);
                verificationCode.setValue(packageVerificationValue);
                verificationCode.getExcludedFileNames().addAll(excludedFiles);
                retval.setPackageVerificationCode(verificationCode);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException("Invalid verification code for package " + declaredName, e);
            }
        }
        if (Objects.nonNull(versionInfoCell = row.getCell(this.VERSION_COL))) {
            String versionInfo = versionInfoCell.getCellType() == CellType.STRING && !versionInfoCell.getStringCellValue().isEmpty() ? versionInfoCell.getStringCellValue() : (versionInfoCell.getCellType() == CellType.NUMERIC ? Double.toString(versionInfoCell.getNumericCellValue()) : "");
            retval.setVersionInfo(versionInfo);
        }
        if (Objects.nonNull(supplierCell = row.getCell(this.SUPPLIER_COL)) && !supplierCell.getStringCellValue().isEmpty()) {
            retval.setSupplier(supplierCell.getStringCellValue());
        }
        if (Objects.nonNull(originatorCell = row.getCell(this.ORIGINATOR_COL)) && !originatorCell.getStringCellValue().isEmpty()) {
            retval.setOriginator(originatorCell.getStringCellValue());
        }
        if (Objects.nonNull(homePageCell = row.getCell(this.HOME_PAGE_COL)) && !homePageCell.getStringCellValue().isEmpty()) {
            retval.setHomepage(homePageCell.getStringCellValue());
        }
        if (Objects.nonNull(filesAnalyzedCell = row.getCell(this.FILES_ANALYZED_COL))) {
            boolean filesAnalyzed = true;
            if (filesAnalyzedCell.getCellType() == CellType.BOOLEAN) {
                filesAnalyzed = filesAnalyzedCell.getBooleanCellValue();
            } else {
                String filesAnalyzedStr = filesAnalyzedCell.getStringCellValue();
                if (filesAnalyzedStr != null && filesAnalyzedStr.toLowerCase().trim().equals("false")) {
                    filesAnalyzed = false;
                }
            }
            retval.setFilesAnalyzed(filesAnalyzed);
        }
        try {
            return retval.build();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new SpreadsheetException("Error building package " + declaredName, e);
        }
    }
}

